/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;

@GwtCompatible
final class MediumCharMatcher
extends CharMatcher {
    static final int MAX_SIZE = 1023;
    private final char[] table;
    private final boolean containsZero;
    private final long filter;
    private static final double DESIRED_LOAD_FACTOR = 0.5;

    private MediumCharMatcher(char[] table, long filter, boolean containsZero, String description) {
        super(description);
        this.table = table;
        this.filter = filter;
        this.containsZero = containsZero;
    }

    private boolean checkFilter(int c2) {
        return 1L == (1L & this.filter >> c2);
    }

    @VisibleForTesting
    static int chooseTableSize(int setSize) {
        if (setSize == 1) {
            return 2;
        }
        int tableSize = Integer.highestOneBit(setSize - 1) << 1;
        while ((double)tableSize * 0.5 < (double)setSize) {
            tableSize <<= 1;
        }
        return tableSize;
    }

    @Override
    public CharMatcher precomputed() {
        return this;
    }

    static CharMatcher from(char[] chars, String description) {
        long filter = 0L;
        int size = chars.length;
        boolean containsZero = chars[0] == '\u0000';
        for (char c2 : chars) {
            filter |= 1L << c2;
        }
        char[] table = new char[MediumCharMatcher.chooseTableSize(size)];
        int mask = table.length - 1;
        for (char c3 : chars) {
            int index = c3 & mask;
            while (true) {
                if (table[index] == '\u0000') break;
                index = index + 1 & mask;
            }
            table[index] = c3;
        }
        return new MediumCharMatcher(table, filter, containsZero, description);
    }

    @Override
    public boolean matches(char c2) {
        int startingIndex;
        if (c2 == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c2)) {
            return false;
        }
        int mask = this.table.length - 1;
        int index = startingIndex = c2 & mask;
        do {
            if (this.table[index] == '\u0000') {
                return false;
            }
            if (this.table[index] != c2) continue;
            return true;
        } while ((index = index + 1 & mask) != startingIndex);
        return false;
    }
}

