/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;

@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public String to(CaseFormat format, String s2) {
        if (format == null) {
            throw new NullPointerException();
        }
        if (s2 == null) {
            throw new NullPointerException();
        }
        if (format == this) {
            return s2;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (format) {
                    case LOWER_UNDERSCORE: {
                        return s2.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s2.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return Ascii.toLowerCase(s2.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return Ascii.toLowerCase(s2);
                    }
                }
            }
        }
        StringBuilder out = null;
        int i2 = 0;
        int j2 = -1;
        while (true) {
            ++j2;
            if ((j2 = this.wordBoundary.indexIn(s2, j2)) == -1) break;
            if (i2 == 0) {
                out = new StringBuilder(s2.length() + 4 * this.wordSeparator.length());
                out.append(format.normalizeFirstWord(s2.substring(i2, j2)));
            } else {
                out.append(format.normalizeWord(s2.substring(i2, j2)));
            }
            out.append(format.wordSeparator);
            i2 = j2 + this.wordSeparator.length();
        }
        if (i2 == 0) {
            return format.normalizeFirstWord(s2);
        }
        out.append(format.normalizeWord(s2.substring(i2)));
        return out.toString();
    }

    private String normalizeFirstWord(String word) {
        switch (this) {
            case LOWER_CAMEL: {
                return Ascii.toLowerCase(word);
            }
        }
        return this.normalizeWord(word);
    }

    private String normalizeWord(String word) {
        switch (this) {
            case LOWER_HYPHEN: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_UNDERSCORE: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_UNDERSCORE: {
                return Ascii.toUpperCase(word);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String word) {
        int length = word.length();
        if (length == 0) {
            return word;
        }
        return new StringBuilder(length).append(Ascii.toUpperCase(word.charAt(0))).append(Ascii.toLowerCase(word.substring(1))).toString();
    }
}

