/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.ui.panel.ReferenceFrame;

public class AlignmentInterval
extends Locus {
    private static Logger log = Logger.getLogger(AlignmentInterval.class);
    Genome genome;
    private AlignmentCounts counts;
    private LinkedHashMap<String, List<Row>> groupedAlignmentRows;
    private SpliceJunctionHelper spliceJunctionHelper;
    private List<DownsampledInterval> downsampledIntervals;
    private AlignmentTrack.RenderOptions renderOptions;

    AlignmentInterval(AlignmentInterval interval) {
        this(interval.getChr(), interval.getStart(), interval.getEnd(), interval.getGroupedAlignments(), interval.getCounts(), new SpliceJunctionHelper(interval.getSpliceJunctionHelper()), interval.getDownsampledIntervals(), interval.renderOptions);
    }

    public AlignmentInterval(String chr, int start, int end, LinkedHashMap<String, List<Row>> groupedAlignmentRows, AlignmentCounts counts, SpliceJunctionHelper spliceJunctionHelper, List<DownsampledInterval> downsampledIntervals, AlignmentTrack.RenderOptions renderOptions) {
        super(chr, start, end);
        this.groupedAlignmentRows = groupedAlignmentRows;
        this.genome = GenomeManager.getInstance().getCurrentGenome();
        this.counts = counts;
        this.spliceJunctionHelper = spliceJunctionHelper;
        this.downsampledIntervals = downsampledIntervals;
        this.renderOptions = renderOptions;
    }

    static AlignmentInterval emptyAlignmentInterval(String chr, int start, int end) {
        return new AlignmentInterval(chr, start, end, null, null, null, null, null);
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f = features.get(idx);
            if (f.contains(right)) {
                return f;
            }
            if (f.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public LinkedHashMap<String, List<Row>> getGroupedAlignments() {
        return this.groupedAlignmentRows;
    }

    public int getGroupCount() {
        return this.groupedAlignmentRows == null ? 0 : this.groupedAlignmentRows.size();
    }

    public void setAlignmentRows(LinkedHashMap<String, List<Row>> alignmentRows, AlignmentTrack.RenderOptions renderOptions) {
        this.groupedAlignmentRows = alignmentRows;
        this.renderOptions = renderOptions;
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame, String tag) {
        double center = referenceFrame.getCenter();
        this.sortRows(option, center, tag);
    }

    public void sortRows(AlignmentTrack.SortOption option, double location, String tag) {
        if (this.groupedAlignmentRows == null) {
            return;
        }
        for (List<Row> alignmentRows : this.groupedAlignmentRows.values()) {
            for (Row row : alignmentRows) {
                row.updateScore(option, location, this, tag);
            }
            Collections.sort(alignmentRows);
        }
    }

    public byte getReference(int pos) {
        if (this.genome == null) {
            return 0;
        }
        return this.genome.getReference(this.getChr(), pos);
    }

    public AlignmentCounts getCounts() {
        return this.counts;
    }

    public int getCount(int pos, byte b) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getCount(pos, b);
        }
        return 0;
    }

    public int getMaxCount(int origin, int end) {
        return this.counts.getMaxCount(origin, end);
    }

    public int getTotalCount(int pos) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getTotalCount(pos);
        }
        return 0;
    }

    public int getNegCount(int pos, byte b) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getNegCount(pos, b);
        }
        return 0;
    }

    public int getPosCount(int pos, byte b) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getPosCount(pos, b);
        }
        return 0;
    }

    public int getDelCount(int pos) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getDelCount(pos);
        }
        return 0;
    }

    public int getInsCount(int pos) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getInsCount(pos);
        }
        return 0;
    }

    public Iterator<Alignment> getAlignmentIterator() {
        return new AlignmentIterator();
    }

    public List<DownsampledInterval> getDownsampledIntervals() {
        return this.downsampledIntervals;
    }

    public SpliceJunctionHelper getSpliceJunctionHelper() {
        return this.spliceJunctionHelper;
    }

    class AlignmentIterator
    implements Iterator<Alignment> {
        PriorityQueue<Row> rows;
        Alignment nextAlignment;

        AlignmentIterator() {
            this.rows = new PriorityQueue<Row>(5, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.getNextStartPos() - o2.getNextStartPos();
                }
            });
            for (List alignmentRows : AlignmentInterval.this.groupedAlignmentRows.values()) {
                for (Row r : alignmentRows) {
                    r.resetIdx();
                    this.rows.add(r);
                }
            }
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }

    public static class Row
    implements Comparable<Row> {
        int nextIdx = 0;
        private double score = 0.0;
        List<Alignment> alignments = new ArrayList<Alignment>(100);
        private int start;
        private int lastEnd;

        public void addAlignment(Alignment alignment) {
            if (this.alignments.isEmpty()) {
                this.start = alignment.getStart();
            }
            this.alignments.add(alignment);
            this.lastEnd = alignment.getEnd();
        }

        public void updateScore(AlignmentTrack.SortOption option, Locus locus, AlignmentInterval interval, String tag) {
            double mean = 0.0;
            int number = 0;
            for (int center = locus.getStart(); center < locus.getEnd(); ++center) {
                double value = this.calculateScore(option, center, interval, tag);
                mean = (double)number * (mean / (double)(number + 1)) + value / (double)(number + 1);
                ++number;
            }
            this.setScore(mean);
        }

        public void updateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval, String tag) {
            this.setScore(this.calculateScore(option, center, interval, tag));
        }

        public double calculateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval, String tag) {
            int adjustedCenter = (int)center;
            Alignment centerAlignment = AlignmentInterval.getFeatureContaining(this.alignments, adjustedCenter);
            if (centerAlignment == null) {
                return 2.147483647E9;
            }
            switch (option) {
                case START: {
                    return centerAlignment.getStart();
                }
                case STRAND: {
                    return centerAlignment.isNegativeStrand() ? -1.0 : 1.0;
                }
                case FIRST_OF_PAIR_STRAND: {
                    Strand strand = centerAlignment.getFirstOfPairStrand();
                    int score = 2;
                    if (strand != Strand.NONE) {
                        score = strand == Strand.NEGATIVE ? 1 : -1;
                    }
                    return score;
                }
                case NUCLEOTIDE: {
                    float baseScore;
                    AlignmentBlock[] insertions;
                    byte base = centerAlignment.getBase(adjustedCenter);
                    byte ref = interval.getReference(adjustedCenter);
                    int insertionScore = 0;
                    for (AlignmentBlock ins : insertions = centerAlignment.getInsertions()) {
                        int s = ins.getStart();
                        if (s != adjustedCenter && s - 1 != adjustedCenter) continue;
                        insertionScore += ins.getBases().length;
                    }
                    if (base == 78 || base == 110) {
                        baseScore = 2.0f;
                    } else if (base == ref) {
                        baseScore = 3.0f;
                    } else if (base == 0) {
                        int delCount = interval.getDelCount(adjustedCenter);
                        baseScore = delCount > 0 ? (float)(-delCount) : 1.0f;
                    } else {
                        int count = interval.getCount(adjustedCenter, base);
                        byte phred = centerAlignment.getPhred(adjustedCenter);
                        baseScore = -((float)count + (float)phred / 1000.0f);
                    }
                    return baseScore - (float)insertionScore;
                }
                case QUALITY: {
                    return -centerAlignment.getMappingQuality();
                }
                case SAMPLE: {
                    String sample = centerAlignment.getSample();
                    int score = sample == null ? 0 : sample.hashCode();
                    return score;
                }
                case READ_GROUP: {
                    String readGroup = centerAlignment.getReadGroup();
                    int score = readGroup == null ? 0 : readGroup.hashCode();
                    return score;
                }
                case INSERT_SIZE: {
                    return -Math.abs(centerAlignment.getInferredInsertSize());
                }
                case MATE_CHR: {
                    ReadMate mate = centerAlignment.getMate();
                    if (mate == null) {
                        return 2.147483647E9;
                    }
                    if (mate.getChr().equals(centerAlignment.getChr())) {
                        return 2.147483646E9;
                    }
                    return mate.getChr().hashCode();
                }
                case TAG: {
                    Object tagValue = centerAlignment.getAttribute(tag);
                    int score = tagValue == null ? 0 : tagValue.hashCode();
                    return score;
                }
            }
            return 2.147483647E9;
        }

        public Alignment nextAlignment() {
            if (this.nextIdx < this.alignments.size()) {
                Alignment tmp = this.alignments.get(this.nextIdx);
                ++this.nextIdx;
                return tmp;
            }
            return null;
        }

        public int getNextStartPos() {
            if (this.nextIdx < this.alignments.size()) {
                return this.alignments.get(this.nextIdx).getStart();
            }
            return Integer.MAX_VALUE;
        }

        public boolean hasNext() {
            return this.nextIdx < this.alignments.size();
        }

        public void resetIdx() {
            this.nextIdx = 0;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getStart() {
            return this.start;
        }

        public int getLastEnd() {
            return this.lastEnd;
        }

        @Override
        public int compareTo(Row o) {
            return (int)Math.signum(this.getScore() - o.getScore());
        }
    }
}

