/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.pedigree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sf.picard.io.IoUtil;
import net.sf.picard.pedigree.PedTrio;
import net.sf.picard.pedigree.Sex;
import net.sf.picard.util.Log;
import net.sf.samtools.util.RuntimeIOException;

public class PedFile
extends TreeMap<String, PedTrio> {
    private static final Log log = Log.getInstance(PedFile.class);
    static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public void add(PedTrio trio) {
        this.put(trio.getIndividualId(), trio);
    }

    public void write(File file) {
        IoUtil.assertFileIsWritable(file);
        BufferedWriter out = IoUtil.openFileForBufferedWriting(file);
        try {
            for (PedTrio trio : this.values()) {
                out.write(trio.getFamilyId());
                out.write("\t");
                out.write(trio.getIndividualId());
                out.write("\t");
                out.write(trio.getPaternalId());
                out.write("\t");
                out.write(trio.getMaternalId());
                out.write("\t");
                out.write(String.valueOf(trio.getSex().toCode()));
                out.write("\t");
                out.write(trio.getPhenotype().toString());
                out.newLine();
            }
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("IOException while writing to file " + file.getAbsolutePath(), ioe);
        }
    }

    public static PedFile fromFile(File file) {
        PedFile pedfile = new PedFile();
        IoUtil.assertFileIsReadable(file);
        for (String line : IoUtil.readLines(file)) {
            String[] fields = WHITESPACE.split(line);
            if (fields.length != 6) {
                log.error("Ped file line contained invalid number of fields, skipping: " + line);
                continue;
            }
            PedTrio trio = new PedTrio(fields[0], fields[1], fields[2], fields[3], Sex.fromCode(Integer.parseInt(fields[4])), fields[5].contains(".") ? Double.parseDouble(fields[5]) : (double)Integer.parseInt(fields[5]));
            pedfile.add(trio);
        }
        return pedfile;
    }

    public PedFile removeIncompleteTrios() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((PedTrio)iterator.next().getValue()).hasBothParents()) continue;
            iterator.remove();
        }
        return this;
    }
}

