/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineTranslator;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;

public class VCFSimpleHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private Map<String, String> genericFields = new LinkedHashMap<String, String>();

    public VCFSimpleHeaderLine(String key, String name, String description) {
        super(key, "");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put("Description", description);
        this.initialize(name, map);
    }

    public VCFSimpleHeaderLine(String line, VCFHeaderVersion version, String key, List<String> expectedTagOrdering) {
        this(key, VCFHeaderLineTranslator.parseLine(version, line, expectedTagOrdering));
    }

    public VCFSimpleHeaderLine(String key, Map<String, String> mapping) {
        super(key, "");
        this.name = mapping.get("ID");
        this.initialize(this.name, mapping);
    }

    String getGenericFieldValue(String key) {
        return this.genericFields.get(key);
    }

    protected void initialize(String name, Map<String, String> genericFields) {
        if (name == null || genericFields == null || genericFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid VCFSimpleHeaderLine: key=%s name=%s", super.getKey(), name));
        }
        if (name.contains("<") || name.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (name.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        this.name = name;
        this.genericFields.putAll(genericFields);
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ID", this.name);
        map.putAll(this.genericFields);
        return this.getKey() + "=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VCFSimpleHeaderLine)) {
            return false;
        }
        VCFSimpleHeaderLine other = (VCFSimpleHeaderLine)o;
        if (!this.name.equals(other.name) || this.genericFields.size() != other.genericFields.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.genericFields.entrySet()) {
            if (entry.getValue().equals(other.genericFields.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getID() {
        return this.name;
    }
}

