/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.smithwaterman;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.smithwaterman.Parameters;
import org.broadinstitute.sting.utils.smithwaterman.SWParameterSet;
import org.broadinstitute.sting.utils.smithwaterman.SmithWaterman;

public class SWPairwiseAlignment
implements SmithWaterman {
    protected SWPairwiseAlignmentResult alignmentResult;
    protected final Parameters parameters;
    protected static boolean cutoff = false;
    protected OVERHANG_STRATEGY overhang_strategy = OVERHANG_STRATEGY.SOFTCLIP;
    protected double[] SW = null;
    protected static boolean keepScoringMatrix = false;

    @Deprecated
    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, double match, double mismatch, double open, double extend) {
        this(seq1, seq2, new Parameters(match, mismatch, open, extend));
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, Parameters parameters) {
        this(parameters);
        this.align(seq1, seq2);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, OVERHANG_STRATEGY strategy) {
        this(SWParameterSet.ORIGINAL_DEFAULT.parameters);
        this.overhang_strategy = strategy;
        this.align(seq1, seq2);
    }

    protected SWPairwiseAlignment(Parameters parameters) {
        this.parameters = parameters;
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, SWParameterSet namedParameters) {
        this(seq1, seq2, namedParameters.parameters);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2) {
        this(seq1, seq2, SWParameterSet.ORIGINAL_DEFAULT);
    }

    @Override
    public Cigar getCigar() {
        return this.alignmentResult.cigar;
    }

    @Override
    public int getAlignmentStart2wrt1() {
        return this.alignmentResult.alignment_offset;
    }

    protected void align(byte[] reference, byte[] alternate) {
        if (reference == null || reference.length == 0 || alternate == null || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int n = reference.length;
        int m = alternate.length;
        double[] sw = new double[(n + 1) * (m + 1)];
        if (keepScoringMatrix) {
            this.SW = sw;
        }
        int[] btrack = new int[(n + 1) * (m + 1)];
        this.calculateMatrix(reference, alternate, sw, btrack);
        this.alignmentResult = this.calculateCigar(n, m, sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, double[] sw, int[] btrack) {
        this.calculateMatrix(reference, alternate, sw, btrack, this.overhang_strategy);
    }

    protected void calculateMatrix(byte[] reference, byte[] alternate, double[] sw, int[] btrack, OVERHANG_STRATEGY overhang_strategy) {
        if (reference.length == 0 || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int n = reference.length + 1;
        int m = alternate.length + 1;
        double MATRIX_MIN_CUTOFF = cutoff ? 0.0 : -1.0E100;
        double[] best_gap_v = new double[m + 1];
        Arrays.fill(best_gap_v, -1.0E40);
        int[] gap_size_v = new int[m + 1];
        double[] best_gap_h = new double[n + 1];
        Arrays.fill(best_gap_h, -1.0E40);
        int[] gap_size_h = new int[n + 1];
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL) {
            int i;
            sw[1] = this.parameters.w_open;
            double currentValue = this.parameters.w_open;
            for (i = 2; i < m; ++i) {
                sw[i] = currentValue += this.parameters.w_extend;
            }
            sw[m] = this.parameters.w_open;
            currentValue = this.parameters.w_open;
            for (i = 2; i < n; ++i) {
                sw[i * m] = currentValue += this.parameters.w_extend;
            }
        }
        int row_offset_1 = 0;
        for (int i = 1; i < n; ++i) {
            byte a_base = reference[i - 1];
            int row_offset = row_offset_1 + m;
            int j = 1;
            int data_offset_1 = row_offset_1;
            while (j < m) {
                byte b_base = alternate[j - 1];
                double step_diag = sw[data_offset_1] + this.wd(a_base, b_base);
                double prev_gap = sw[data_offset_1 + 1] + this.parameters.w_open;
                int n2 = j;
                best_gap_v[n2] = best_gap_v[n2] + this.parameters.w_extend;
                if (prev_gap > best_gap_v[j]) {
                    best_gap_v[j] = prev_gap;
                    gap_size_v[j] = 1;
                } else {
                    int n3 = j;
                    gap_size_v[n3] = gap_size_v[n3] + 1;
                }
                double step_down = best_gap_v[j];
                int kd = gap_size_v[j];
                int data_offset = row_offset + j;
                prev_gap = sw[data_offset - 1] + this.parameters.w_open;
                int n4 = i;
                best_gap_h[n4] = best_gap_h[n4] + this.parameters.w_extend;
                if (prev_gap > best_gap_h[i]) {
                    best_gap_h[i] = prev_gap;
                    gap_size_h[i] = 1;
                } else {
                    int n5 = i;
                    gap_size_h[n5] = gap_size_h[n5] + 1;
                }
                double step_right = best_gap_h[i];
                int ki = gap_size_h[i];
                if (step_down > step_right) {
                    if (step_down > step_diag) {
                        sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_down);
                        btrack[data_offset] = kd;
                    } else {
                        sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                        btrack[data_offset] = 0;
                    }
                } else if (step_right > step_diag) {
                    sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_right);
                    btrack[data_offset] = -ki;
                } else {
                    sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                    btrack[data_offset] = 0;
                }
                ++j;
                ++data_offset_1;
            }
            row_offset_1 = row_offset;
        }
    }

    protected SWPairwiseAlignmentResult calculateCigar(int refLength, int altLength, double[] sw, int[] btrack, OVERHANG_STRATEGY overhang_strategy) {
        int alignment_offset;
        int p1 = 0;
        int p2 = 0;
        double maxscore = Double.NEGATIVE_INFINITY;
        int segment_length = 0;
        if (overhang_strategy == OVERHANG_STRATEGY.INDEL) {
            p1 = refLength;
            p2 = altLength;
        } else {
            int i = 1;
            int data_offset = altLength + 1 + altLength;
            while (i < refLength + 1) {
                if (sw[data_offset] >= maxscore) {
                    p1 = i;
                    p2 = altLength;
                    maxscore = sw[data_offset];
                }
                ++i;
                data_offset += altLength + 1;
            }
            int j = 1;
            data_offset = refLength * (altLength + 1) + 1;
            while (j < altLength + 1) {
                if (sw[data_offset] > maxscore || sw[data_offset] == maxscore && Math.abs(refLength - j) < Math.abs(p1 - p2)) {
                    p1 = refLength;
                    p2 = j;
                    maxscore = sw[data_offset];
                    segment_length = altLength - j;
                }
                ++j;
                ++data_offset;
            }
        }
        ArrayList<CigarElement> lce = new ArrayList<CigarElement>(5);
        if (segment_length > 0 && overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(State.CLIP, segment_length));
            segment_length = 0;
        }
        State state = State.MATCH;
        int data_offset = p1 * (altLength + 1) + p2;
        do {
            State new_state;
            int btr = btrack[data_offset];
            int step_length = 1;
            if (btr > 0) {
                new_state = State.DELETION;
                step_length = btr;
            } else if (btr < 0) {
                new_state = State.INSERTION;
                step_length = -btr;
            } else {
                new_state = State.MATCH;
            }
            switch (new_state) {
                case MATCH: {
                    data_offset -= altLength + 2;
                    --p1;
                    --p2;
                    break;
                }
                case INSERTION: {
                    data_offset -= step_length;
                    p2 -= step_length;
                    break;
                }
                case DELETION: {
                    data_offset -= (altLength + 1) * step_length;
                    p1 -= step_length;
                }
            }
            if (new_state == state) {
                segment_length += step_length;
                continue;
            }
            lce.add(this.makeElement(state, segment_length));
            segment_length = step_length;
            state = new_state;
        } while (p1 > 0 && p2 > 0);
        if (overhang_strategy == OVERHANG_STRATEGY.SOFTCLIP) {
            lce.add(this.makeElement(state, segment_length));
            if (p2 > 0) {
                lce.add(this.makeElement(State.CLIP, p2));
            }
            alignment_offset = p1;
        } else if (overhang_strategy == OVERHANG_STRATEGY.IGNORE) {
            lce.add(this.makeElement(state, segment_length + p2));
            alignment_offset = p1 - p2;
        } else {
            lce.add(this.makeElement(state, segment_length));
            if (p1 > 0) {
                lce.add(this.makeElement(State.DELETION, p1));
            } else if (p2 > 0) {
                lce.add(this.makeElement(State.INSERTION, p2));
            }
            alignment_offset = 0;
        }
        Collections.reverse(lce);
        return new SWPairwiseAlignmentResult(AlignmentUtils.consolidateCigar(new Cigar(lce)), alignment_offset);
    }

    protected CigarElement makeElement(State state, int length) {
        CigarOperator op = null;
        switch (state) {
            case MATCH: {
                op = CigarOperator.M;
                break;
            }
            case INSERTION: {
                op = CigarOperator.I;
                break;
            }
            case DELETION: {
                op = CigarOperator.D;
                break;
            }
            case CLIP: {
                op = CigarOperator.S;
            }
        }
        return new CigarElement(length, op);
    }

    private double wd(byte x, byte y) {
        return x == y ? this.parameters.w_match : this.parameters.w_mismatch;
    }

    public void printAlignment(byte[] ref, byte[] read) {
        this.printAlignment(ref, read, 100);
    }

    public void printAlignment(byte[] ref, byte[] read, int width) {
        int j;
        StringBuilder bread = new StringBuilder();
        StringBuilder bref = new StringBuilder();
        StringBuilder match = new StringBuilder();
        int i = 0;
        int offset = this.getAlignmentStart2wrt1();
        Cigar cigar = this.getCigar();
        if (this.overhang_strategy != OVERHANG_STRATEGY.SOFTCLIP && offset < 0) {
            for (j = 0; j < -offset; ++j) {
                bread.append((char)read[j]);
                bref.append(' ');
                match.append(' ');
            }
            ArrayList<CigarElement> tweaked = new ArrayList<CigarElement>();
            tweaked.addAll(cigar.getCigarElements());
            tweaked.set(0, new CigarElement(cigar.getCigarElement(0).getLength() + offset, cigar.getCigarElement(0).getOperator()));
            cigar = new Cigar(tweaked);
        }
        if (offset > 0) {
            while (i < this.getAlignmentStart2wrt1()) {
                bref.append((char)ref[i]);
                bread.append(' ');
                match.append(' ');
                ++i;
            }
        }
        block8: for (CigarElement e : cigar.getCigarElements()) {
            switch (e.getOperator()) {
                case M: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(i < ref.length ? (char)ref[i] : (char)' ');
                        bread.append(j < read.length ? (char)read[j] : (char)' ');
                        match.append((char)(i < ref.length && j < read.length ? (ref[i] == read[j] ? 46 : 42) : 32));
                        ++z;
                        ++i;
                        ++j;
                    }
                    continue block8;
                }
                case I: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append('-');
                        bread.append((char)read[j]);
                        match.append('I');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case S: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(' ');
                        bread.append((char)read[j]);
                        match.append('S');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case D: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append((char)ref[i]);
                        bread.append('-');
                        match.append('D');
                        ++z;
                        ++i;
                    }
                    continue block8;
                }
                default: {
                    throw new StingException("Unexpected Cigar element:" + (Object)((Object)e.getOperator()));
                }
            }
        }
        while (i < ref.length) {
            bref.append((char)ref[i]);
            ++i;
        }
        while (j < read.length) {
            bread.append((char)read[j]);
            ++j;
        }
        int maxlength = Math.max(match.length(), Math.max(bread.length(), bref.length()));
        for (int pos = 0; pos < maxlength; pos += width) {
            SWPairwiseAlignment.print_cautiously(match, pos, width);
            SWPairwiseAlignment.print_cautiously(bread, pos, width);
            SWPairwiseAlignment.print_cautiously(bref, pos, width);
            System.out.println();
        }
    }

    private static void print_cautiously(StringBuilder s, int start, int width) {
        if (start >= s.length()) {
            System.out.println();
            return;
        }
        int end = Math.min(start + width, s.length());
        System.out.println(s.substring(start, end));
    }

    protected final class SWPairwiseAlignmentResult {
        public final Cigar cigar;
        public final int alignment_offset;

        public SWPairwiseAlignmentResult(Cigar cigar, int alignment_offset) {
            this.cigar = cigar;
            this.alignment_offset = alignment_offset;
        }
    }

    public static enum OVERHANG_STRATEGY {
        SOFTCLIP,
        INDEL,
        IGNORE;

    }

    protected static enum State {
        MATCH,
        INSERTION,
        DELETION,
        CLIP;

    }
}

