/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.dev.api.NamedFeatureSearcher;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.tribble.Feature;

public class SearchCommand {
    private static Logger log;
    public static int SEARCH_LIMIT;
    private boolean askUser = false;
    String searchString;
    ReferenceFrame referenceFrame;
    boolean recordHistory = true;
    Genome genome;
    private static Set<NamedFeatureSearcher> nameSearchers;
    private static HashMap<ResultType, String> tokenMatchers;

    public SearchCommand(ReferenceFrame referenceFrame, String searchString) {
        this(referenceFrame, searchString, GenomeManager.getInstance().getCurrentGenome());
    }

    public SearchCommand(ReferenceFrame referenceFrame, String searchString, boolean recordHistory) {
        this(referenceFrame, searchString);
        this.recordHistory = recordHistory;
    }

    SearchCommand(ReferenceFrame referenceFrame, String searchString, Genome genome) {
        this.referenceFrame = referenceFrame;
        this.searchString = searchString.trim();
        this.genome = genome;
    }

    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("Run search: " + this.searchString);
        }
        List<SearchResult> results = this.runSearch(this.searchString);
        if (this.askUser && (results = this.askUserFeature(results)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Multiple results, show cancelled: " + this.searchString);
            }
            return;
        }
        this.showSearchResult(results);
        if (log.isDebugEnabled()) {
            log.debug("End search: " + this.searchString);
        }
    }

    public List<SearchResult> runSearch(String searchString) {
        String[] tokens;
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        Set<ResultType> wholeStringType = this.checkTokenType(searchString = searchString.replace("\"", ""));
        if (wholeStringType.contains((Object)ResultType.LOCUS)) {
            results.add(this.calcChromoLocus(searchString));
            return results;
        }
        for (String s : tokens = searchString.split("\\s+")) {
            results.addAll(this.parseToken(s));
        }
        if (results.size() == 0) {
            SearchResult result = new SearchResult();
            result.setMessage("Invalid Search String: " + searchString);
            results.add(result);
        }
        return results;
    }

    public void showSearchResult(List<SearchResult> results) {
        int origZoom = this.referenceFrame.getZoom();
        SearchResult result = new SearchResult();
        if (results == null || results.size() == 0) {
            results = new ArrayList<SearchResult>();
            results.add(result);
        }
        boolean showMessage = false;
        boolean success = true;
        String message = "Invalid search string: " + this.searchString;
        if (results.size() == 1) {
            result = results.get(0);
            if (result.type != ResultType.ERROR) {
                IGV.getInstance().getSession().setCurrentGeneList(null);
            }
            switch (result.type) {
                case FEATURE: {
                    this.showFlankedRegion(result.chr, result.start, result.end);
                    break;
                }
                case LOCUS: {
                    this.referenceFrame.jumpTo(result.chr, result.start, result.end);
                    break;
                }
                case CHROMOSOME: {
                    this.referenceFrame.getEventBus().post(new ViewChange.ChromosomeChangeCause(this, result.chr));
                    this.referenceFrame.getEventBus().post(new ViewChange.ZoomCause(0));
                    break;
                }
                default: {
                    message = "Cannot find feature or locus: " + this.searchString;
                    success = false;
                    showMessage = true;
                    break;
                }
            }
        } else {
            ArrayList<String> loci = new ArrayList<String>(results.size());
            message = "";
            for (SearchResult res : results) {
                if (res.type != ResultType.ERROR) {
                    loci.add(res.getLocus());
                    continue;
                }
                message = message + res.getMessage() + "\n";
                showMessage = true;
            }
            GeneList geneList = new GeneList("", loci, false);
            IGV.getInstance().getSession().setCurrentGeneList(geneList);
        }
        IGV.getInstance().resetFrames();
        if (success && this.recordHistory) {
            IGV.getInstance().getSession().getHistory().push(this.searchString, origZoom);
        }
        if (showMessage) {
            MessageUtils.showMessage(message);
        }
    }

    public static Object[] getSelectionList(List<SearchResult> results, boolean longName) {
        ArrayList<String> options = new ArrayList<String>(Math.min(results.size(), SEARCH_LIMIT));
        for (SearchResult result : results) {
            if (result.type == ResultType.ERROR) continue;
            if (longName) {
                options.add(result.getLongName());
                continue;
            }
            options.add(result.getShortName());
        }
        return options.toArray();
    }

    private List<SearchResult> askUserFeature(List<SearchResult> results) {
        Object[] list = SearchCommand.getSelectionList(results, true);
        JList<Object> ls = new JList<Object>(list);
        ls.setSelectionMode(0);
        final JOptionPane pane = new JOptionPane(ls, -1, 2);
        final JDialog dialog = pane.createDialog("Features");
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        ls.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    dialog.setVisible(false);
                    pane.setValue(0);
                    dialog.dispose();
                }
            }
        });
        dialog.setVisible(true);
        int resp = (Integer)pane.getValue();
        ArrayList<SearchResult> val = null;
        if (resp == 0) {
            int[] selected = ls.getSelectedIndices();
            val = new ArrayList<SearchResult>(selected.length);
            for (int ii = 0; ii < selected.length; ++ii) {
                val.add(ii, results.get(selected[ii]));
            }
        }
        return val;
    }

    Set<ResultType> checkTokenType(String token) {
        token = token.trim();
        HashSet<ResultType> possibles = new HashSet<ResultType>();
        for (ResultType type : tokenMatchers.keySet()) {
            if (!token.matches(tokenMatchers.get((Object)type))) continue;
            possibles.add(type);
        }
        return possibles;
    }

    private List<SearchResult> parseToken(String token) {
        SearchResult result;
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        Set<ResultType> types = this.checkTokenType(token);
        if (types.contains((Object)ResultType.LOCUS) || types.contains((Object)ResultType.CHROMOSOME)) {
            result = this.calcChromoLocus(token);
            if (result.type != ResultType.ERROR) {
                results.add(result);
                return results;
            }
        }
        if (types.contains((Object)ResultType.FEATURE_MUT_AA) || types.contains((Object)ResultType.FEATURE_MUT_NT)) {
            Map<Integer, BasicFeature> genomePosList;
            String[] items = token.toUpperCase().split(":");
            String name = items[0].trim().toUpperCase();
            String coords = items[1];
            int coordLength = coords.length();
            if (types.contains((Object)ResultType.FEATURE_MUT_AA)) {
                String refSymbol = coords.substring(0, 1);
                String mutSymbol = coords.substring(coordLength - 1);
                String strLoc = coords.substring(1, coordLength - 1);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationAA(name, location + 1, refSymbol, mutSymbol, this.genome);
            } else if (types.contains((Object)ResultType.FEATURE_MUT_NT)) {
                String strLoc = coords.substring(0, coordLength - 3);
                String refSymbol = coords.substring(coordLength - 3, coordLength - 2);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationNT(name, location + 1, refSymbol, this.genome);
            } else {
                throw new IllegalArgumentException("Something went wrong parsing input token");
            }
            this.askUser |= genomePosList.size() >= 2;
            for (int genomePos : genomePosList.keySet()) {
                Feature feat = genomePosList.get(genomePos);
                int[] locs = SearchCommand.getStartEnd("" + (genomePos + 2));
                result = new SearchResult(ResultType.LOCUS, feat.getChr(), locs[0], locs[1]);
                results.add(result);
            }
            return results;
        }
        if (types.contains((Object)ResultType.FEATURE)) {
            NamedFeature feat = FeatureDB.getFeature(token.toUpperCase().trim());
            if (feat != null) {
                results.add(new SearchResult(feat));
                return results;
            }
            List<NamedFeature> features = this.comprehensiveFeatureSearch(token);
            if (features.size() > 0) {
                this.askUser |= features.size() >= 2;
                return SearchCommand.getResults(features);
            }
        }
        result = new SearchResult();
        result.setMessage("Invalid token: " + token);
        results.add(result);
        return results;
    }

    public static boolean registerNamedFeatureSearcher(NamedFeatureSearcher searcher) {
        return nameSearchers.add(searcher);
    }

    public static boolean unregisterNamedFeatureSearcher(NamedFeatureSearcher searcher) {
        return nameSearchers.remove(searcher);
    }

    static void resetNamedFeatureSearchers() {
        nameSearchers = new LinkedHashSet<NamedFeatureSearcher>();
        SearchCommand.registerNamedFeatureSearcher(new InexactLoadedFeatureSearcher());
    }

    private List<NamedFeature> comprehensiveFeatureSearch(String searchString) {
        ArrayList<NamedFeature> features = new ArrayList<NamedFeature>();
        for (NamedFeatureSearcher searcher : nameSearchers) {
            Collection<? extends NamedFeature> tmp = searcher.search(searchString, SEARCH_LIMIT);
            if (tmp == null) {
                log.warn("Error searching with " + searcher);
                continue;
            }
            features.addAll(tmp);
        }
        return features;
    }

    private SearchResult calcChromoLocus(String searchString) {
        boolean whitespace_delim;
        int[] startEnd = null;
        String[] tokens = searchString.split("\\s+");
        String chr = tokens[0];
        boolean bl = whitespace_delim = tokens.length >= 2;
        if (whitespace_delim) {
            String posString = tokens[1];
            if (tokens.length >= 3) {
                posString = posString + "-" + tokens[2];
            }
            startEnd = SearchCommand.getStartEnd(posString);
        } else {
            int colonIdx = searchString.lastIndexOf(":");
            if (colonIdx > 0) {
                chr = searchString.substring(0, colonIdx);
                String posString = searchString.substring(colonIdx).replace(":", "");
                startEnd = SearchCommand.getStartEnd(posString);
                if (startEnd == null) {
                    chr = searchString;
                }
            }
        }
        chr = this.genome.getChromosomeAlias(chr);
        Chromosome chromosome = this.genome.getChromosome(chr);
        if (chromosome == null && (chromosome = this.genome.getChromosome(chr = this.genome.getChromosomeAlias(tokens[0]))) != null) {
            startEnd = null;
        }
        if (chromosome != null && !searchString.equals("All")) {
            if (startEnd != null) {
                return new SearchResult(ResultType.LOCUS, chr, startEnd[0], startEnd[1]);
            }
            return new SearchResult(ResultType.CHROMOSOME, chr, 0, chromosome.getLength() - 1);
        }
        return new SearchResult(ResultType.ERROR, chr, -1, -1);
    }

    private void showFlankedRegion(String chr, int start, int end) {
        int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
        int delta = end - start == 1 ? 20 : (flankingRegion < 0 ? -flankingRegion * (end - start) / 100 : flankingRegion);
        start = Math.max(0, start - delta);
        end += delta;
        if (PreferenceManager.getInstance().getAsBoolean("SEARCH_ZOOM")) {
            this.referenceFrame.jumpTo(chr, start, end);
        } else {
            int center = (start + end) / 2;
            this.referenceFrame.centerOnLocation(chr, center);
        }
    }

    private static int[] getStartEnd(String posString) {
        try {
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString)) - 1;
            int end = start + 1;
            if (posTokens.length > 1) {
                String endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end - start < 10) {
                int center = (start + end) / 2;
                int widen = 20;
                start = center - widen;
                start = Math.max(0, start);
                end = center + widen + 1;
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<SearchResult> getResults(List<NamedFeature> objects) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(objects.size());
        for (NamedFeature f : objects) {
            results.add(new SearchResult(f));
        }
        return results;
    }

    static {
        String chromo_string;
        log = Logger.getLogger(SearchCommand.class);
        SEARCH_LIMIT = 20;
        SearchCommand.resetNamedFeatureSearchers();
        String num_withcommas = "(((\\d)+,?)+)";
        String chromo = chromo_string = "(\\S)+";
        String chromo_range = chromo_string + "(:|(\\s)+)" + num_withcommas + "(-|(\\s)+)?" + num_withcommas + "?(\\s)*";
        String feature = chromo_string;
        String featureMutAA = chromo_string + ":[A-Z,a-z,*]" + num_withcommas + "[A-Z,a-z,*]";
        String nts = "[A,C,G,T,a,c,g,t]";
        String featureMutNT = chromo_string + ":" + num_withcommas + nts + "\\>" + nts;
        tokenMatchers = new HashMap();
        tokenMatchers.put(ResultType.CHROMOSOME, chromo);
        tokenMatchers.put(ResultType.FEATURE, feature);
        tokenMatchers.put(ResultType.LOCUS, chromo_range);
        tokenMatchers.put(ResultType.FEATURE_MUT_AA, featureMutAA);
        tokenMatchers.put(ResultType.FEATURE_MUT_NT, featureMutNT);
    }

    public static class SearchResult {
        String chr;
        private int start;
        private int end;
        ResultType type;
        private String locus;
        private String message;
        private NamedFeature feature;
        private String coords;

        public SearchResult() {
            this(ResultType.ERROR, null, -1, -1);
        }

        public SearchResult(ResultType type, String chr, int start, int end) {
            this.type = type;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.locus = this.coords = Locus.getFormattedLocusString(chr, start + 1, end);
        }

        public SearchResult(NamedFeature feature) {
            this(ResultType.FEATURE, feature.getChr(), feature.getStart(), feature.getEnd());
            this.feature = feature;
            this.locus = this.feature.getName();
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        private String getCoordinates() {
            return this.coords;
        }

        String getLocus() {
            return this.locus;
        }

        String getShortName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName();
            }
            return this.getLocus();
        }

        String getLongName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName() + " (" + this.getCoordinates() + ")";
            }
            return this.getLocus();
        }

        public ResultType getType() {
            return this.type;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public NamedFeature getFeature() {
            return this.feature;
        }
    }

    private static class InexactLoadedFeatureSearcher
    implements NamedFeatureSearcher {
        private InexactLoadedFeatureSearcher() {
        }

        public Collection<NamedFeature> search(String name, int limit) {
            return FeatureDB.getFeaturesList(name, limit);
        }
    }

    public static enum ResultType {
        FEATURE,
        FEATURE_MUT_AA,
        FEATURE_MUT_NT,
        LOCUS,
        CHROMOSOME,
        ERROR;

    }
}

