/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import com.google.common.collect.Iterables;
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.EmblFeatureTableParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.genome.ChromSizesParser;
import org.broad.igv.feature.genome.FastaDirectorySequence;
import org.broad.igv.feature.genome.FastaIndexedSequence;
import org.broad.igv.feature.genome.FastaUtils;
import org.broad.igv.feature.genome.GenbankParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.feature.genome.GenomeZipDescriptor;
import org.broad.igv.feature.genome.IGVSequence;
import org.broad.igv.feature.genome.InMemorySequence;
import org.broad.igv.feature.genome.SequenceWrapper;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RunnableResult;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CI;
import org.broad.tribble.Feature;
import org.broad.tribble.util.ParsingUtils;

public class GenomeManager {
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static final String ACT_USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    public static final String TEST_USER_DEFINED_GENOME_LIST_FILE = "test-user-defined-genomes.txt";
    private static GenomeManager theInstance;
    private Genome currentGenome;
    private LinkedHashSet<GenomeListItem> userDefinedGenomeArchiveList;
    private List<GenomeListItem> serverGenomeArchiveList;
    private List<GenomeListItem> cachedGenomeArchiveList;
    private Set<String> excludedArchivesUrls = new HashSet<String>();
    private Map<String, GenomeListItem> genomeItemMap = new CI.CILinkedHashMap<GenomeListItem>();
    boolean serverGenomeListUnreachable = false;

    public static String getUserDefinedGenomeListFile() {
        if (Globals.isTesting()) {
            return TEST_USER_DEFINED_GENOME_LIST_FILE;
        }
        return ACT_USER_DEFINED_GENOME_LIST_FILE;
    }

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("genList") && args.length != 4) {
            throw new IllegalArgumentException("Incorrect number of inputs, expected genList [dir] [rootPath] [outFile]");
        }
    }

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    private GenomeManager() {
    }

    public void setCurrentGenome(Genome currentGenome) {
        if (currentGenome != null) {
            PreferenceManager.getInstance().setDefaultGenome(currentGenome.getId());
        }
        this.currentGenome = currentGenome;
    }

    public boolean isServerGenomeListUnreachable() {
        return this.serverGenomeListUnreachable;
    }

    public Genome loadGenome(String genomePath, ProgressMonitor monitor) throws IOException {
        return this.loadGenome(genomePath, monitor, true);
    }

    public Genome loadGenome(String genomePath, ProgressMonitor monitor, boolean addGenomeTrack) throws IOException {
        try {
            log.info("Loading genome: " + genomePath);
            Genome newGenome = null;
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            if (genomePath.endsWith(".genome")) {
                newGenome = this.loadDotGenomeFile(genomePath);
            } else if (genomePath.endsWith(".gbk")) {
                newGenome = this.loadGenbankFile(genomePath);
            } else if (genomePath.endsWith(".chrom.sizes")) {
                newGenome = this.loadChromSizes(genomePath);
            } else {
                if (genomePath.endsWith(".gz")) {
                    throw new GenomeException("IGV cannot readed gzipped fasta files.");
                }
                newGenome = this.loadFastaFile(genomePath);
            }
            String aliasPath = FileUtils.getParent(genomePath) + "/" + newGenome.getId() + "_alias.tab";
            Collection<Collection<String>> aliases = this.loadChrAliases(aliasPath);
            if (aliases != null) {
                newGenome.addChrAliases(aliases);
            }
            if ((aliases = this.loadChrAliases(aliasPath = new File(DirectoryManager.getGenomeCacheDirectory(), newGenome.getId() + "_alias.tab").getAbsolutePath())) != null) {
                newGenome.addChrAliases(aliases);
            }
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            this.setCurrentGenome(newGenome);
            if (IGV.hasInstance() && !Globals.isHeadless() && addGenomeTrack) {
                FeatureTrack geneFeatureTrack = newGenome.getGeneTrack();
                IGV.getInstance().setGenomeTracks(geneFeatureTrack);
            }
            log.info("Genome loaded.  id= " + newGenome.getId());
            return this.currentGenome;
        }
        catch (SocketException e) {
            throw new GenomeServerException("Server connection error", e);
        }
    }

    private Genome loadChromSizes(String genomePath) throws IOException {
        int firstPeriodIdx = genomePath.indexOf(46);
        String genomeId = genomePath.substring(0, firstPeriodIdx);
        List<Chromosome> chromosomes = ChromSizesParser.parse(genomePath);
        Genome newGenome = new Genome(genomeId, chromosomes);
        this.setCurrentGenome(newGenome);
        return newGenome;
    }

    private Genome loadGenbankFile(String genomePath) throws IOException {
        GenbankParser genbankParser = new GenbankParser(genomePath);
        String chr = genbankParser.getAccession();
        String name = genbankParser.getLocusName();
        if (!name.equals(chr)) {
            name = name + " (" + chr + ")";
        }
        byte[] seq = genbankParser.getSequence();
        InMemorySequence sequence = new InMemorySequence(chr, seq);
        Genome newGenome = new Genome(chr, name, sequence, true);
        this.setCurrentGenome(newGenome);
        if (IGV.hasInstance() && !Globals.isHeadless()) {
            FeatureTrack geneFeatureTrack = this.createGeneTrack(newGenome, genbankParser.getFeatures());
            newGenome.setGeneTrack(geneFeatureTrack);
        }
        return newGenome;
    }

    private Genome loadFastaFile(String genomePath) throws IOException {
        GenomeListItem item;
        String fastaPath = null;
        String fastaIndexPath = null;
        if (genomePath.endsWith(".fai")) {
            fastaPath = genomePath.substring(0, genomePath.length() - 4);
            fastaIndexPath = genomePath;
        } else {
            fastaPath = genomePath;
            fastaIndexPath = genomePath + ".fai";
        }
        if (!FileUtils.resourceExists(fastaIndexPath) && !FileUtils.isRemote(fastaPath)) {
            File archiveFile = this.getArchiveFile(fastaPath);
            fastaPath = archiveFile.getAbsolutePath();
            fastaIndexPath = fastaPath + ".fai";
            FastaUtils.createIndexFile(fastaPath, fastaIndexPath);
        }
        if ((item = GenomeManager.buildFromPath(fastaPath)) == null) {
            throw new IOException(fastaPath + " does not exist, could not load genome");
        }
        FastaIndexedSequence fastaSequence = new FastaIndexedSequence(fastaPath);
        SequenceWrapper sequence = new SequenceWrapper(fastaSequence);
        Genome newGenome = new Genome(item.getId(), item.getDisplayableName(), sequence, true);
        this.setCurrentGenome(newGenome);
        return newGenome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Collection<String>> loadChrAliases(String path) {
        File aliasFile = new File(path);
        if (aliasFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                Collection<Collection<String>> collection = GenomeManager.loadChrAliases(br);
                return collection;
            }
            catch (IOException e) {
                log.error("Error loading chr alias table", e);
                if (!Globals.isHeadless()) {
                    MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e.toString());
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static GenomeListItem buildFromPath(String path) {
        String name;
        String id = path;
        if (HttpUtils.isRemoteURL(path)) {
            name = Utilities.getFileNameFromURL(path);
        } else {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            name = file.getName();
        }
        return new GenomeListItem(name, path, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Genome loadDotGenomeFile(String genomePath) throws IOException {
        Collection<Collection<String>> aliases;
        File archiveFile = this.getArchiveFile(genomePath);
        GenomeDescriptor genomeDescriptor = GenomeManager.parseGenomeArchiveFile(archiveFile);
        String id = genomeDescriptor.getId();
        String displayName = genomeDescriptor.getName();
        boolean isFasta = genomeDescriptor.isFasta();
        String[] fastaFiles = genomeDescriptor.getFastaFileNames();
        LinkedHashMap<String, List<Cytoband>> cytobandMap = null;
        if (genomeDescriptor.hasCytobands()) {
            cytobandMap = this.loadCytobandFile(genomeDescriptor);
        }
        String sequencePath = genomeDescriptor.getSequenceLocation();
        SequenceWrapper sequence = null;
        boolean chromosOrdered = false;
        if (sequencePath == null) {
            sequence = null;
        } else if (!isFasta) {
            sequencePath = SequenceWrapper.checkSequenceURL(sequencePath);
            IGVSequence igvSequence = new IGVSequence(sequencePath);
            if (cytobandMap != null) {
                chromosOrdered = genomeDescriptor.isChromosomesAreOrdered();
                igvSequence.generateChromosomes(cytobandMap, chromosOrdered);
            }
            sequence = new SequenceWrapper(igvSequence);
        } else if (fastaFiles != null) {
            FastaDirectorySequence fastaDirectorySequence = new FastaDirectorySequence(sequencePath, fastaFiles);
            sequence = new SequenceWrapper(fastaDirectorySequence);
        } else {
            FastaIndexedSequence fastaSequence = new FastaIndexedSequence(sequencePath);
            sequence = new SequenceWrapper(fastaSequence);
            chromosOrdered = true;
        }
        Genome newGenome = new Genome(id, displayName, sequence, chromosOrdered);
        if (cytobandMap != null) {
            newGenome.setCytobands(cytobandMap);
        }
        if ((aliases = this.loadChrAliases(genomeDescriptor)) != null) {
            newGenome.addChrAliases(aliases);
        }
        InputStream geneStream = null;
        if (genomeDescriptor.getGeneFileName() != null) {
            try {
                geneStream = genomeDescriptor.getGeneStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(geneStream));
                FeatureTrack geneFeatureTrack = this.createGeneTrack(newGenome, reader, genomeDescriptor.getGeneFileName(), genomeDescriptor.getGeneTrackName(), genomeDescriptor.getUrl());
                newGenome.setGeneTrack(geneFeatureTrack);
            }
            finally {
                if (geneStream != null) {
                    geneStream.close();
                }
            }
        }
        genomeDescriptor.close();
        return newGenome;
    }

    private File getArchiveFile(String genomePath) throws MalformedURLException, UnsupportedEncodingException {
        File archiveFile;
        if (HttpUtils.isRemoteURL(genomePath.toLowerCase())) {
            URL genomeArchiveURL = new URL(genomePath);
            String tmp = URLDecoder.decode(new URL(genomePath).getFile(), "UTF-8");
            String cachedFilename = Utilities.getFileNameFromURL(tmp);
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                DirectoryManager.getGenomeCacheDirectory().mkdir();
            }
            archiveFile = new File(DirectoryManager.getGenomeCacheDirectory(), cachedFilename);
            this.refreshCache(archiveFile, genomeArchiveURL);
        } else {
            archiveFile = new File(genomePath);
        }
        return archiveFile;
    }

    private LinkedHashMap<String, List<Cytoband>> loadCytobandFile(GenomeDescriptor genomeDescriptor) {
        InputStream is = null;
        try {
            is = genomeDescriptor.getCytoBandStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            LinkedHashMap<String, List<Cytoband>> linkedHashMap = CytoBandFileParser.loadData(reader);
            return linkedHashMap;
        }
        catch (IOException ex) {
            log.warn("Error loading cytoband file", ex);
            throw new RuntimeException("Error loading cytoband file" + genomeDescriptor.cytoBandFileName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    private static Collection<Collection<String>> loadChrAliases(BufferedReader br) throws IOException {
        String nextLine = "";
        ArrayList<Collection<String>> synonymList = new ArrayList<Collection<String>>();
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            if (tokens.length <= 1) continue;
            ArrayList<String> synonyms = new ArrayList<String>();
            for (String t : tokens) {
                String syn = t.trim();
                if (t.length() <= 0) continue;
                synonyms.add(syn.trim());
            }
            synonymList.add(synonyms);
        }
        return synonymList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Collection<String>> loadChrAliases(GenomeDescriptor genomeDescriptor) {
        InputStream aliasStream = null;
        try {
            aliasStream = genomeDescriptor.getChrAliasStream();
            if (aliasStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(aliasStream));
                Collection<Collection<String>> collection = GenomeManager.loadChrAliases(reader);
                return collection;
            }
            Collection<Collection<String>> reader = null;
            return reader;
        }
        catch (IOException e) {
            log.error("Error loading chromosome alias table");
            Collection<Collection<String>> collection = null;
            return collection;
        }
        finally {
            try {
                if (aliasStream != null) {
                    aliasStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    void refreshCache(File cachedFile, URL genomeArchiveURL) {
        try {
            if (cachedFile.exists()) {
                boolean forceUpdate;
                GenomeDescriptor cachedDescriptor = GenomeManager.parseGenomeArchiveFile(cachedFile);
                boolean remoteModfied = HttpUtils.getInstance().remoteIsNewer(cachedFile, genomeArchiveURL, !cachedDescriptor.hasCustomSequenceLocation());
                boolean bl = forceUpdate = remoteModfied && PreferenceManager.getInstance().getAsBoolean("AUTO_UPDATE_GENOMES");
                if (forceUpdate) {
                    log.info("Refreshing genome: " + genomeArchiveURL.toString());
                    File tmpFile = new File(cachedFile.getAbsolutePath() + ".tmp");
                    if (HttpUtils.getInstance().downloadFile(genomeArchiveURL.toExternalForm(), tmpFile).isSuccess()) {
                        tmpFile.deleteOnExit();
                        boolean success = true;
                        if (cachedDescriptor.hasCustomSequenceLocation()) {
                            success = GenomeManager.rewriteSequenceLocation(tmpFile, cachedDescriptor.getSequenceLocation());
                        }
                        if (success) {
                            FileUtils.copyFile(tmpFile, cachedFile);
                        } else {
                            log.warn("Updating genome failed: " + genomeArchiveURL.toString());
                        }
                    }
                }
            } else {
                HttpUtils.getInstance().downloadFile(genomeArchiveURL.toExternalForm(), cachedFile);
            }
        }
        catch (Exception e) {
            MessageUtils.showErrorMessage("An error was encountered refreshing the genome cache: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenomeDescriptor parseGenomeArchiveFile(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("Genome file: " + f.getAbsolutePath() + " does not exist.");
        }
        GenomeZipDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(f);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(f);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                if (zipEntryName.equalsIgnoreCase("property.txt")) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String cytobandZipEntryName = properties.getProperty("cytobandFile");
                    String geneFileName = properties.getProperty("geneFile");
                    String chrAliasFileName = properties.getProperty("chrAliasFile");
                    String sequenceLocation = properties.getProperty("sequenceLocation");
                    if (sequenceLocation != null && !HttpUtils.isRemoteURL(sequenceLocation)) {
                        boolean isAbsolutePath;
                        File sequenceFolder = null;
                        sequenceFolder = new File(sequenceLocation);
                        boolean bl = isAbsolutePath = sequenceFolder.isAbsolute() || sequenceLocation.startsWith("/") || sequenceLocation.startsWith("\\");
                        if (!isAbsolutePath) {
                            sequenceFolder = new File(f.getParent(), sequenceLocation);
                        }
                        sequenceLocation = sequenceFolder.getCanonicalPath();
                        sequenceLocation.replace('\\', '/');
                    }
                    boolean chrNamesAltered = GenomeManager.parseBooleanPropertySafe(properties, "filenamesAltered");
                    boolean fasta = GenomeManager.parseBooleanPropertySafe(properties, "fasta");
                    boolean fastaDirectory = GenomeManager.parseBooleanPropertySafe(properties, "fastaDirectory");
                    boolean chromosomesAreOrdered = GenomeManager.parseBooleanPropertySafe(properties, "ordered");
                    boolean hasCustomSequenceLocation = GenomeManager.parseBooleanPropertySafe(properties, "customSequenceLocation");
                    String fastaFileNameString = properties.getProperty("fastaFiles");
                    String url = properties.getProperty("url");
                    genomeDescriptor = new GenomeZipDescriptor(properties.getProperty("name"), chrNamesAltered, properties.getProperty("id"), cytobandZipEntryName, geneFileName, chrAliasFileName, properties.getProperty("geneTrackName", "Gene"), sequenceLocation, hasCustomSequenceLocation, zipFile, zipEntries, chromosomesAreOrdered, fasta, fastaDirectory, fastaFileNameString);
                    if (url != null) {
                        genomeDescriptor.setUrl(url);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    private static boolean parseBooleanPropertySafe(Properties properties, String key) {
        String propertyString = properties.getProperty(key);
        return Boolean.parseBoolean(propertyString);
    }

    public List<GenomeListItem> getGenomeArchiveList() {
        List<GenomeListItem> genomeArchiveList = this.getServerGenomeArchiveList(this.excludedArchivesUrls);
        if (genomeArchiveList == null) {
            try {
                genomeArchiveList = this.getCachedGenomeArchiveList();
            }
            catch (IOException e) {
                MessageUtils.showErrorMessage("Cannot access cached genome list", e);
            }
        }
        return genomeArchiveList;
    }

    public boolean loadFromArchive(String genomeId) throws IOException {
        GenomeListItem matchingItem = this.findGenomeListItemById(genomeId);
        if (matchingItem != null) {
            GenomeManager.getInstance().addGenomeItems(Arrays.asList(matchingItem), false);
        }
        return matchingItem != null;
    }

    public List<GenomeListItem> getServerGenomeArchiveList() {
        return this.getServerGenomeArchiveList(this.excludedArchivesUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getServerGenomeArchiveList(Set excludedArchivesUrls) {
        if (this.serverGenomeListUnreachable) {
            return null;
        }
        if (this.serverGenomeArchiveList == null) {
            this.serverGenomeArchiveList = new LinkedList<GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferenceManager.getInstance().getGenomeListURL();
                URL serverGenomeURL = new URL(genomeListURLString);
                if (HttpUtils.isRemoteURL(genomeListURLString)) {
                    inputStream = HttpUtils.getInstance().openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? serverGenomeURL.getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("(#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        if (excludedArchivesUrls != null && excludedArchivesUrls.contains(fields[1])) continue;
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        GenomeListItem item = new GenomeListItem(name, url, id);
                        this.serverGenomeArchiveList.add(item);
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e) {
                this.serverGenomeListUnreachable = true;
                this.serverGenomeArchiveList = null;
                log.error("Error fetching genome list: ", e);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
            }
        }
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().notifyGenomeServerReachable(!this.serverGenomeListUnreachable);
        }
        return this.serverGenomeArchiveList;
    }

    public GenomeListItem getLoadedGenomeListItemById(String genomeId) {
        return this.genomeItemMap.get(genomeId);
    }

    public GenomeListItem findGenomeListItemById(String genomeId) throws IOException {
        GenomeListItem matchingItem = this.genomeItemMap.get(genomeId);
        if (matchingItem == null) {
            matchingItem = GenomeManager.searchGenomeList(genomeId, this.getGenomeArchiveList());
            if (matchingItem != null) {
                return matchingItem;
            }
            matchingItem = GenomeManager.searchGenomeList(genomeId, this.getUserDefinedGenomeArchiveList());
            if (matchingItem != null) {
                return matchingItem;
            }
        }
        return matchingItem;
    }

    static GenomeListItem searchGenomeList(String genomeId, Iterable<GenomeListItem> genomeList) {
        if (genomeList == null) {
            return null;
        }
        for (GenomeListItem item : genomeList) {
            if (!item.getId().equals(genomeId)) continue;
            return item;
        }
        return null;
    }

    public List<GenomeListItem> getGenomes() {
        return new ArrayList<GenomeListItem>(this.genomeItemMap.values());
    }

    public void buildGenomeItemList() {
        this.genomeItemMap.clear();
        Collection<GenomeListItem> tmpuserDefinedGenomeList = null;
        List<GenomeListItem> tmpcachedGenomeArchiveList = null;
        try {
            tmpcachedGenomeArchiveList = this.getCachedGenomeArchiveList();
            tmpuserDefinedGenomeList = this.getUserDefinedGenomeArchiveList();
        }
        catch (IOException e) {
            MessageUtils.showErrorMessage("Cannot access user defined genome archive list", e);
        }
        String[] genomeIdArray = PreferenceManager.getInstance().getGenomeIdDisplayList();
        if (genomeIdArray.length == 0) {
            genomeIdArray = new String[]{PreferenceManager.getInstance().getDefaultGenome(), "hg18"};
        }
        Iterable<GenomeListItem> combinedTmp = Iterables.concat(tmpuserDefinedGenomeList, tmpcachedGenomeArchiveList);
        this.addGenomesToMap(genomeIdArray, combinedTmp, this.genomeItemMap);
    }

    private void addGenomesToMap(String[] keepGenomeIds, Iterable<GenomeListItem> genomeListItems, Map<String, GenomeListItem> genomeMap) {
        for (String id : keepGenomeIds) {
            GenomeListItem genomeListItem = GenomeManager.searchGenomeList(id, genomeListItems);
            if (genomeListItem == null) {
                genomeListItem = GenomeManager.buildFromPath(id);
            }
            if (genomeListItem == null) {
                genomeListItem = new GenomeListItem(id, null, id);
            }
            if (genomeMap.containsKey(id)) continue;
            genomeMap.put(id, genomeListItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GenomeListItem> getUserDefinedGenomeArchiveList() throws IOException {
        if (this.userDefinedGenomeArchiveList == null) {
            boolean updateClientGenomeListFile = false;
            this.userDefinedGenomeArchiveList = new LinkedHashSet();
            File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), GenomeManager.getUserDefinedGenomeListFile());
            BufferedReader reader = null;
            boolean mightBeProperties = false;
            try {
                String nextLine;
                reader = new BufferedReader(new FileReader(listFile));
                while ((nextLine = reader.readLine()) != null) {
                    String file;
                    if (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                        mightBeProperties = true;
                        continue;
                    }
                    String[] fields = nextLine.split("\t");
                    if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                        fields = nextLine.split("\\\\t");
                        if (fields.length < 3) continue;
                        int idx = fields[0].indexOf("=");
                        fields[0] = fields[0].substring(idx + 1);
                    }
                    if (!FileUtils.resourceExists(file = fields[1])) {
                        updateClientGenomeListFile = true;
                        continue;
                    }
                    GenomeListItem item = new GenomeListItem(fields[0], file, fields[2]);
                    this.userDefinedGenomeArchiveList.add(item);
                }
            }
            catch (FileNotFoundException e) {
                log.info(e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (updateClientGenomeListFile) {
                this.updateImportedGenomePropertyFile();
            }
        }
        return this.userDefinedGenomeArchiveList;
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GenomeListItem> getCachedGenomeArchiveList() throws IOException {
        if (this.cachedGenomeArchiveList == null) {
            File[] files;
            this.cachedGenomeArchiveList = new LinkedList<GenomeListItem>();
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                return this.cachedGenomeArchiveList;
            }
            for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                ZipFile zipFile = null;
                FileInputStream fis = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipFile = new ZipFile(file);
                    fis = new FileInputStream(file);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    int version = 0;
                    if (properties.containsKey("version")) {
                        try {
                            version = Integer.parseInt(properties.getProperty("version"));
                        }
                        catch (Exception e) {
                            log.error("Error parsing genome version: " + version, e);
                        }
                    }
                    GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"));
                    this.cachedGenomeArchiveList.add(item);
                }
                catch (ZipException ex) {
                    log.error("\nZip error unzipping cached genome.", ex);
                    try {
                        file.delete();
                        zipInputStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                catch (IOException ex) {
                    log.warn("\nIO error unzipping cached genome.", ex);
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error closing genome zip stream!", ex);
                    }
                }
            }
        }
        return this.cachedGenomeArchiveList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImportedGenomePropertyFile() {
        if (this.userDefinedGenomeArchiveList == null) {
            return;
        }
        File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), GenomeManager.getUserDefinedGenomeListFile());
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e) {
                log.error("Error backing up user-defined genome list file", e);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.userDefinedGenomeArchiveList) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getLocation());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error("Error restoring genome-list file from backup");
                }
            }
            MessageUtils.showErrorMessage("Error updating user-defined genome list " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    public GenomeListItem defineGenome(File genomeFile, String cytobandFileName, String refFlatFileName, String fastaFileName, String chrAliasFileName, String genomeDisplayName, String genomeId, ProgressMonitor monitor) throws IOException {
        File refFlatFile = null;
        File cytobandFile = null;
        File chrAliasFile = null;
        if (genomeFile != null) {
            PreferenceManager.getInstance().setLastGenomeImportDirectory(genomeFile.getParentFile());
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
        }
        if (chrAliasFileName != null && chrAliasFileName.trim().length() != 0) {
            chrAliasFile = new File(chrAliasFileName);
        }
        if (monitor != null) {
            monitor.fireProgressChange(25);
        }
        new GenomeImporter().createGenomeArchive(genomeFile, genomeId, genomeDisplayName, fastaFileName, refFlatFile, cytobandFile, chrAliasFile);
        if (monitor != null) {
            monitor.fireProgressChange(75);
        }
        GenomeListItem newItem = new GenomeListItem(genomeDisplayName, genomeFile.getAbsolutePath(), genomeId);
        this.addGenomeItem(newItem, true);
        return newItem;
    }

    public RunnableResult downloadWholeGenome(String srcPath, File targetDir, Frame dialogsParent) throws IOException {
        boolean isFastaFile = FastaUtils.isFastaPath(srcPath);
        boolean showProgressDialog = !Globals.isHeadless() && !Globals.isBatch();
        String srcFileName = Utilities.getFileNameFromURL(srcPath);
        if (isFastaFile) {
            return this.downloadFasta(srcPath, targetDir, srcFileName, dialogsParent);
        }
        if (srcFileName.endsWith(".genome")) {
            String genomeName = Utilities.getFileNameFromURL(srcPath);
            File srcGenomeArchive = new File(targetDir, genomeName);
            RunnableResult genomeResult = HttpUtils.getInstance().downloadFile(srcPath, srcGenomeArchive);
            if (!genomeResult.isSuccess()) {
                return genomeResult;
            }
            GenomeDescriptor descriptor = GenomeManager.parseGenomeArchiveFile(srcGenomeArchive);
            File targetGenomeFile = new File(targetDir, srcGenomeArchive.getName());
            String sequencePath = descriptor.getSequenceLocation();
            boolean seqIsFasta = FastaUtils.isFastaPath(sequencePath);
            if (!seqIsFasta) {
                String msg = "This genome sequence is not available for download. \nPlease contact the igv team at https://groups.google.com/forum/#!forum/igv-help for further assistance";
                MessageUtils.showMessage(msg);
                return RunnableResult.CANCELLED;
            }
            String sequenceFileName = Utilities.getFileNameFromURL(sequencePath);
            File localSequenceFile = new File(targetDir, sequenceFileName);
            RunnableResult fastaResult = this.downloadFasta(sequencePath, targetDir, sequenceFileName, dialogsParent);
            if (fastaResult.isSuccess()) {
                GenomeManager.rewriteSequenceLocation(targetGenomeFile, localSequenceFile.getAbsolutePath());
            }
            return fastaResult;
        }
        throw new IllegalArgumentException("Unknown file type. Cannot download " + srcPath);
    }

    private RunnableResult downloadFasta(String fastaPath, File targetDir, String targetName, Frame dialogsParent) throws IOException {
        File destFile = new File(targetDir, targetName);
        HttpUtils.URLDownloader urlDownloader = HttpUtils.getInstance().downloadFile(fastaPath, destFile, dialogsParent, "Downloading genome sequence");
        RunnableResult fastaResult = urlDownloader.getResult();
        if (!fastaResult.isSuccess()) {
            return fastaResult;
        }
        File destIndexFile = new File(destFile.getAbsolutePath() + ".fai");
        String srcIndexPath = fastaPath + ".fai";
        RunnableResult idxResult = null;
        if (ParsingUtils.resourceExists(srcIndexPath)) {
            idxResult = HttpUtils.getInstance().downloadFile(srcIndexPath, destIndexFile);
        }
        if (idxResult == null || idxResult == RunnableResult.FAILURE) {
            FastaUtils.createIndexFile(destFile.getAbsolutePath(), destIndexFile.getAbsolutePath());
        }
        return fastaResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean rewriteSequenceLocation(File targetFile, String newSequencePath) throws IOException {
        ZipFile targetZipFile = new ZipFile(targetFile);
        boolean success = false;
        File tmpZipFile = File.createTempFile("tmpGenome", ".zip");
        ZipEntry propEntry = targetZipFile.getEntry("property.txt");
        InputStream propertyInputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        Properties inputProperties = new Properties();
        try {
            propertyInputStream = targetZipFile.getInputStream(propEntry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(propertyInputStream));
            inputProperties.load(reader);
            inputProperties.put("sequenceLocation", newSequencePath);
            inputProperties.put("customSequenceLocation", Boolean.TRUE.toString());
            ByteArrayOutputStream propertyBytes = new ByteArrayOutputStream();
            PrintWriter propertyFileWriter = new PrintWriter(new OutputStreamWriter(propertyBytes));
            inputProperties.store(propertyFileWriter, null);
            propertyFileWriter.flush();
            byte[] newPropertyBytes = propertyBytes.toByteArray();
            Enumeration<? extends ZipEntry> entries = targetZipFile.entries();
            zipOutputStream = new ZipOutputStream(new FileOutputStream(tmpZipFile));
            while (entries.hasMoreElements()) {
                ZipEntry curEntry = entries.nextElement();
                ZipEntry writeEntry = null;
                if (curEntry.getName().equals("property.txt")) {
                    writeEntry = new ZipEntry("property.txt");
                    writeEntry.setSize(newPropertyBytes.length);
                    ((ZipOutputStream)zipOutputStream).putNextEntry(writeEntry);
                    zipOutputStream.write(newPropertyBytes);
                    continue;
                }
                writeEntry = new ZipEntry(curEntry.getName());
                writeEntry.setSize(curEntry.getSize());
                writeEntry.setComment(curEntry.getComment());
                writeEntry.setTime(curEntry.getTime());
                ((ZipOutputStream)zipOutputStream).putNextEntry(writeEntry);
                InputStream tmpIS = null;
                try {
                    tmpIS = targetZipFile.getInputStream(writeEntry);
                    int bytes = IOUtils.copy(tmpIS, (OutputStream)zipOutputStream);
                    log.debug(bytes + " bytes written to " + targetFile);
                }
                finally {
                    if (tmpIS == null) continue;
                    tmpIS.close();
                }
            }
        }
        catch (Exception e) {
            tmpZipFile.delete();
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (propertyInputStream != null) {
                propertyInputStream.close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.flush();
                ((ZipOutputStream)zipOutputStream).finish();
                ((ZipOutputStream)zipOutputStream).close();
            }
            zipOutputStream = null;
            System.gc();
            success = true;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (success) {
            targetFile.delete();
            FileUtils.copyFile(tmpZipFile, targetFile);
            success = targetFile.exists();
            tmpZipFile.delete();
        }
        return success;
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public void addGenomeItems(Collection<GenomeListItem> genomeListItems, boolean userDefined) {
        for (GenomeListItem genomeListItem : genomeListItems) {
            this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
            if (!userDefined) continue;
            this.userDefinedGenomeArchiveList.add(genomeListItem);
        }
        PreferenceManager.getInstance().saveGenomeIdDisplayList(this.genomeItemMap.values());
        this.updateImportedGenomePropertyFile();
    }

    public void addGenomeItem(GenomeListItem genomeListItem, boolean userDefined) {
        this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
        PreferenceManager.getInstance().saveGenomeIdDisplayList(this.genomeItemMap.values());
        if (userDefined) {
            this.userDefinedGenomeArchiveList.add(genomeListItem);
        }
        this.updateImportedGenomePropertyFile();
    }

    public void generateGenomeList(File inDir, String rootPath, String outPath) {
        PrintWriter writer;
        File[] genomeFiles = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                return name.toLowerCase().endsWith(".genome");
            }
        });
        try {
            writer = new PrintWriter(outPath);
        }
        catch (FileNotFoundException e) {
            log.error("Error opening " + outPath);
            e.printStackTrace();
            return;
        }
        for (File f : genomeFiles) {
            String curLine = "";
            try {
                GenomeDescriptor descriptor = GenomeManager.parseGenomeArchiveFile(f);
                curLine = curLine + descriptor.getName();
                curLine = curLine + "\t" + rootPath + "/" + f.getName();
                curLine = curLine + "\t" + descriptor.getId();
            }
            catch (IOException e) {
                log.error("Error parsing genome file. Skipping " + f.getAbsolutePath());
                log.error(e);
                continue;
            }
            writer.println(curLine);
        }
        writer.close();
    }

    public FeatureTrack createGeneTrack(Genome genome, BufferedReader reader, String geneFileName, String geneTrackName, String annotationURL) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        if (reader != null) {
            FeatureParser parser = geneFileName.endsWith(".embl") ? new EmblFeatureTableParser() : (GFFFeatureSource.isGFF(geneFileName) ? new GFFParser() : AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFileName), genome));
            if (parser == null) {
                MessageUtils.showMessage("ERROR: Unrecognized annotation file format: " + geneFileName + "<br>Annotations for genome: " + genome.getId() + " will not be loaded.");
            } else {
                List<Feature> genes = parser.loadFeatures(reader, genome);
                String name = geneTrackName;
                if (name == null) {
                    name = "Genes";
                }
                String id = genome.getId() + "_genes";
                geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(genes, genome));
                geneFeatureTrack.setMinimumHeight(5);
                geneFeatureTrack.setHeight(35);
                geneFeatureTrack.setTrackType(TrackType.GENE);
                geneFeatureTrack.setColor(Color.BLUE.darker());
                TrackProperties props = parser.getTrackProperties();
                if (props != null) {
                    geneFeatureTrack.setProperties(parser.getTrackProperties());
                }
                geneFeatureTrack.setUrl(annotationURL);
            }
        }
        return geneFeatureTrack;
    }

    public FeatureTrack createGeneTrack(Genome genome, List<Feature> features) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        String name = "Annotations";
        String id = genome.getId() + "_genes";
        geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(features, genome));
        geneFeatureTrack.setMinimumHeight(5);
        geneFeatureTrack.setHeight(35);
        geneFeatureTrack.setColor(Color.BLUE.darker());
        return geneFeatureTrack;
    }

    public void excludedUrl(String location) {
        this.excludedArchivesUrls.add(location);
    }

    public void deleteDownloadedGenomes(List<GenomeListItem> removedValuesList) throws IOException {
        Collection<GenomeListItem> userDefinedGenomes = this.getUserDefinedGenomeArchiveList();
        for (GenomeListItem item : removedValuesList) {
            String loc;
            if (userDefinedGenomes.contains(item) || HttpUtils.isRemoteURL(loc = item.getLocation())) continue;
            File genFile = new File(loc);
            GenomeDescriptor descriptor = GenomeManager.parseGenomeArchiveFile(genFile);
            if (!HttpUtils.isRemoteURL(descriptor.getSequenceLocation())) {
                File seqFile = new File(descriptor.getSequenceLocation());
                seqFile.delete();
                File indexFile = new File(seqFile.getAbsolutePath() + ".fai");
                indexFile.delete();
            }
            genFile.delete();
        }
    }
}

