/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.GenericElementModel;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.util.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Invariant(value={"getName() != null", "getSimpleName().equals(getName().getSimpleName())", "getInterfaces() != null", "!getInterfaces().contains(null)", "getSuperArguments() != null", "!getSuperArguments().contains(null)", "getSuperclass() != null || superArguments.isEmpty()", "getImportNames() != null", "!getImportNames().contains(null)", "getEnclosingElement() == null || importNames.isEmpty()"})
public class TypeModel
extends GenericElementModel {
    protected ClassName name;
    protected Set<ClassName> interfaces;
    protected ClassName superclass;
    protected List<TypeName> superArguments;
    protected Set<String> importNames;

    @Requires(value={"kind != null", "name != null", "kind.isType()"})
    public TypeModel(ElementKind elementKind, ClassName className) {
        super(elementKind, className.getSimpleName());
        this.name = className;
        this.interfaces = new HashSet<ClassName>();
        this.superArguments = new ArrayList<TypeName>();
        this.importNames = new HashSet<String>();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public TypeModel(TypeModel typeModel) {
        super(typeModel);
        this.name = typeModel.name;
        this.interfaces = new HashSet<ClassName>(typeModel.interfaces);
        this.superArguments = new ArrayList<TypeName>(typeModel.superArguments);
        this.importNames = new HashSet<String>(typeModel.importNames);
    }

    @Override
    public TypeModel clone() {
        return new TypeModel(this);
    }

    public ClassName getName() {
        return this.name;
    }

    @Requires(value={"getEnclosingElement() == null", "value != null"})
    @Ensures(value={"getImportNames().contains(value)"})
    public void addImportName(String string) {
        this.importNames.add(string);
    }

    @Requires(value={"getEnclosingElement() == null", "value != null"})
    @Ensures(value={"!getImportNames().contains(value)"})
    public void removeImportName(String string) {
        this.importNames.remove(string);
    }

    @Requires(value={"getEnclosingElement() == null"})
    public Set<String> getImportNames() {
        return Collections.unmodifiableSet(this.importNames);
    }

    public ClassName getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(ClassName className) {
        this.superclass = className;
    }

    @Ensures(value={"result != null"})
    public List<? extends TypeName> getSuperArguments() {
        return Collections.unmodifiableList(this.superArguments);
    }

    @Ensures(value={"getSuperArguments().isEmpty()"})
    public void clearSuperArguments() {
        this.superArguments.clear();
    }

    @Requires(value={"typeName != null"})
    @Ensures(value={"getSuperArguments().size() == old(getSuperArguments().size()) + 1", "getSuperArguments().contains(typeName)"})
    public void addSuperArgument(TypeName typeName) {
        this.superArguments.add(typeName);
    }

    public Set<? extends ClassName> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    @Requires(value={"className != null"})
    @Ensures(value={"getInterfaces().contains(className)"})
    public void addInterface(ClassName className) {
        this.interfaces.add(className);
    }

    @Requires(value={"className != null"})
    @Ensures(value={"!getInterfaces().contains(className)"})
    public void removeInterface(ClassName className) {
        this.interfaces.remove(className);
    }

    @Ensures(value={"result != null"})
    public List<? extends ContractAnnotationModel> getInvariants() {
        return Elements.filter(this.enclosedElements, ContractAnnotationModel.class, ElementKind.INVARIANT);
    }

    @Requires(value={"annotation != null", "annotation.getKind() == ElementKind.INVARIANT"})
    @Ensures(value={"getEnclosedElements().contains(annotation)", "getInvariants().contains(annotation)"})
    public void addInvariant(ContractAnnotationModel contractAnnotationModel) {
        this.addEnclosedElement(contractAnnotationModel);
    }

    @Requires(value={"annotation != null", "annotation.getKind() == ElementKind.INVARIANT"})
    @Ensures(value={"!getEnclosedElements().contains(annotation)", "!getInvariants().contains(annotation)"})
    public void removeInvariant(ContractAnnotationModel contractAnnotationModel) {
        this.removeEnclosedElement(contractAnnotationModel);
    }

    @Ensures(value={"result != null", "!result.contains(null)"})
    public List<? extends QualifiedElementModel> getMembers() {
        return Elements.filter(this.enclosedElements, QualifiedElementModel.class, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.FIELD, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.CONTRACT_METHOD, ElementKind.CONTRACT_MOCK);
    }

    @Requires(value={"member != null", "member.getKind().isMember()"})
    @Ensures(value={"getEnclosedElements().contains(member)", "getMembers().contains(member)"})
    public void addMember(QualifiedElementModel qualifiedElementModel) {
        this.addEnclosedElement(qualifiedElementModel);
    }

    @Requires(value={"member != null", "member.getKind().isMember()"})
    @Ensures(value={"!getEnclosedElements().contains(member)", "!getMembers().contains(member)"})
    public void removeInvariant(QualifiedElementModel qualifiedElementModel) {
        this.removeEnclosedElement(qualifiedElementModel);
    }

    @Override
    public void accept(ElementVisitor elementVisitor) {
        elementVisitor.visitType(this);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        EnumSet<ElementKind[]> enumSet = EnumSet.of(ElementKind.CLASS, new ElementKind[]{ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.CONSTANT, ElementKind.FIELD, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.INVARIANT, ElementKind.CONTRACT_METHOD, ElementKind.CONTRACT_MOCK});
        enumSet.addAll(super.getAllowedEnclosedKinds());
        return enumSet;
    }
}

