/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import com.google.protobuf.CodedInputStream;
import edu.cornell.med.icb.goby.GobyVersion;
import edu.cornell.med.icb.goby.alignments.AlignmentReaderImpl;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.compression.MessageChunksReader;
import edu.cornell.med.icb.goby.modes.ConcatenateAlignmentMode;
import edu.cornell.med.icb.util.VersionUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class UpgradeTo1_9_8_2 {
    private boolean verbose;
    private static final Logger LOG = Logger.getLogger(AlignmentReaderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(String basename, AlignmentReaderImpl reader) throws IOException {
        if (GobyVersion.isMoreRecent(reader.getGobyVersion(), "goby_1.9.8.2")) {
            return;
        }
        String entriesFilename = basename + ".entries";
        File entriesFile = new File(entriesFilename);
        if (entriesFile.length() < Integer.MAX_VALUE) {
            return;
        }
        System.out.printf("Upgrading %s.. This will take a while.%n", basename);
        ConcatenateAlignmentMode concat = new ConcatenateAlignmentMode();
        String[] inputs = new String[]{basename};
        concat.setInputFileNames(inputs);
        String tmpBasename = this.makeTmpBasename(basename);
        concat.setUpgrade(false);
        concat.setOutputFilename(tmpBasename);
        concat.setIgnoreTmh(true);
        try {
            concat.execute();
            if (new File(tmpBasename + ".index").exists()) {
                FileUtils.moveFile((File)new File(basename + ".index"), (File)new File(this.makeBackFilename(basename + ".index", ".bak")));
                FileUtils.moveFile((File)new File(tmpBasename + ".index"), (File)new File(basename + ".index"));
                this.upgradeHeaderVersion(basename);
                if (this.verbose) {
                    System.out.printf("alignment %s upgraded successfully.%n", basename);
                }
            } else if (this.verbose) {
                System.out.printf("alignment %s failed to upgrade to 1.9.8.2.%n", basename);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)new File(tmpBasename + ".index"));
            FileUtils.deleteQuietly((File)new File(tmpBasename + ".entries"));
            FileUtils.deleteQuietly((File)new File(tmpBasename + ".tmh"));
            FileUtils.deleteQuietly((File)new File(tmpBasename + ".header"));
            FileUtils.deleteQuietly((File)new File(tmpBasename + ".stats"));
        }
    }

    private String makeTmpBasename(String basename) {
        return basename + "-TMP-" + new Date().getTime() + UUID.randomUUID();
    }

    private boolean scanEntriesPast2G(String entriesFilename, LongArrayList indexOffsets, LongArrayList absolutePositions, int countVoid) throws IOException {
        MessageChunksReader reader = new MessageChunksReader(new FileInputStream(entriesFilename));
        int count = 0;
        int addedCount = 0;
        long position = reader.position();
        while (reader.hasNext(null, 0)) {
            if (count > indexOffsets.size()) {
                indexOffsets.add(position);
                ++addedCount;
            } else if (count < indexOffsets.size()) {
                long previousPos = indexOffsets.getLong(count);
                if (position != 0L && position != previousPos) {
                    System.out.printf("recalculated position %d must not clash with previous position %d for <2GB part of file count=%d %n", position, previousPos, count);
                }
            } else {
                System.out.println("past end of previous offsets: " + count);
            }
            ++count;
            position = reader.position();
        }
        assert (addedCount == countVoid) : "addedCount must match void count.";
        if (indexOffsets.size() != absolutePositions.size()) {
            System.out.printf("new sizes must match indexOffsets.size=%d absolutePositions.size=%d %n", indexOffsets.size(), absolutePositions.size());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeHeaderVersion(String basename) throws IOException {
        InputStream headerStream;
        try {
            headerStream = new GZIPInputStream(new FileInputStream(basename + ".header"));
        }
        catch (IOException e) {
            LOG.trace("falling back to legacy 1.4- uncompressed header.");
            headerStream = new FileInputStream(basename + ".header");
        }
        CodedInputStream codedInput = CodedInputStream.newInstance(headerStream);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        Alignments.AlignmentHeader header = Alignments.AlignmentHeader.parseFrom(codedInput);
        Alignments.AlignmentHeader.Builder upgradedHeader = Alignments.AlignmentHeader.newBuilder(header);
        upgradedHeader.setVersion(VersionUtils.getImplementationVersion(UpgradeTo1_9_8_2.class));
        FileUtils.moveFile((File)new File(basename + ".header"), (File)new File(this.makeBackFilename(basename + ".header", ".bak")));
        GZIPOutputStream headerOutput = new GZIPOutputStream(new FileOutputStream(basename + ".header"));
        try {
            upgradedHeader.build().writeTo(headerOutput);
        }
        finally {
            headerOutput.close();
        }
    }

    private String makeBackFilename(String filename, String ext) {
        int counter = 1;
        String extCount = ext;
        while (new File(filename + extCount).exists()) {
            extCount = ext + Integer.toString(++counter);
        }
        return filename + extCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(String basename, LongArrayList indexOffsets, LongArrayList indexAbsolutePositions) throws IOException {
        DeflaterOutputStream indexOutput = null;
        try {
            FileUtils.moveFile((File)new File(basename + ".index"), (File)new File(this.makeBackFilename(basename + ".index", ".bak")));
            indexOutput = new GZIPOutputStream(new FileOutputStream(basename + ".index"));
            Alignments.AlignmentIndex.Builder indexBuilder = Alignments.AlignmentIndex.newBuilder();
            assert (indexOffsets.size() == indexAbsolutePositions.size()) : "index sizes must be consistent.";
            indexBuilder.addAllOffsets(indexOffsets);
            indexBuilder.addAllAbsolutePositions(indexAbsolutePositions);
            indexBuilder.build().writeTo(indexOutput);
        }
        finally {
            if (indexOutput != null) {
                indexOutput.close();
            }
        }
    }

    private Alignments.AlignmentEntry fetchFirstEntry(AlignmentReaderImpl reader, long indexOffset) throws IOException {
        reader.seek(indexOffset);
        if (reader.hasNext()) {
            return reader.next();
        }
        return null;
    }

    public void setSilent(boolean silent) {
        this.verbose = !silent;
    }
}

