/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public final class AlignmentUtils {
    private static final Logger logger = Logger.getLogger(AlignmentUtils.class);
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_OPERATORS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X);
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_PLUS_SOFTCLIPS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X, CigarOperator.S);
    private static final List<CigarPairTransform> cigarPairTransformers = Arrays.asList(new CigarPairTransform(CigarOperator.M, CigarOperator.M, CigarOperator.M, 1, 1), new CigarPairTransform(CigarOperator.M, CigarOperator.I, CigarOperator.I, 1, 1), new CigarPairTransform(CigarOperator.M, CigarOperator.D, CigarOperator.D, 0, 1), new CigarPairTransform(CigarOperator.D, CigarOperator.M, CigarOperator.D, 1, 1), new CigarPairTransform(CigarOperator.D, CigarOperator.D, CigarOperator.D, 1, 0), new CigarPairTransform(CigarOperator.D, CigarOperator.I, null, 1, 1), new CigarPairTransform(CigarOperator.I, CigarOperator.M, CigarOperator.I, 1, 0), new CigarPairTransform(CigarOperator.I, CigarOperator.D, CigarOperator.I, 1, 0), new CigarPairTransform(CigarOperator.I, CigarOperator.I, CigarOperator.I, 1, 0));

    private AlignmentUtils() {
    }

    public static boolean startsOrEndsWithInsertionOrDeletion(Cigar cigar) {
        if (cigar == null) {
            throw new IllegalArgumentException("Cigar cannot be null");
        }
        if (cigar.isEmpty()) {
            return false;
        }
        CigarOperator first = cigar.getCigarElement(0).getOperator();
        CigarOperator last = cigar.getCigarElement(cigar.numCigarElements() - 1).getOperator();
        return first == CigarOperator.D || first == CigarOperator.I || last == CigarOperator.D || last == CigarOperator.I;
    }

    public static byte[] getBasesCoveringRefInterval(int refStart, int refEnd, byte[] bases, int basesStartOnRef, Cigar basesToRefCigar) {
        if (refStart < 0 || refEnd < refStart) {
            throw new IllegalArgumentException("Bad start " + refStart + " and/or stop " + refEnd);
        }
        if (basesStartOnRef < 0) {
            throw new IllegalArgumentException("BasesStartOnRef must be >= 0 but got " + basesStartOnRef);
        }
        if (bases == null) {
            throw new IllegalArgumentException("Bases cannot be null");
        }
        if (basesToRefCigar == null) {
            throw new IllegalArgumentException("basesToRefCigar cannot be null");
        }
        if (bases.length != basesToRefCigar.getReadLength()) {
            throw new IllegalArgumentException("Mismatch in length between reference bases " + bases.length + " and cigar length " + basesToRefCigar);
        }
        int refPos = basesStartOnRef;
        int basesPos = 0;
        int basesStart = -1;
        int basesStop = -1;
        boolean done = false;
        block5: for (int iii = 0; !done && iii < basesToRefCigar.numCigarElements(); ++iii) {
            CigarElement ce = basesToRefCigar.getCigarElement(iii);
            switch (ce.getOperator()) {
                case I: {
                    basesPos += ce.getLength();
                    continue block5;
                }
                case M: 
                case X: 
                case EQ: {
                    int i;
                    for (i = 0; i < ce.getLength(); ++i) {
                        if (refPos == refStart) {
                            basesStart = basesPos;
                        }
                        if (refPos == refEnd) {
                            basesStop = basesPos;
                            done = true;
                            continue block5;
                        }
                        ++refPos;
                        ++basesPos;
                    }
                    continue block5;
                }
                case D: {
                    int i;
                    for (i = 0; i < ce.getLength(); ++i) {
                        if (refPos == refEnd || refPos == refStart) {
                            return null;
                        }
                        ++refPos;
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unsupported operator " + ce);
                }
            }
        }
        if (basesStart == -1 || basesStop == -1) {
            throw new IllegalStateException("Never found start " + basesStart + " or stop " + basesStop + " given cigar " + basesToRefCigar);
        }
        return Arrays.copyOfRange(bases, basesStart, basesStop + 1);
    }

    public static int calcNumDifferentBases(Cigar cigar, byte[] refSeq, byte[] readSeq) {
        int refIndex = 0;
        int readIdx = 0;
        int delta = 0;
        block8: for (CigarElement ce : cigar.getCigarElements()) {
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case M: 
                case X: 
                case EQ: {
                    int j = 0;
                    while (j < elementLength) {
                        delta += refSeq[refIndex] != readSeq[readIdx] ? 1 : 0;
                        ++j;
                        ++refIndex;
                        ++readIdx;
                    }
                    continue block8;
                }
                case I: {
                    delta += elementLength;
                }
                case S: {
                    readIdx += elementLength;
                    break;
                }
                case D: {
                    delta += elementLength;
                }
                case N: {
                    refIndex += elementLength;
                    break;
                }
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
                }
            }
        }
        return delta;
    }

    public static long mismatchingQualities(GATKSAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount((GATKSAMRecord)r, (byte[])refSeq, (int)refIndex).mismatchQualities;
    }

    public static MismatchCount getMismatchCount(GATKSAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount(r, refSeq, refIndex, 0, r.getReadLength());
    }

    @Ensures(value={"result != null"})
    public static MismatchCount getMismatchCount(GATKSAMRecord r, byte[] refSeq, int refIndex, int startOnRead, int nReadBases) {
        if (r == null) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count from a read that is null");
        }
        if (refSeq == null) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a reference sequence that is null");
        }
        if (refIndex < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a reference index that is negative");
        }
        if (startOnRead < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a read start that is negative");
        }
        if (nReadBases < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count for a negative number of read bases");
        }
        if (refSeq.length - refIndex < r.getAlignmentEnd() - r.getAlignmentStart()) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count against a reference string that is smaller than the read");
        }
        MismatchCount mc = new MismatchCount();
        int readIdx = 0;
        int endOnRead = startOnRead + nReadBases - 1;
        byte[] readSeq = r.getReadBases();
        Cigar c = r.getCigar();
        byte[] readQuals = r.getBaseQualities();
        block8: for (CigarElement ce : c.getCigarElements()) {
            if (readIdx > endOnRead) break;
            int elementLength = ce.getLength();
            block0 : switch (ce.getOperator()) {
                case X: {
                    int j;
                    mc.numMismatches += elementLength;
                    for (j = 0; j < elementLength; ++j) {
                        mc.mismatchQualities += (long)readQuals[readIdx + j];
                    }
                }
                case EQ: {
                    refIndex += elementLength;
                    readIdx += elementLength;
                    break;
                }
                case M: {
                    int j = 0;
                    while (j < elementLength) {
                        if (refIndex < refSeq.length && readIdx >= startOnRead) {
                            if (readIdx > endOnRead) break block0;
                            byte readChr = readSeq[readIdx];
                            byte refChr = refSeq[refIndex];
                            if (readChr != refChr) {
                                ++mc.numMismatches;
                                mc.mismatchQualities += (long)readQuals[readIdx];
                            }
                        }
                        ++j;
                        ++refIndex;
                        ++readIdx;
                    }
                    continue block8;
                }
                case I: 
                case S: {
                    readIdx += elementLength;
                    break;
                }
                case D: 
                case N: {
                    refIndex += elementLength;
                    break;
                }
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
                }
            }
        }
        return mc;
    }

    @Ensures(value={"result >= 0"})
    public static int getNumAlignmentBlocks(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        int n = 0;
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_OPERATORS.contains((Object)e.getOperator())) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlignedBasesCountingSoftClips(GATKSAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_PLUS_SOFTCLIPS.contains((Object)e.getOperator())) continue;
            n += e.getLength();
        }
        return n;
    }

    @Ensures(value={"result >= 0"})
    public static int getNumHardClippedBases(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.H) continue;
            n += e.getLength();
        }
        return n;
    }

    @Ensures(value={"result >= 0"})
    public static int calcNumHighQualitySoftClips(GATKSAMRecord read, byte qualThreshold) {
        if (read == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        if (qualThreshold < 0) {
            throw new IllegalArgumentException("Expected qualThreshold to be a positive byte but saw " + qualThreshold);
        }
        if (read.getCigar() == null) {
            return 0;
        }
        byte[] qual = read.getBaseQualities(EventType.BASE_SUBSTITUTION);
        int numHQSoftClips = 0;
        int alignPos = 0;
        block5: for (CigarElement ce : read.getCigar().getCigarElements()) {
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case S: {
                    for (int jjj = 0; jjj < elementLength; ++jjj) {
                        if (qual[alignPos++] <= qualThreshold) continue;
                        ++numHQSoftClips;
                    }
                    continue block5;
                }
                case I: 
                case M: 
                case X: 
                case EQ: {
                    alignPos += elementLength;
                    break;
                }
                case D: 
                case N: 
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return numHQSoftClips;
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, PileupElement pileupElement, int alignmentStart, int refLocus) {
        return AlignmentUtils.calcAlignmentByteArrayOffset(cigar, pileupElement.getOffset(), pileupElement.isDeletion(), alignmentStart, refLocus);
    }

    @Ensures(value={"result >= 0"})
    public static int calcAlignmentByteArrayOffset(Cigar cigar, int offset, boolean isDeletion, int alignmentStart, int refLocus) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to find the alignment position from a CIGAR that is null");
        }
        if (offset < -1) {
            throw new IllegalArgumentException("attempting to find the alignment position with an offset that is negative (and not -1)");
        }
        if (alignmentStart < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from an alignment start that is negative");
        }
        if (refLocus < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from a reference position that is negative");
        }
        if (offset >= cigar.getReadLength()) {
            throw new IllegalArgumentException("attempting to find the alignment position of an offset than is larger than the read length");
        }
        int pileupOffset = offset;
        if (isDeletion) {
            pileupOffset = refLocus - alignmentStart;
            CigarElement ce = cigar.getCigarElement(0);
            if (ce.getOperator() == CigarOperator.S) {
                pileupOffset += ce.getLength();
            }
        }
        int pos = 0;
        int alignmentPos = 0;
        block6: for (int iii = 0; iii < cigar.numCigarElements(); ++iii) {
            CigarElement ce = cigar.getCigarElement(iii);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: 
                case S: {
                    if ((pos += elementLength) < pileupOffset) continue block6;
                    return alignmentPos;
                }
                case D: {
                    if (!isDeletion) {
                        alignmentPos += elementLength;
                        continue block6;
                    }
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case M: 
                case X: 
                case EQ: {
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case N: 
                case H: 
                case P: {
                    continue block6;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return alignmentPos;
    }

    /*
     * Unable to fully structure code
     */
    @Ensures(value={"result != null"})
    public static byte[] readToAlignmentByteArray(Cigar cigar, byte[] read) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to generate an alignment from a CIGAR that is null");
        }
        if (read == null) {
            throw new IllegalArgumentException("attempting to generate an alignment from a read sequence that is null");
        }
        alignmentLength = cigar.getReferenceLength();
        alignment = new byte[alignmentLength];
        alignPos = 0;
        readPos = 0;
        block7: for (iii = 0; iii < cigar.numCigarElements(); ++iii) {
            ce = cigar.getCigarElement(iii);
            elementLength = ce.getLength();
            switch (1.$SwitchMap$net$sf$samtools$CigarOperator[ce.getOperator().ordinal()]) {
                case 1: {
                    if (alignPos <= 0) ** GOTO lbl27
                    prevPos = alignPos - 1;
                    if (alignment[prevPos] != BaseUtils.Base.A.base) ** GOTO lbl19
                    alignment[prevPos] = 87;
                    ** GOTO lbl27
lbl19:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.C.base) ** GOTO lbl22
                    alignment[prevPos] = 88;
                    ** GOTO lbl27
lbl22:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.T.base) ** GOTO lbl25
                    alignment[prevPos] = 89;
                    ** GOTO lbl27
lbl25:
                    // 1 sources

                    if (alignment[prevPos] == BaseUtils.Base.G.base) {
                        alignment[prevPos] = 90;
                    }
                }
lbl27:
                // 8 sources

                case 6: {
                    readPos += elementLength;
                    continue block7;
                }
                case 5: 
                case 7: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = PileupElement.DELETION_BASE;
                    }
                    continue block7;
                }
                case 2: 
                case 3: 
                case 4: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = read[readPos++];
                    }
                    continue block7;
                }
                case 8: 
                case 9: {
                    continue block7;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)ce.getOperator());
                }
            }
        }
        return alignment;
    }

    public static boolean isReadGenomeLocUnmapped(SAMRecord r) {
        return "*".equals(r.getReferenceName());
    }

    public static boolean isReadUnmapped(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        return r.getReadUnmappedFlag() || (r.getReferenceIndex() == null || r.getReferenceIndex() == -1) && (r.getReferenceName() == null || r.getReferenceName().equals("*")) || r.getAlignmentStart() == 0;
    }

    @Ensures(value={"result != null"})
    public static Cigar consolidateCigar(Cigar c) {
        if (c == null) {
            throw new IllegalArgumentException("Cigar cannot be null");
        }
        if (!AlignmentUtils.needsConsolidation(c)) {
            return c;
        }
        Cigar returnCigar = new Cigar();
        int sumLength = 0;
        CigarElement lastElement = null;
        for (CigarElement cur : c.getCigarElements()) {
            if (cur.getLength() == 0) continue;
            if (lastElement != null && lastElement.getOperator() != cur.getOperator()) {
                returnCigar.add(new CigarElement(sumLength, lastElement.getOperator()));
                sumLength = 0;
            }
            sumLength += cur.getLength();
            lastElement = cur;
        }
        if (sumLength > 0) {
            returnCigar.add(new CigarElement(sumLength, lastElement.getOperator()));
        }
        return returnCigar;
    }

    private static boolean needsConsolidation(Cigar c) {
        if (c.numCigarElements() <= 1) {
            return false;
        }
        CigarOperator lastOp = null;
        for (CigarElement cur : c.getCigarElements()) {
            if (cur.getLength() == 0 || lastOp == cur.getOperator()) {
                return true;
            }
            lastOp = cur.getOperator();
        }
        return false;
    }

    @Ensures(value={"result != null"})
    public static Cigar leftAlignIndel(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex, boolean doNotThrowExceptionForMultipleIndels) {
        AlignmentUtils.ensureLeftAlignmentHasGoodArguments(cigar, refSeq, readSeq, refIndex, readIndex);
        int numIndels = AlignmentUtils.countIndelElements(cigar);
        if (numIndels == 0) {
            return cigar;
        }
        if (numIndels == 1) {
            return AlignmentUtils.leftAlignSingleIndel(cigar, refSeq, readSeq, refIndex, readIndex, true);
        }
        if (doNotThrowExceptionForMultipleIndels) {
            return cigar;
        }
        throw new UnsupportedOperationException("attempting to left align a CIGAR that has more than 1 indel in its alignment but this functionality has not been implemented yet");
    }

    private static void ensureLeftAlignmentHasGoodArguments(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to left align a CIGAR that is null");
        }
        if (refSeq == null) {
            throw new IllegalArgumentException("attempting to left align a reference sequence that is null");
        }
        if (readSeq == null) {
            throw new IllegalArgumentException("attempting to left align a read sequence that is null");
        }
        if (refIndex < 0) {
            throw new IllegalArgumentException("attempting to left align with a reference index less than 0");
        }
        if (readIndex < 0) {
            throw new IllegalArgumentException("attempting to left align with a read index less than 0");
        }
    }

    @Requires(value={"cigar != null"})
    @Ensures(value={"result >= 0"})
    private static int countIndelElements(Cigar cigar) {
        int indelCount = 0;
        for (CigarElement ce : cigar.getCigarElements()) {
            if (ce.getOperator() != CigarOperator.D && ce.getOperator() != CigarOperator.I) continue;
            ++indelCount;
        }
        return indelCount;
    }

    @Ensures(value={"result != null"})
    public static Cigar leftAlignSingleIndel(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex, boolean cleanupCigar) {
        AlignmentUtils.ensureLeftAlignmentHasGoodArguments(cigar, refSeq, readSeq, refIndex, readIndex);
        int indexOfIndel = -1;
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            if (ce.getOperator() != CigarOperator.D && ce.getOperator() != CigarOperator.I) continue;
            if (indexOfIndel != -1) {
                throw new IllegalArgumentException("attempting to left align a CIGAR that has more than 1 indel in its alignment");
            }
            indexOfIndel = i;
        }
        if (indexOfIndel == -1) {
            throw new IllegalArgumentException("attempting to left align a CIGAR that has no indels in its alignment");
        }
        if (indexOfIndel == 0) {
            return cigar;
        }
        int indelLength = cigar.getCigarElement(indexOfIndel).getLength();
        byte[] altString = AlignmentUtils.createIndelString(cigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
        if (altString == null) {
            return cigar;
        }
        Cigar newCigar = cigar;
        for (int i = 0; i < indelLength; ++i) {
            newCigar = AlignmentUtils.moveCigarLeft(newCigar, indexOfIndel);
            byte[] newAltString = AlignmentUtils.createIndelString(newCigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
            boolean reachedEndOfRead = AlignmentUtils.cigarHasZeroSizeElement(newCigar);
            if (Arrays.equals(altString, newAltString)) {
                cigar = newCigar;
                i = -1;
                if (reachedEndOfRead) {
                    Cigar cigar2 = cigar = cleanupCigar ? AlignmentUtils.cleanUpCigar(cigar) : cigar;
                }
            }
            if (reachedEndOfRead) break;
        }
        return cigar;
    }

    @Requires(value={"c != null"})
    protected static boolean cigarHasZeroSizeElement(Cigar c) {
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() != 0) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"c != null"})
    @Ensures(value={"result != null"})
    public static Cigar cleanUpCigar(Cigar c) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(c.numCigarElements() - 1);
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() == 0 || elements.isEmpty() && ce.getOperator() == CigarOperator.D) continue;
            elements.add(ce);
        }
        return new Cigar(elements);
    }

    @Requires(value={"c != null"})
    @Ensures(value={"result != null"})
    public static Cigar removeTrailingDeletions(Cigar c) {
        List<CigarElement> elements = c.getCigarElements();
        if (elements.get(elements.size() - 1).getOperator() != CigarOperator.D) {
            return c;
        }
        return new Cigar(elements.subList(0, elements.size() - 1));
    }

    @Requires(value={"cigar != null && indexOfIndel >= 0 && indexOfIndel < cigar.numCigarElements()"})
    @Ensures(value={"result != null"})
    private static Cigar moveCigarLeft(Cigar cigar, int indexOfIndel) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(cigar.numCigarElements());
        for (int i = 0; i < indexOfIndel - 1; ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        CigarElement ce = cigar.getCigarElement(indexOfIndel - 1);
        elements.add(new CigarElement(Math.max(ce.getLength() - 1, 0), ce.getOperator()));
        elements.add(cigar.getCigarElement(indexOfIndel));
        if (indexOfIndel + 1 < cigar.numCigarElements()) {
            ce = cigar.getCigarElement(indexOfIndel + 1);
            elements.add(new CigarElement(ce.getLength() + 1, ce.getOperator()));
        } else {
            elements.add(new CigarElement(1, CigarOperator.M));
        }
        for (int i = indexOfIndel + 2; i < cigar.numCigarElements(); ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        return new Cigar(elements);
    }

    @Requires(value={"cigar != null && indexOfIndel >= 0 && indexOfIndel < cigar.numCigarElements() && refSeq != null && readSeq != null && refIndex >= 0 && readIndex >= 0"})
    @Ensures(value={"result != null"})
    private static byte[] createIndelString(Cigar cigar, int indexOfIndel, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        byte[] alt;
        CigarElement indel = cigar.getCigarElement(indexOfIndel);
        int indelLength = indel.getLength();
        int totalRefBases = 0;
        block5: for (int i = 0; i < indexOfIndel; ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            int length = ce.getLength();
            switch (ce.getOperator()) {
                case M: 
                case X: 
                case EQ: {
                    readIndex += length;
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
                case S: {
                    readIndex += length;
                    continue block5;
                }
                case N: {
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
            }
        }
        if (totalRefBases + indelLength > refSeq.length) {
            indelLength -= totalRefBases + indelLength - refSeq.length;
        }
        if (refIndex > (alt = new byte[refSeq.length + indelLength * (indel.getOperator() == CigarOperator.D ? -1 : 1)]).length || refIndex > refSeq.length) {
            return null;
        }
        System.arraycopy(refSeq, 0, alt, 0, refIndex);
        int currentPos = refIndex;
        if (indel.getOperator() == CigarOperator.D) {
            refIndex += indelLength;
        } else {
            System.arraycopy(readSeq, readIndex, alt, currentPos, indelLength);
            currentPos += indelLength;
        }
        if (refSeq.length - refIndex > alt.length - currentPos) {
            return null;
        }
        System.arraycopy(refSeq, refIndex, alt, currentPos, refSeq.length - refIndex);
        return alt;
    }

    public static Cigar trimCigarByReference(Cigar cigar, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Start must be >= 0 but got " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("End " + end + " is < start start " + start);
        }
        if (end > cigar.getReferenceLength()) {
            throw new IllegalArgumentException("End is beyond the cigar's reference length " + end + " for cigar " + cigar);
        }
        Cigar result = AlignmentUtils.trimCigar(cigar, start, end, true);
        if (result.getReferenceLength() != end - start + 1) {
            throw new IllegalStateException("trimCigarByReference failure: start " + start + " end " + end + " for " + cigar + " resulted in cigar with wrong size " + result);
        }
        return result;
    }

    public static Cigar trimCigarByBases(Cigar cigar, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Start must be >= 0 but got " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("End " + end + " is < start = " + start);
        }
        if (end > cigar.getReadLength()) {
            throw new IllegalArgumentException("End is beyond the cigar's read length " + end + " for cigar " + cigar);
        }
        Cigar result = AlignmentUtils.trimCigar(cigar, start, end, false);
        int expectedSize = end - start + 1;
        if (result.getReadLength() != expectedSize) {
            throw new IllegalStateException("trimCigarByBases failure: start " + start + " end " + end + " for " + cigar + " resulted in cigar with wrong size " + result + " with size " + result.getReadLength() + " expected " + expectedSize + " for input cigar " + cigar);
        }
        return result;
    }

    @Requires(value={"cigar != null", "start >= 0", "start <= end"})
    @Ensures(value={"result != null"})
    private static Cigar trimCigar(Cigar cigar, int start, int end, boolean byReference) {
        LinkedList<CigarElement> newElements = new LinkedList<CigarElement>();
        int pos = 0;
        block5: for (CigarElement elt : cigar.getCigarElements()) {
            if (pos > end && (byReference || elt.getOperator() != CigarOperator.D)) break;
            switch (elt.getOperator()) {
                case D: {
                    if (!byReference) {
                        if (pos < start) continue block5;
                        newElements.add(elt);
                        continue block5;
                    }
                }
                case M: 
                case X: 
                case EQ: {
                    pos = AlignmentUtils.addCigarElements(newElements, pos, start, end, elt);
                    continue block5;
                }
                case I: 
                case S: {
                    if (byReference) {
                        if (pos < start) continue block5;
                        newElements.add(elt);
                        continue block5;
                    }
                    pos = AlignmentUtils.addCigarElements(newElements, pos, start, end, elt);
                    continue block5;
                }
            }
            throw new IllegalStateException("Cannot handle " + elt);
        }
        return AlignmentUtils.consolidateCigar(new Cigar(newElements));
    }

    protected static int addCigarElements(List<CigarElement> dest, int pos, int start, int end, CigarElement elt) {
        int length = Math.min(pos + elt.getLength() - 1, end) - Math.max(pos, start) + 1;
        if (length > 0) {
            dest.add(new CigarElement(length, elt.getOperator()));
        }
        return pos + elt.getLength();
    }

    public static int calcFirstBaseMatchingReferenceInCigar(Cigar cigar, int readStartByBaseOfCigar) {
        if (cigar == null) {
            throw new IllegalArgumentException("cigar cannot be null");
        }
        if (readStartByBaseOfCigar >= cigar.getReadLength()) {
            throw new IllegalArgumentException("readStartByBaseOfCigar " + readStartByBaseOfCigar + " must be <= readLength " + cigar.getReadLength());
        }
        int hapOffset = 0;
        int refOffset = 0;
        for (CigarElement ce : cigar.getCigarElements()) {
            block6: for (int i = 0; i < ce.getLength(); ++i) {
                switch (ce.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        if (hapOffset >= readStartByBaseOfCigar) {
                            return refOffset;
                        }
                        ++hapOffset;
                        ++refOffset;
                        continue block6;
                    }
                    case I: 
                    case S: {
                        ++hapOffset;
                        continue block6;
                    }
                    case D: {
                        ++refOffset;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("calcFirstBaseMatchingReferenceInCigar does not support cigar " + (Object)((Object)ce.getOperator()) + " in cigar " + cigar);
                    }
                }
            }
        }
        throw new IllegalStateException("Never found appropriate matching state for cigar " + cigar + " given start of " + readStartByBaseOfCigar);
    }

    public static Cigar applyCigarToCigar(Cigar firstToSecond, Cigar secondToThird) {
        boolean DEBUG = false;
        LinkedList<CigarElement> newElements = new LinkedList<CigarElement>();
        int nElements12 = firstToSecond.getCigarElements().size();
        int nElements23 = secondToThird.getCigarElements().size();
        int cigar12I = 0;
        int cigar23I = 0;
        int elt12I = 0;
        int elt23I = 0;
        while (cigar12I < nElements12 && cigar23I < nElements23) {
            CigarElement elt12 = firstToSecond.getCigarElement(cigar12I);
            CigarElement elt23 = secondToThird.getCigarElement(cigar23I);
            CigarPairTransform transform = AlignmentUtils.getTransformer(elt12.getOperator(), elt23.getOperator());
            if (transform.op13 != null) {
                newElements.add(new CigarElement(1, transform.op13));
            }
            elt23I += transform.advance23;
            if ((elt12I += transform.advance12) == elt12.getLength()) {
                ++cigar12I;
                elt12I = 0;
            }
            if (elt23I != elt23.getLength()) continue;
            ++cigar23I;
            elt23I = 0;
        }
        return AlignmentUtils.consolidateCigar(new Cigar(newElements));
    }

    private static CigarPairTransform getTransformer(CigarOperator op12, CigarOperator op23) {
        for (CigarPairTransform transform : cigarPairTransformers) {
            if (!transform.op12.contains((Object)op12) || !transform.op23.contains((Object)op23)) continue;
            return transform;
        }
        throw new IllegalStateException("No transformer for operators " + (Object)((Object)op12) + " and " + (Object)((Object)op23));
    }

    private static class CigarPairTransform {
        private final EnumSet<CigarOperator> op12;
        private final EnumSet<CigarOperator> op23;
        private final CigarOperator op13;
        private final int advance12;
        private final int advance23;

        private CigarPairTransform(CigarOperator op12, CigarOperator op23, CigarOperator op13, int advance12, int advance23) {
            this.op12 = CigarPairTransform.getCigarSet(op12);
            this.op23 = CigarPairTransform.getCigarSet(op23);
            this.op13 = op13;
            this.advance12 = advance12;
            this.advance23 = advance23;
        }

        private static EnumSet<CigarOperator> getCigarSet(CigarOperator masterOp) {
            switch (masterOp) {
                case M: {
                    return EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X);
                }
                case I: {
                    return EnumSet.of(CigarOperator.I, CigarOperator.S);
                }
                case D: {
                    return EnumSet.of(CigarOperator.D);
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)masterOp));
        }

        public String toString() {
            return "CigarPairTransform{op12=" + this.op12 + ", op23=" + this.op23 + ", op13=" + (Object)((Object)this.op13) + ", advance12=" + this.advance12 + ", advance23=" + this.advance23 + '}';
        }
    }

    public static class MismatchCount {
        public int numMismatches = 0;
        public long mismatchQualities = 0L;
    }
}

