/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration.covariates;

import java.util.EnumSet;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.NGSPlatform;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.covariates.StandardCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class CycleCovariate
implements StandardCovariate {
    private int MAXIMUM_CYCLE_VALUE;
    public static final int CUSHION_FOR_INDELS = 4;
    private String default_platform = null;
    private static final EnumSet<NGSPlatform> DISCRETE_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.ILLUMINA, NGSPlatform.SOLID, NGSPlatform.PACBIO, NGSPlatform.COMPLETE_GENOMICS);
    private static final EnumSet<NGSPlatform> FLOW_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.LS454, NGSPlatform.ION_TORRENT);

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.MAXIMUM_CYCLE_VALUE = RAC.MAXIMUM_CYCLE_VALUE;
        if (RAC.DEFAULT_PLATFORM != null && !NGSPlatform.isKnown(RAC.DEFAULT_PLATFORM)) {
            throw new UserException.CommandLineException("The requested default platform (" + RAC.DEFAULT_PLATFORM + ") is not a recognized platform.");
        }
        if (RAC.DEFAULT_PLATFORM != null) {
            this.default_platform = RAC.DEFAULT_PLATFORM;
        }
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        NGSPlatform ngsPlatform;
        int readLength = read.getReadLength();
        NGSPlatform nGSPlatform = ngsPlatform = this.default_platform == null ? read.getNGSPlatform() : NGSPlatform.fromReadGroupPL(this.default_platform);
        if (DISCRETE_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            int increment;
            int cycle;
            int readOrderFactor;
            int n = readOrderFactor = read.getReadPairedFlag() && read.getSecondOfPairFlag() ? -1 : 1;
            if (read.getReadNegativeStrandFlag()) {
                cycle = readLength * readOrderFactor;
                increment = -1 * readOrderFactor;
            } else {
                cycle = readOrderFactor;
                increment = readOrderFactor;
            }
            int MAX_CYCLE_FOR_INDELS = readLength - 4 - 1;
            for (int i = 0; i < readLength; ++i) {
                int substitutionKey = this.keyFromCycle(cycle);
                int indelKey = i < 4 || i > MAX_CYCLE_FOR_INDELS ? -1 : substitutionKey;
                values.addCovariate(substitutionKey, indelKey, indelKey, i);
                cycle += increment;
            }
        } else if (FLOW_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            int cycle;
            byte[] bases = read.getReadBases();
            boolean multiplyByNegative1 = read.getReadPairedFlag() && read.getSecondOfPairFlag();
            int n = cycle = multiplyByNegative1 ? -1 : 1;
            if (!read.getReadNegativeStrandFlag()) {
                int iii = 0;
                while (iii < readLength) {
                    int key;
                    while (iii < readLength && bases[iii] == 84) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 65) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 67) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 71) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        ++iii;
                    }
                    if (iii < readLength) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii >= readLength || BaseUtils.isRegularBase(bases[iii])) continue;
                    key = this.keyFromCycle(cycle);
                    values.addCovariate(key, key, key, iii);
                    ++iii;
                }
            } else {
                int iii = readLength - 1;
                while (iii >= 0) {
                    int key;
                    while (iii >= 0 && bases[iii] == 84) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 65) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 67) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 71) {
                        key = this.keyFromCycle(cycle);
                        values.addCovariate(key, key, key, iii);
                        --iii;
                    }
                    if (iii >= 0) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii < 0 || BaseUtils.isRegularBase(bases[iii])) continue;
                    key = this.keyFromCycle(cycle);
                    values.addCovariate(key, key, key, iii);
                    --iii;
                }
            }
        } else {
            throw new UserException("The platform (" + read.getReadGroup().getPlatform() + ") associated with read group " + read.getReadGroup() + " is not a recognized platform. Allowable options are " + NGSPlatform.knownPlatformsString());
        }
    }

    @Override
    public final Object getValue(String str) {
        return Integer.parseInt(str);
    }

    @Override
    public String formatKey(int key) {
        int cycle = key >> 1;
        if ((key & 1) != 0) {
            cycle *= -1;
        }
        return String.format("%d", cycle);
    }

    @Override
    public int keyFromValue(Object value) {
        return value instanceof String ? this.keyFromCycle(Integer.parseInt((String)value)) : this.keyFromCycle((Integer)value);
    }

    @Override
    public int maximumKeyValue() {
        return (this.MAXIMUM_CYCLE_VALUE << 1) + 1;
    }

    private int keyFromCycle(int cycle) {
        int result = Math.abs(cycle);
        if (result > this.MAXIMUM_CYCLE_VALUE) {
            throw new UserException("The maximum allowed value for the cycle is " + this.MAXIMUM_CYCLE_VALUE + ", but a larger cycle (" + result + ") was detected.  Please use the --maximum_cycle_value argument to increase this value (at the expense of requiring more memory to run)");
        }
        result <<= 1;
        if (cycle < 0) {
            ++result;
        }
        return result;
    }
}

