/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.N2MemoryPairHMM;

public final class Log10PairHMM
extends N2MemoryPairHMM {
    private final boolean doExactLog10;
    private static final int matchToMatch = 0;
    private static final int indelToMatch = 1;
    private static final int matchToInsertion = 2;
    private static final int insertionToInsertion = 3;
    private static final int matchToDeletion = 4;
    private static final int deletionToDeletion = 5;

    public Log10PairHMM(boolean doExactLog10) {
        this.doExactLog10 = doExactLog10;
    }

    public boolean isDoingExactLog10Calculations() {
        return this.doExactLog10;
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        for (int iii = 0; iii < this.paddedMaxReadLength; ++iii) {
            Arrays.fill(this.matchMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.insertionMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.deletionMatrix[iii], Double.NEGATIVE_INFINITY);
        }
        this.transition = new double[this.paddedMaxReadLength][6];
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = Math.log10(1.0 / (double)haplotypeBases.length);
            for (int j = 0; j < this.paddedHaplotypeLength; ++j) {
                this.deletionMatrix[0][j] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            this.initializeProbabilities(insertionGOP, deletionGOP, overallGCP);
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i = 1; i < this.paddedReadLength; ++i) {
            for (int j = hapStartIndex + 1; j < this.paddedHaplotypeLength; ++j) {
                this.updateCell(i, j, this.prior[i][j], this.transition[i]);
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = this.myLog10SumLog10(new double[]{this.matchMatrix[endI][1], this.insertionMatrix[endI][1]});
        for (int j = 2; j < this.paddedHaplotypeLength; ++j) {
            finalSumProbabilities = this.myLog10SumLog10(new double[]{finalSumProbabilities, this.matchMatrix[endI][j], this.insertionMatrix[endI][j]});
        }
        return finalSumProbabilities;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProbLog10(qual) : QualityUtils.qualToErrorProbLog10(qual);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    private void initializeProbabilities(byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        for (int i = 0; i < insertionGOP.length; ++i) {
            int qualIndexGOP = Math.min(insertionGOP[i] + deletionGOP[i], 127);
            this.transition[i + 1][0] = QualityUtils.qualToProbLog10((byte)qualIndexGOP);
            this.transition[i + 1][1] = QualityUtils.qualToProbLog10(overallGCP[i]);
            this.transition[i + 1][2] = QualityUtils.qualToErrorProbLog10(insertionGOP[i]);
            this.transition[i + 1][3] = QualityUtils.qualToErrorProbLog10(overallGCP[i]);
            this.transition[i + 1][4] = QualityUtils.qualToErrorProbLog10(deletionGOP[i]);
            this.transition[i + 1][5] = QualityUtils.qualToErrorProbLog10(overallGCP[i]);
        }
        this.constantsAreInitialized = true;
    }

    @Requires(value={"values != null"})
    private double myLog10SumLog10(double[] values) {
        return this.doExactLog10 ? MathUtils.log10sumLog10(values) : MathUtils.approximateLog10SumLog10(values);
    }

    private void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior + this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ - 1] + transition[0], this.insertionMatrix[indI - 1][indJ - 1] + transition[1], this.deletionMatrix[indI - 1][indJ - 1] + transition[1]});
        this.insertionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ] + transition[2], this.insertionMatrix[indI - 1][indJ] + transition[3]});
        this.deletionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI][indJ - 1] + transition[4], this.deletionMatrix[indI][indJ - 1] + transition[5]});
    }
}

