/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class SoapSNPCodec
extends AsciiFeatureCodec<VariantContext>
implements NameAwareCodec {
    private String[] parts;
    private String name = "Unknown";
    private static final Map<Character, String> IUPAC_SNPS = new HashMap<Character, String>();

    public SoapSNPCodec() {
        super(VariantContext.class);
    }

    @Override
    public VariantContext decode(String line) {
        try {
            this.parts = line.trim().split("\\s+");
            if (this.parts.length != 18) {
                throw new CodecLineParsingException("Invalid SoapSNP row found -- incorrect element count.  Expected 18, got " + this.parts.length + " line = " + line);
            }
            String contig = this.parts[0];
            long start = Long.valueOf(this.parts[1]);
            AlleleAndGenotype allelesAndGenotype = this.parseAlleles(this.parts[2], this.parts[3], line);
            double log10PError = (double)Integer.valueOf(this.parts[4]).intValue() / -10.0;
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("BestBaseQ", this.parts[6]);
            attributes.put("SecondBestBaseQ", this.parts[10]);
            attributes.put("RankSumP", this.parts[15]);
            VariantContext vc = new VariantContextBuilder(this.name, contig, start, start, allelesAndGenotype.alleles).genotypes(allelesAndGenotype.genotype).log10PError(log10PError).passFilters().attributes(attributes).make();
            return vc;
        }
        catch (CodecLineParsingException e) {
            throw new TribbleException("Unable to parse line " + line, e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new TribbleException("Unable to parse line " + line, e);
        }
    }

    private AlleleAndGenotype parseAlleles(String ref, String consensusGenotype, String line) {
        if (ref.equals(consensusGenotype)) {
            throw new TribbleException.InternalCodecException("Ref base and consensus genotype are the same " + ref);
        }
        Allele refAllele = Allele.create(ref, true);
        List<Allele> genotypeAlleles = null;
        char base = consensusGenotype.charAt(0);
        switch (base) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': {
                Allele a = Allele.create(consensusGenotype);
                genotypeAlleles = Arrays.asList(a, a);
                break;
            }
            case 'K': 
            case 'M': 
            case 'R': 
            case 'S': 
            case 'W': 
            case 'Y': {
                genotypeAlleles = this.determineAlt(refAllele, ref.charAt(0), base);
                break;
            }
            default: {
                throw new TribbleException("Unexpected consensus genotype " + consensusGenotype + " at line = " + line);
            }
        }
        HashSet<Allele> alleles = new HashSet<Allele>(genotypeAlleles);
        alleles.add(refAllele);
        Genotype genotype = GenotypeBuilder.create("unknown", genotypeAlleles);
        return new AlleleAndGenotype(alleles, genotype);
    }

    private List<Allele> determineAlt(Allele ref, char refbase, char alt) {
        String alts = IUPAC_SNPS.get(Character.valueOf(alt));
        if (alts == null) {
            throw new IllegalStateException("BUG: unexpected consensus genotype " + alt);
        }
        Allele a1 = alts.charAt(0) == refbase ? ref : Allele.create((byte)alts.charAt(0));
        Allele a2 = alts.charAt(1) == refbase ? ref : Allele.create((byte)alts.charAt(1));
        return Arrays.asList(a1, a2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static void main(String[] args) {
        System.out.printf("Testing " + args[0], new Object[0]);
    }

    static {
        IUPAC_SNPS.put(Character.valueOf('R'), "AG");
        IUPAC_SNPS.put(Character.valueOf('Y'), "CT");
        IUPAC_SNPS.put(Character.valueOf('S'), "GC");
        IUPAC_SNPS.put(Character.valueOf('W'), "AT");
        IUPAC_SNPS.put(Character.valueOf('K'), "GT");
        IUPAC_SNPS.put(Character.valueOf('M'), "AC");
    }

    private static class AlleleAndGenotype {
        Collection<Allele> alleles;
        Collection<Genotype> genotype;

        public AlleleAndGenotype(Collection<Allele> alleles, Genotype genotype) {
            this.alleles = alleles;
            this.genotype = new HashSet<Genotype>();
            this.genotype.add(genotype);
        }
    }
}

