/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class ProcessUtils {
    private static Logger logger = Logger.getLogger(ProcessUtils.class);

    public static int runCommandAndWait(String command) {
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        if (command.equals("")) {
            throw new IllegalArgumentException("command cannot be the empty string");
        }
        try {
            logger.debug("Running command: " + command);
            Process p = Runtime.getRuntime().exec(command);
            int result = p.waitFor();
            if (logger.isDebugEnabled()) {
                for (String line : new XReadLines(p.getInputStream())) {
                    logger.debug("command: " + line);
                }
                for (String line : new XReadLines(p.getErrorStream())) {
                    logger.error("command: " + line);
                }
            }
            logger.debug("Command exited with result: " + result);
            return result;
        }
        catch (Exception e) {
            throw new ReviewedStingException("Error running command:" + command, e);
        }
    }
}

