/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.pipeline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.picard.io.IoUtil;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GSAPipelineIndexer
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(GSAPipelineIndexer.class);
    @Argument(fullName="rootDirectory", shortName="r", doc="Root of the directory tree to index", required=false)
    private File rootDirectory = new File("/humgen/gsa-pipeline/");
    @Argument(fullName="webRoot", shortName="w", doc="Alias for the root directory path in the URLs we generate", required=false)
    private String webRoot = "gsa_pipeline_output";
    @Output(fullName="outputFile", shortName="o", doc="File to which the XML index should be written", required=false)
    private File outputFile = new File("index.xml");
    @Argument(fullName="useDebugSamples", shortName="d", doc="If set, index only samples in the debug directory (P0010)", required=false)
    private boolean useDebugSamples = false;
    @Argument(fullName="printPaths", shortName="p", doc="If set, output the path to each TSV file as it's processed", required=false)
    private boolean printPaths = false;
    @Argument(fullName="noSymlinks", shortName="nsl", doc="If set, do not create symlinks to Picard bams (for debugging/dry-run purposes only)", required=false)
    private boolean noSymlinks = false;
    @Argument(fullName="debugSymlinkDir", shortName="ds", doc="If given, create all symlinks in the specified directory instead of in their \"live\" locations within the directory tree being indexed (for debugging/dry-run purposes only)", required=false)
    private File debugSymlinkDir = null;
    @Argument(fullName="noSort", shortName="ns", doc="If set, don't sort the XML elements (for debugging/dry-run purposes only)", required=false)
    private boolean noSort = false;
    public static final String DEFAULT_ROOT_DIRECTORY = "/humgen/gsa-pipeline/";
    public static final String DEFAULT_WEB_ROOT = "gsa_pipeline_output";
    public static final String DEFAULT_OUTPUT_FILE = "index.xml";
    public static final String BAM_LINKS_SUBDIRECTORY = ".bamlinks";
    public static final String IGV_HYPERLINK = "https://iwww.broadinstitute.org/gsa/wiki/index.php/GSA_Firehose";
    public static final String HOST_PREFIX = "http://gsa-igv-web.broadinstitute.org/";
    public static final String PICARD_ROOT_DIRECTORY = "/seq/picard_aggregation/";
    public static final String DEBUG_DIRECTORY_NAME = "P0010";
    public static final String ROOT_ELEMENT_TAG_NAME = "Global";
    public static final String CATEGORY_ELEMENT_TAG_NAME = "Category";
    public static final String RESOURCE_ELEMENT_TAG_NAME = "Resource";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String HYPERLINK_ATTRIBUTE = "hyperlink";
    public static final String VERSION_ATTRIBUTE = "version";
    public static final String ROOT_ELEMENT_NAME_ATTRIBUTE = "GSA IGV Web";
    public static final String ROOT_ELEMENT_VERSION_ATTRIBUTE = "1.0";
    public static final String[] RESOURCE_FILE_EXTENSIONS = new String[]{".bam", ".maf_annotated.vcf", ".cleaned.annotated.handfiltered.vcf", ".filtered.annotated.vcf"};
    public static final String[] FILENAME_BLACKLIST = new String[]{".bamlinks", "queueScatterGather", "temp-", "Scatter", "Intermediate"};
    private Comparator<Element> nodeComparator = new Comparator<Element>(){

        @Override
        public int compare(Element first, Element second) {
            if (GSAPipelineIndexer.this.isCategoryNode(first) && !GSAPipelineIndexer.this.isCategoryNode(second)) {
                return -1;
            }
            if (!GSAPipelineIndexer.this.isCategoryNode(first) && GSAPipelineIndexer.this.isCategoryNode(second)) {
                return 1;
            }
            return first.getAttribute(GSAPipelineIndexer.NAME_ATTRIBUTE).compareTo(second.getAttribute(GSAPipelineIndexer.NAME_ATTRIBUTE));
        }
    };

    @Override
    protected int execute() throws Exception {
        Document xmlDocument = this.createXMLIndex();
        this.writeXMLFile(xmlDocument);
        return 0;
    }

    private Document createXMLIndex() {
        Document xmlDocument = this.newXmlDocument();
        Element rootNode = this.createXmlRootNode(xmlDocument);
        this.indexDirectoryTree(this.rootDirectory, xmlDocument, rootNode, 1);
        return xmlDocument;
    }

    private void writeXMLFile(Document xmlDocument) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource xml = new DOMSource(xmlDocument);
            StreamResult output = new StreamResult(this.outputFile);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xml, output);
        }
        catch (TransformerConfigurationException e) {
            throw new ReviewedStingException("Unable to initialize the XML output transformer: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new ReviewedStingException("An unrecoverable error occurred while writing the XML file: " + e.getMessage());
        }
    }

    private Document newXmlDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ReviewedStingException("Unable to initialize the XML Document Builder: " + e.getMessage());
        }
        return documentBuilder.newDocument();
    }

    private Element createXmlRootNode(Document xmlDocument) {
        Element rootNode = xmlDocument.createElement(ROOT_ELEMENT_TAG_NAME);
        rootNode.setAttribute(NAME_ATTRIBUTE, ROOT_ELEMENT_NAME_ATTRIBUTE);
        rootNode.setAttribute(HYPERLINK_ATTRIBUTE, IGV_HYPERLINK);
        rootNode.setAttribute(VERSION_ATTRIBUTE, ROOT_ELEMENT_VERSION_ATTRIBUTE);
        xmlDocument.appendChild(rootNode);
        return rootNode;
    }

    private void indexDirectoryTree(File directory, Document xmlDocument, Element parentNode, int depth) {
        File[] directoryContents = directory.listFiles();
        if (directoryContents == null || directoryContents.length == 0) {
            return;
        }
        ArrayList<Element> childNodes = new ArrayList<Element>(directoryContents.length);
        for (File currentFile : directoryContents) {
            String currentFileName = currentFile.getName();
            String currentFilePath = currentFile.getPath();
            if (this.skipFile(currentFileName, depth)) continue;
            if (currentFile.isDirectory()) {
                Element directoryNode = this.newCategoryNode(xmlDocument, currentFileName);
                this.indexDirectoryTree(currentFile, xmlDocument, directoryNode, depth + 1);
                if (!directoryNode.hasChildNodes()) continue;
                childNodes.add(directoryNode);
                continue;
            }
            if (this.isTSVFile(currentFileName)) {
                if (this.printPaths) {
                    logger.info("Processing " + currentFilePath);
                }
                this.processTSVFile(currentFile, xmlDocument, childNodes);
                continue;
            }
            if (!this.isResource(currentFilePath)) continue;
            Element resourceNode = this.newResourceNode(xmlDocument, currentFileName, this.pathToUrl(currentFilePath));
            childNodes.add(resourceNode);
        }
        if (!this.noSort) {
            Collections.sort(childNodes, this.nodeComparator);
        }
        for (Element child : childNodes) {
            parentNode.appendChild(child);
        }
    }

    private Element newCategoryNode(Document xmlDocument, String nameAttribute) {
        Element newCategoryNode = xmlDocument.createElement(CATEGORY_ELEMENT_TAG_NAME);
        newCategoryNode.setAttribute(NAME_ATTRIBUTE, nameAttribute);
        return newCategoryNode;
    }

    private boolean isCategoryNode(Element node) {
        return node != null && node.getTagName().equals(CATEGORY_ELEMENT_TAG_NAME);
    }

    private Element newResourceNode(Document xmlDocument, String nameAttribute, String pathAttribute) {
        Element newResourceNode = xmlDocument.createElement(RESOURCE_ELEMENT_TAG_NAME);
        newResourceNode.setAttribute(NAME_ATTRIBUTE, nameAttribute);
        newResourceNode.setAttribute(PATH_ATTRIBUTE, pathAttribute);
        return newResourceNode;
    }

    private void processTSVFile(File tsvFile, Document xmlDocument, ArrayList<Element> childNodes) {
        try {
            for (String tsvLine : new XReadLines(tsvFile, true)) {
                String[] tsvLineTokens = tsvLine.split("\\t");
                if (tsvLineTokens.length != 2) {
                    logger.warn("Malformed line in TSV file " + tsvFile.getAbsolutePath() + ": " + tsvLine);
                    continue;
                }
                String picardProject = tsvLineTokens[0].trim();
                String picardSample = IoUtil.makeFileNameSafe(tsvLineTokens[1].trim());
                String picardPathPrefix = String.format("/seq/picard_aggregation/%s/%s/current/%s", picardProject, picardSample, picardSample);
                File picardBam = new File(picardPathPrefix + ".bam");
                File picardBai = new File(picardPathPrefix + ".bai");
                if (!picardBam.isFile()) {
                    logger.warn("File " + picardBam.getAbsolutePath() + " does not exist (listed in TSV file " + tsvFile.getAbsolutePath() + ")");
                    continue;
                }
                if (!picardBai.isFile()) {
                    logger.warn("Could not find a bai file for bam " + picardBam.getAbsolutePath());
                    continue;
                }
                String bamUrl = this.createPicardBamSymlinks(picardBam, picardBai, this.debugSymlinkDir == null ? tsvFile.getParent() : this.debugSymlinkDir.getPath());
                if (bamUrl == null) continue;
                childNodes.add(this.newResourceNode(xmlDocument, picardBam.getName(), bamUrl));
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("Could not open TSV file " + tsvFile.getAbsolutePath() + " Reason: " + e.getMessage());
        }
    }

    private boolean skipFile(String fileName, int depth) {
        if (this.useDebugSamples && depth == 1) {
            return !fileName.equals(DEBUG_DIRECTORY_NAME);
        }
        return this.fileIsBlacklisted(fileName) || depth == 1 && !fileName.matches("^P....$");
    }

    private boolean fileIsBlacklisted(String fileName) {
        for (String blacklistedPrefix : FILENAME_BLACKLIST) {
            if (!fileName.startsWith(blacklistedPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isTSVFile(String fileName) {
        return fileName.endsWith(".tsv");
    }

    private boolean isResource(String filePath) {
        return this.isProjectVCF(filePath) || this.hasResourceFileExtension(filePath);
    }

    private boolean isProjectVCF(String filePath) {
        File correspondingTSVFile = new File(filePath.replaceAll("\\.vcf$", ".tsv"));
        return filePath.endsWith(".vcf") && correspondingTSVFile.isFile();
    }

    private boolean hasResourceFileExtension(String filePath) {
        for (String resourceFileExtension : RESOURCE_FILE_EXTENSIONS) {
            if (!filePath.endsWith(resourceFileExtension)) continue;
            return true;
        }
        return false;
    }

    private String pathToUrl(String path) {
        String rootDirRemoved = path.replaceFirst(this.rootDirectory.getPath(), "");
        if (rootDirRemoved.startsWith("/")) {
            return HOST_PREFIX + this.webRoot + rootDirRemoved;
        }
        return HOST_PREFIX + this.webRoot + "/" + rootDirRemoved;
    }

    private String createPicardBamSymlinks(File picardBam, File picardBai, String parentDirectory) {
        boolean baiLinkCreated;
        String linkDirectoryPath = parentDirectory + "/" + BAM_LINKS_SUBDIRECTORY;
        File linkDirectory = new File(linkDirectoryPath);
        String bamLinkPath = linkDirectoryPath + "/" + picardBam.getName();
        String baiLinkPath = linkDirectoryPath + "/" + picardBai.getName();
        if (!(this.noSymlinks || linkDirectory.isDirectory() || linkDirectory.mkdir())) {
            logger.warn("Could not create symlink directory " + linkDirectory);
            return null;
        }
        boolean bamLinkCreated = this.noSymlinks || this.createSymlink(picardBam.getAbsolutePath(), bamLinkPath);
        boolean bl = baiLinkCreated = this.noSymlinks || this.createSymlink(picardBai.getAbsolutePath(), baiLinkPath);
        if (bamLinkCreated && baiLinkCreated) {
            return this.pathToUrl(bamLinkPath);
        }
        return null;
    }

    private boolean createSymlink(String target, String link) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process lnProcess = runtime.exec("ln -fs " + target + " " + link);
            int lnReturnValue = lnProcess.waitFor();
            if (lnReturnValue != 0) {
                logger.warn("Could not create symlink " + link + " to " + target + ": ln returned " + lnReturnValue);
                return false;
            }
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted while creating symlink " + link + " to " + target + ": " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            logger.warn("I/O error while creating symlink " + link + " to " + target + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            GSAPipelineIndexer instance = new GSAPipelineIndexer();
            GSAPipelineIndexer.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e) {
            GSAPipelineIndexer.exitSystemWithUserError(e);
        }
        catch (Exception e) {
            GSAPipelineIndexer.exitSystemWithError(e);
        }
    }
}

