/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.seekablestream.SeekableStream;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class SeekableSplitStream
extends SeekableStream {
    long position = 0L;
    long length = 0L;
    List<PartDescriptor> descriptors;
    int currentStreamIndex = 0;
    private String path;

    public SeekableSplitStream(String path) throws IOException {
        this.path = path;
        this.parseDescriptors(path);
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
        long end = 0L;
        long start = 0L;
        for (PartDescriptor desc : this.descriptors) {
            if (position >= start && position < (end += desc.getContentLength())) {
                long delta = position - start;
                desc.getStream().seek(delta);
            } else {
                desc.getStream().seek(0L);
            }
            start = end;
        }
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int bytesRead = 0;
        long end = 0L;
        long start = 0L;
        for (PartDescriptor desc : this.descriptors) {
            if (this.position >= start && this.position < (end += desc.getContentLength())) {
                int delta = (int)(desc.contentLength - desc.stream.position());
                int l = Math.min(len - bytesRead, delta);
                int nBytes = desc.stream.read(buffer, off + bytesRead, l);
                if (nBytes < 0) {
                    return nBytes;
                }
                this.position += (long)nBytes;
                if ((bytesRead += nBytes) >= len) break;
            }
            start = end;
        }
        return bytesRead > 0 ? bytesRead : -1;
    }

    @Override
    public int read() throws IOException {
        int b = this.descriptors.get(this.currentStreamIndex).getStream().read();
        ++this.position;
        return b;
    }

    @Override
    public void close() throws IOException {
        for (PartDescriptor desc : this.descriptors) {
            desc.getStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDescriptors(String path) throws IOException {
        BufferedReader br = null;
        this.descriptors = new ArrayList<PartDescriptor>();
        try {
            String nextLine;
            br = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(path)));
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = nextLine.split(" ");
                if (tokens.length != 2) continue;
                String p = tokens[0];
                String listFileName = null;
                if (HttpUtils.isRemoteURL(path)) {
                    URL url = new URL(path);
                    listFileName = new File(url.getPath()).getName();
                } else {
                    listFileName = new File(path).getName();
                }
                SeekableStream stream = IGVSeekableStreamFactory.getInstance().getStreamFor(path.replace(listFileName, p));
                long length = Long.parseLong(tokens[1]);
                this.descriptors.add(new PartDescriptor(length, stream));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean eof() throws IOException {
        return false;
    }

    @Override
    public String getSource() {
        return this.path;
    }

    public static class PartDescriptor {
        private long contentLength;
        private SeekableStream stream;

        public PartDescriptor(long contentLength, SeekableStream stream) {
            this.contentLength = contentLength;
            this.stream = stream;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public SeekableStream getStream() {
            return this.stream;
        }
    }
}

