/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;

public class SaveSessionMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(SaveSessionMenuAction.class);
    IGV igv;

    public SaveSessionMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File sessionFile = null;
        String currentSessionFilePath = this.igv.getSession().getPath();
        String initFile = currentSessionFilePath == null ? "igv_session.xml" : currentSessionFilePath;
        sessionFile = FileDialogUtils.chooseFile("Save Session", PreferenceManager.getInstance().getLastSessionDirectory(), new File(initFile), FileDialogUtils.SAVE);
        if (sessionFile == null) {
            this.igv.resetStatusMessage();
            return;
        }
        String filePath = sessionFile.getAbsolutePath();
        if (!filePath.toLowerCase().endsWith(".xml")) {
            sessionFile = new File(filePath + ".xml");
        }
        this.igv.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());
        File sf = sessionFile;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            SaveSessionMenuAction.saveSession(this.igv, sf);
            PreferenceManager.getInstance().setLastSessionDirectory(sf.getParentFile());
        }
        catch (Exception e2) {
            SaveSessionMenuAction saveSessionMenuAction = this;
            JOptionPane.showMessageDialog(saveSessionMenuAction.igv.getMainFrame(), "There was an error writing to " + sf.getName() + "(" + e2.getMessage() + ")");
            log.error("Failed to save session!", e2);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.igv.resetStatusMessage();
        }
    }

    public static void saveSession(IGV igv, File targetFile) throws IOException {
        Session currentSession = igv.getSession();
        currentSession.setPath(targetFile.getAbsolutePath());
        new SessionWriter().saveSession(currentSession, targetFile);
    }
}

