/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlType(factoryMethod="getNextTrack")
@XmlSeeAlso(value={CombinedDataSource.class})
public class DataSourceTrack
extends DataTrack {
    private static Logger log = Logger.getLogger(DataSourceTrack.class);
    @XmlAttribute
    protected Class clazz = DataSourceTrack.class;
    private DataSource dataSource;
    private boolean firstDataLoaded = false;
    private boolean rescaleOnFirst = false;
    private static final String COMBINED_DATA_SOURCE = "COMBINED_DATA_SOURCE";

    private DataSourceTrack() {
        super(null, null, null);
    }

    public DataSourceTrack(ResourceLocator locator, String id, String name, DataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
        if (this.dataSource != null) {
            this.setTrackType(dataSource.getTrackType());
            List<LocusScore> scores = this.dataSource.getSummaryScoresForRange("All", -1, -1, 0);
            if (scores.size() == 0) {
                this.rescaleOnFirst = true;
            }
            this.initScale(dataSource, scores);
        }
    }

    void initScale(DataSource dataSource, List<LocusScore> scores) {
        float min = (float)dataSource.getDataMin();
        float max = (float)dataSource.getDataMax();
        float baseline = 0.0f;
        if (min > 0.0f) {
            min = 0.0f;
        }
        for (LocusScore score : scores) {
            max = Math.max(max, score.getScore());
        }
        this.setDataRange(new DataRange(min, baseline, max));
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        List tmp = this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        if (tmp == null) {
            tmp = Collections.EMPTY_LIST;
        }
        if (!this.firstDataLoaded && this.rescaleOnFirst) {
            this.initScale(this.dataSource, tmp);
            this.firstDataLoaded = true;
        }
        return tmp;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.clearCaches();
        if (this.dataSource != null) {
            this.dataSource.setWindowFunction(statType);
        }
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource.isLogNormalized();
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource != null ? this.dataSource.getWindowFunction() : null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.dataSource != null ? this.dataSource.getAvailableWindowFunctions() : null;
    }

    @Override
    public void restorePersistentState(Node node, int version) throws JAXBException {
        super.restorePersistentState(node, version);
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                Node child = childNodes.item(ii);
                String nodeName = child.getNodeName();
                if (nodeName.contains("#text") || !nodeName.equalsIgnoreCase(COMBINED_DATA_SOURCE)) continue;
                this.dataSource = (DataSource)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(child, CombinedDataSource.class).getValue();
            }
        }
    }

    public void marshalSource(Marshaller m, Element trackElement) throws JAXBException {
        if (this.dataSource == null) {
            return;
        }
        DataSource rawSource = this.dataSource;
        if (rawSource instanceof CombinedDataSource) {
            JAXBElement element = new JAXBElement(new QName("", COMBINED_DATA_SOURCE), CombinedDataSource.class, (Object)((CombinedDataSource)rawSource));
            m.marshal((Object)element, (Node)trackElement);
        }
    }

    public void updateTrackReferences(List<Track> allTracks) {
        if (this.dataSource instanceof CombinedDataSource) {
            ((CombinedDataSource)this.dataSource).updateTrackReferences(allTracks);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.dataSource != null) {
            this.dataSource.dispose();
        }
    }

    @XmlAttribute
    private void setNormalize(boolean normalize) {
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource) {
            ((CoverageDataSource)this.dataSource).setNormalize(normalize);
        }
    }

    private boolean getNormalize() {
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource) {
            return ((CoverageDataSource)this.dataSource).getNormalize();
        }
        return false;
    }

    private static DataSourceTrack getNextTrack() {
        DataSourceTrack out = (DataSourceTrack)IGVSessionReader.getNextTrack();
        if (out == null) {
            out = new DataSourceTrack();
        }
        return out;
    }
}

