/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class SAMFileGroup
implements Iterable<SAMRecord> {
    File[] samFiles;

    public SAMFileGroup(File[] samFiles) {
        this.samFiles = samFiles;
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SAMFileHeader getHeader() {
        if (this.samFiles.length == 0) {
            return null;
        }
        SAMFileReader reader = new SAMFileReader(this.samFiles[0]);
        SAMFileHeader header = reader.getFileHeader();
        reader.close();
        return header;
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return new SamGroupIterator();
    }

    public class SamGroupIterator
    implements CloseableIterator<SAMRecord> {
        int idx = 0;
        SAMFileReader currentReader;
        CloseableIterator<SAMRecord> currentIter;
        SAMRecord next;

        SamGroupIterator() {
            this.advance();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SAMRecord next() {
            SAMRecord ret = this.next;
            this.advance();
            return ret;
        }

        private void advance() {
            if (this.currentIter == null || !this.currentIter.hasNext()) {
                if (this.currentIter != null) {
                    this.currentIter.close();
                    this.currentIter = null;
                }
                if (this.currentReader != null) {
                    this.currentReader.close();
                }
                if (this.idx < SAMFileGroup.this.samFiles.length) {
                    this.currentReader = new SAMFileReader(SAMFileGroup.this.samFiles[this.idx]);
                    this.currentIter = this.currentReader.iterator();
                    ++this.idx;
                }
            }
            this.next = this.currentIter == null ? null : (SAMRecord)this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

