/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.Interval;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.sam.SparseAlignmentCounts;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.event.DataLoadedEvent;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;

@XmlType(factoryMethod="getNextTrack")
public class CoverageTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(CoverageTrack.class);
    public static final int TEN_MB = 10000000;
    char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    public static Color lightBlue = new Color(0, 0, 150);
    private static Color coverageGrey = new Color(175, 175, 175);
    public static final Color negStrandColor = new Color(140, 140, 160);
    public static final Color posStrandColor = new Color(160, 140, 140);
    public static final boolean DEFAULT_AUTOSCALE = true;
    public static final boolean DEFAULT_SHOW_REFERENCE = false;
    @XmlAttribute
    private float snpThreshold;
    @XmlAttribute
    boolean showReference;
    AlignmentDataManager dataManager;
    CoverageDataSource dataSource;
    DataRenderer dataSourceRenderer;
    IntervalRenderer intervalRenderer;
    PreferenceManager prefs;
    JMenuItem dataRangeItem;
    JMenuItem autoscaleItem;
    Genome genome;
    private AlignmentTrack.RenderOptions renderOptions = null;
    static float[] colorComps = new float[3];

    public void setRenderOptions(AlignmentTrack.RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    AlignmentTrack.RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public CoverageTrack(CoverageTrack track) {
        this(track.getResourceLocator(), track.getName(), track.genome);
        if (track.dataManager != null) {
            this.setDataManager(track.dataManager);
        }
        if (track.dataSource != null) {
            this.setDataSource(track.dataSource);
        }
    }

    public CoverageTrack(ResourceLocator locator, String name, Genome genome) {
        super(locator, locator.getPath() + "_coverage", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.genome = genome;
        this.intervalRenderer = new IntervalRenderer();
        this.setMaximumHeight(40);
        this.setColor(coverageGrey);
        this.prefs = PreferenceManager.getInstance();
        this.snpThreshold = this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        this.autoScale = true;
        this.showReference = false;
    }

    public void setDataManager(AlignmentDataManager dataManager) {
        this.dataManager = dataManager;
        this.dataManager.getEventBus().register(this);
    }

    public void setDataSource(CoverageDataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSourceRenderer = new BarChartRenderer();
        this.setDataRange(new DataRange(0.0f, 0.0f, 1.5f * (float)dataSource.getDataMax()));
    }

    public void setSnpThreshold(float snpThreshold) {
        this.snpThreshold = snpThreshold;
    }

    public float getSnpThreshold() {
        return this.snpThreshold;
    }

    public boolean isShowReference() {
        return this.showReference;
    }

    @Subscribe
    public void receiveDataLoaded(DataLoadedEvent e) {
        this.rescale();
        e.context.getReferenceFrame().getEventBus().post(new ViewChange.Result());
    }

    public void rescale() {
        if (this.autoScale & this.dataManager != null) {
            List<ReferenceFrame> frameList = FrameManager.getFrames();
            int max = 10;
            for (ReferenceFrame frame : frameList) {
                int end;
                AlignmentInterval interval = this.dataManager.getLoadedInterval(frame.getName());
                if (interval == null) continue;
                int origin = (int)frame.getOrigin();
                int intervalMax = interval.getMaxCount(origin, end = (int)frame.getEnd() + 1);
                max = intervalMax > max ? intervalMax : max;
            }
            boolean isLog = this.getDataRange().getType() == DataRange.Type.LOG;
            super.setDataRange(new DataRange(0.0f, 0.0f, max, isLog));
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.overlay(context, rect);
        this.drawBorder(context, rect);
        List<LocusScore> scores = this.getSummaryScores(context);
        if (scores != null) {
            this.dataSourceRenderer.renderBorder(this, context, rect);
        }
        if (!this.isRepeatY(rect)) {
            this.lastRenderY = rect.y;
            if (this.dataSourceRenderer != null) {
                this.dataSourceRenderer.renderAxis(this, context, rect);
            }
            if (FrameManager.isExomeMode()) {
                int x = context.getGraphics().getClipBounds().x;
                Rectangle scaleRect = new Rectangle(x, rect.y, rect.width, rect.height);
                this.drawScale(context, scaleRect);
            }
        }
    }

    private List<LocusScore> getSummaryScores(RenderContext context) {
        List<LocusScore> scores = null;
        if (this.dataSource != null) {
            String chr = context.getChr();
            int start = (int)context.getOrigin();
            int end = (int)context.getEndLocation();
            int zoom = context.getZoom();
            scores = this.dataSource.getSummaryScoresForRange(chr, start, end, zoom);
        }
        return scores;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        List<LocusScore> scores;
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (context.getScale() < (double)minVisibleScale && !context.getChr().equals("All")) {
            Interval interval = null;
            if (this.dataManager != null) {
                this.dataManager.load(context, this.renderOptions, true);
                interval = this.dataManager.getLoadedInterval(context.getReferenceFrame().getName());
            }
            if (interval != null && interval.contains(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation())) {
                if (this.autoScale) {
                    this.rescale();
                }
                this.intervalRenderer.paint(context, rect, ((AlignmentInterval)interval).getCounts());
                return;
            }
        }
        if ((scores = this.getSummaryScores(context)) != null) {
            this.dataSourceRenderer.renderScores(this, scores, context, rect);
        }
    }

    private void drawBorder(RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        if (!FrameManager.isExomeMode()) {
            this.drawScale(context, rect);
        }
    }

    public void drawScale(RenderContext context, Rectangle rect) {
        DataRenderer.drawScale(this.getDataRange(), context, rect);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (frame.getScale() < (double)minVisibleScale) {
            AlignmentCounts counts;
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame.getName());
            if (interval == null) {
                return null;
            }
            if (interval.contains(chr, (int)position, (int)position) && (counts = interval.getCounts()) != null) {
                return counts.getValueStringAt((int)position);
            }
        } else {
            return this.getPrecomputedValueString(chr, position, frame);
        }
        return null;
    }

    private String getPrecomputedValueString(String chr, double position, ReferenceFrame frame) {
        if (this.dataSource == null) {
            return "";
        }
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.dataSource.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        if (scores == null) {
            return "";
        }
        LocusScore score = FeatureUtils.getFeatureAt(position, 0, scores);
        return score == null ? "" : "Mean count: " + score.getScore();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    int drawBar(RenderContext context, int pos, Rectangle rect, double totalCount, double max, int pY, int pX, int dX, AlignmentCounts interval, boolean isLog) {
        for (char nucleotide : this.nucleotides) {
            int count = interval.getCount(pos, (byte)nucleotide);
            Color c = Globals.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            double tmp = isLog ? (double)count / totalCount * Math.log10(totalCount) / max : (double)count / max;
            int height = (int)(tmp * rect.getHeight());
            height = Math.min(pY - rect.y, height);
            int baseY = pY - height;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            pY = baseY;
        }
        return pX + dX;
    }

    int drawBarBisulfite(RenderContext context, int pos, Rectangle rect, double totalCount, double maxRange, int pY, int pX0, int dX, BisulfiteCounts.Count count, boolean isLog) {
        int pX = pX0;
        if (dX < 3) {
            int expansion = dX;
            pX -= expansion;
            dX += 2 * expansion;
        }
        double nMethylated = count.methylatedCount;
        double unMethylated = count.unmethylatedCount;
        Color c = Color.red;
        Graphics2D tGraphics = context.getGraphic2DForColor(c);
        double tmp = isLog ? nMethylated / totalCount * Math.log10(totalCount) / maxRange : nMethylated / maxRange;
        int height = (int)(tmp * rect.getHeight());
        height = Math.min(pY - rect.y, height);
        int baseY = pY - height;
        if (height > 0) {
            tGraphics.fillRect(pX, baseY, dX, height);
        }
        pY = baseY;
        c = Color.blue;
        tGraphics = context.getGraphic2DForColor(c);
        tmp = isLog ? unMethylated / totalCount * Math.log10(totalCount) / maxRange : unMethylated / maxRange;
        height = (int)(tmp * rect.getHeight());
        height = Math.min(pY - rect.y, height);
        baseY = pY - height;
        if (height > 0) {
            tGraphics.fillRect(pX, baseY, dX, height);
        }
        return pX + dX;
    }

    void drawStrandBar(RenderContext context, int pos, Rectangle rect, double maxCount, int pY, int pX, int dX, boolean isPositive, AlignmentCounts interval) {
        for (char nucleotide : this.nucleotides) {
            int baseY;
            Color c = Globals.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            int count = isPositive ? interval.getPosCount(pos, (byte)nucleotide) : interval.getNegCount(pos, (byte)nucleotide);
            int height = (int)Math.round((double)count * rect.getHeight() / maxCount);
            height = isPositive ? Math.min(pY - rect.y, height) : Math.min(rect.y + rect.height - pY, height);
            int n = baseY = isPositive ? pY - height : pY;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            pY = isPositive ? baseY : baseY + height;
        }
    }

    private Color getShadedColor(int qual, Color backgroundColor, Color color) {
        float alpha = 0.0f;
        int minQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        ColorUtilities.getRGBColorComponents(color);
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        if (alpha >= 1.0f) {
            return color;
        }
        return ColorUtilities.getCompositeColor(backgroundColor, color, alpha);
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmp));
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        this.addCopyDetailsItem(popupMenu, te);
        this.addAutoscaleItem(popupMenu);
        this.addLogScaleItem(popupMenu);
        this.dataRangeItem = CoverageTrack.addDataRangeItem(IGV.getMainFrame(), popupMenu, tmp);
        this.addSnpTresholdItem(popupMenu);
        popupMenu.addSeparator();
        this.addLoadCoverageDataItem(popupMenu);
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getRemoveMenuItem(tmp));
        return popupMenu;
    }

    private void addCopyDetailsItem(IGVPopupMenu popupMenu, TrackClickEvent te) {
        JMenuItem copyDetails = new JMenuItem("Copy Details to Clipboard");
        copyDetails.setEnabled(false);
        if (te.getFrame() != null) {
            final String details = this.getValueStringAt(te.getFrame().getChrName(), te.getChromosomePosition(), te.getMouseEvent().getY(), te.getFrame());
            copyDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (details != null) {
                        String deets = details.replace("<br>", System.getProperty("line.separator"));
                        StringUtils.copyTextToClipboard(deets);
                    }
                }
            });
            copyDetails.setEnabled(details != null);
        }
        popupMenu.add(copyDetails);
    }

    public static JMenuItem addDataRangeItem(final Frame parentFrame, JPopupMenu menu, final Collection<? extends Track> selectedTracks) {
        JMenuItem maxValItem = new JMenuItem("Set Data Range");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectedTracks.size() > 0) {
                    DataRange prevAxisDefinition = ((Track)selectedTracks.iterator().next()).getDataRange();
                    DataRangeDialog dlg = new DataRangeDialog(parentFrame, prevAxisDefinition);
                    dlg.setHideMid(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        float min = Math.min(dlg.getMin(), dlg.getMax());
                        float max = Math.max(dlg.getMin(), dlg.getMax());
                        float mid = dlg.getBase();
                        if (mid < min) {
                            mid = min;
                        } else if (mid > max) {
                            mid = max;
                        }
                        DataRange dataRange = new DataRange(min, mid, max);
                        dataRange.setType(dlg.getDataRangeType());
                        for (Track track : selectedTracks) {
                            track.setDataRange(dataRange);
                            track.setAutoScale(false);
                        }
                        parentFrame.repaint();
                    }
                }
            }
        });
        if (menu != null) {
            menu.add(maxValItem);
        }
        return maxValItem;
    }

    public JMenuItem addSnpTresholdItem(JPopupMenu menu) {
        JMenuItem maxValItem = new JMenuItem("Set allele frequency threshold...");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = JOptionPane.showInputDialog("Allele frequency threshold: ", (Object)Float.valueOf(CoverageTrack.this.snpThreshold));
                if (value == null) {
                    return;
                }
                try {
                    float tmp = Float.parseFloat(value);
                    CoverageTrack.this.snpThreshold = tmp;
                    IGV.getInstance().repaintDataPanels();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public void addLoadCoverageDataItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceManager prefs = PreferenceManager.getInstance();
                File initDirectory = prefs.getLastTrackDirectory();
                File file = FileDialogUtils.chooseFile("Select coverage file", initDirectory, 0);
                if (file != null) {
                    prefs.setLastTrackDirectory(file.getParentFile());
                    String path = file.getAbsolutePath();
                    if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                        TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                        TDFDataSource ds = new TDFDataSource(reader, 0, CoverageTrack.this.getName() + " coverage", CoverageTrack.this.genome);
                        CoverageTrack.this.setDataSource(ds);
                        IGV.getInstance().repaintDataPanels();
                    } else if (path.endsWith(".counts")) {
                        GobyCountArchiveDataSource ds = new GobyCountArchiveDataSource(file);
                        CoverageTrack.this.setDataSource(ds);
                        IGV.getInstance().repaintDataPanels();
                    } else {
                        MessageUtils.showMessage("Coverage data must be in .tdf format");
                    }
                }
            }
        });
        menu.add(item);
    }

    public void addAutoscaleItem(JPopupMenu menu) {
        this.autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        this.autoscaleItem.setSelected(this.autoScale);
        this.autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageTrack.this.autoScale = CoverageTrack.this.autoscaleItem.isSelected();
                CoverageTrack.this.dataRangeItem.setEnabled(!CoverageTrack.this.autoScale);
                if (CoverageTrack.this.autoScale) {
                    CoverageTrack.this.rescale();
                }
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(this.autoscaleItem);
    }

    public void addLogScaleItem(JPopupMenu menu) {
        final DataRange dataRange = this.getDataRange();
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = dataRange.getType() == DataRange.Type.LOG;
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                dataRange.setType(scaleType);
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(logScaleItem);
    }

    private static CoverageTrack getNextTrack() {
        return (CoverageTrack)IGVSessionReader.getNextTrack();
    }

    class IntervalRenderer {
        IntervalRenderer() {
        }

        private void paint(RenderContext context, Rectangle rect, AlignmentCounts alignmentCounts) {
            int pos;
            int pX;
            Color color = CoverageTrack.this.getColor();
            Graphics2D graphics = context.getGraphic2DForColor(color);
            DataRange range = CoverageTrack.this.getDataRange();
            double maxRange = range.isLog() ? Math.log10(range.getMaximum()) : (double)range.getMaximum();
            double rectX = rect.getX();
            double rectMaxX = rect.getMaxX();
            double rectY = rect.getY();
            double rectMaxY = rect.getMaxY();
            double rectHeight = rect.getHeight();
            double origin = context.getOrigin();
            double colorScaleMax = CoverageTrack.this.getColorScale().getMaximum();
            double scale = context.getScale();
            boolean bisulfiteMode = CoverageTrack.this.dataManager.getExperimentType() == AlignmentTrack.ExperimentType.BISULFITE;
            int lastpX = -1;
            int start = alignmentCounts.getStart();
            int nPoints = alignmentCounts.getNumberOfPoints();
            boolean isSparse = alignmentCounts instanceof SparseAlignmentCounts;
            for (int idx = 0; idx < nPoints && !((double)(pX = (int)(rectX + ((double)(pos = isSparse ? ((SparseAlignmentCounts)alignmentCounts).getPosition(idx) : start + idx) - origin) / scale)) > rectMaxX); ++idx) {
                int dX = (int)(rectX + ((double)(pos + 1) - origin) / scale) - pX;
                int n = dX = dX < 1 ? 1 : dX;
                if (pX + dX <= lastpX) continue;
                int pY = (int)rectMaxY - 1;
                int totalCount = alignmentCounts.getTotalCount(pos);
                double tmp = range.isLog() ? Math.log10(totalCount) / maxRange : (double)totalCount / maxRange;
                int height = (int)(tmp * rectHeight);
                height = Math.min(height, rect.height - 1);
                int topY = pY - height;
                if (dX > 3) {
                    --dX;
                }
                if (height > 0) {
                    graphics.fillRect(pX, topY, dX, height);
                }
                lastpX = pX + dX;
            }
            lastpX = -1;
            BisulfiteCounts bisulfiteCounts = alignmentCounts.getBisulfiteCounts();
            int intervalEnd = alignmentCounts.getEnd();
            int intervalStart = alignmentCounts.getStart();
            byte[] refBases = null;
            if (intervalEnd - intervalStart < 10000000) {
                refBases = CoverageTrack.this.genome.getSequence(context.getChr(), intervalStart, intervalEnd);
            }
            start = alignmentCounts.getStart();
            nPoints = alignmentCounts.getNumberOfPoints();
            isSparse = alignmentCounts instanceof SparseAlignmentCounts;
            for (int idx = 0; idx < nPoints; ++idx) {
                int refIdx;
                int pX2;
                int pos2 = isSparse ? ((SparseAlignmentCounts)alignmentCounts).getPosition(idx) : start + idx;
                BisulfiteCounts.Count bc = null;
                if (bisulfiteMode && bisulfiteCounts != null) {
                    bc = bisulfiteCounts.getCount(pos2);
                }
                if ((double)(pX2 = (int)(rectX + ((double)pos2 - origin) / scale)) > rectMaxX) break;
                int dX = (int)(rectX + ((double)(pos2 + 1) - origin) / scale) - pX2;
                int n = dX = dX < 1 ? 1 : dX;
                if (pX2 + dX <= lastpX) continue;
                boolean mismatch = false;
                if (refBases != null && (refIdx = pos2 - intervalStart) >= 0 && refIdx < refBases.length) {
                    if (bisulfiteMode) {
                        mismatch = bc != null && bc.methylatedCount + bc.unmethylatedCount > 0;
                    } else {
                        byte ref = refBases[refIdx];
                        mismatch = alignmentCounts.isMismatch(pos2, ref, context.getChr(), CoverageTrack.this.snpThreshold);
                    }
                }
                if (!mismatch) continue;
                int pY = (int)rectMaxY - 1;
                int totalCount = alignmentCounts.getTotalCount(pos2);
                double tmp = range.isLog() ? Math.log10(totalCount) / maxRange : (double)totalCount / maxRange;
                int height = (int)(tmp * rectHeight);
                height = Math.min(height, rect.height - 1);
                if (dX > 3) {
                    --dX;
                }
                if (height > 0) {
                    if (bisulfiteMode) {
                        if (bc != null) {
                            CoverageTrack.this.drawBarBisulfite(context, pos2, rect, totalCount, maxRange, pY, pX2, dX, bc, range.isLog());
                        }
                    } else {
                        CoverageTrack.this.drawBar(context, pos2, rect, totalCount, maxRange, pY, pX2, dX, alignmentCounts, range.isLog());
                    }
                }
                lastpX = pX2 + dX;
            }
        }
    }
}

