/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.peaks.Peak;
import org.broad.igv.peaks.PeakTimePlotFrame;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PeakTrackMenu
extends IGVPopupMenu {
    private static Logger log = Logger.getLogger(PeakTrackMenu.class);
    private PeakTrack track;
    private JRadioButtonMenuItem colorByScoreMI;
    private JRadioButtonMenuItem colorByFoldMI;

    public PeakTrackMenu(PeakTrack track, TrackClickEvent te) {
        this.track = track;
        this.init(te);
    }

    private void init(final TrackClickEvent trackClickEvent) {
        Collection<Track> tracks = IGV.getInstance().getSelectedTracks();
        JLabel popupTitle = new JLabel("<html><b>" + this.track.getName(), 2);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        this.addSeparator();
        this.add(TrackMenuUtils.getTrackRenameItem(tracks));
        this.add(TrackMenuUtils.getChangeTrackHeightItem(tracks));
        this.add(TrackMenuUtils.getChangeFontSizeItem(tracks));
        this.addDisplayModeItems();
        this.addSeparator();
        JMenuItem plotItem = new JMenuItem("Open Trend Plot...");
        plotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeakTrackMenu.this.openTimeSeriesPlot(trackClickEvent);
            }
        });
        this.add(plotItem);
        PeakTrackMenu peakTrackMenu = this;
        if (peakTrackMenu.track.isShowSignals()) {
            this.add(TrackMenuUtils.getDataRangeItem(tracks));
            this.add(TrackMenuUtils.getLogScaleItem(tracks));
            this.add(TrackMenuUtils.getShowDataRangeItem(tracks));
        }
        this.addSeparator();
        this.add(TrackMenuUtils.getRemoveMenuItem(tracks));
    }

    public void addDisplayModeItems() {
        this.addSeparator();
        ButtonGroup group = new ButtonGroup();
        Track.DisplayMode displayMode = this.track.getDisplayMode();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("Compressed");
        m1.setSelected(displayMode == Track.DisplayMode.COLLAPSED);
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeakTrackMenu.this.track.setDisplayMode(Track.DisplayMode.COLLAPSED);
                PeakTrack.setAnimate(false);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("Time Series");
        m3.setSelected(displayMode == Track.DisplayMode.EXPANDED);
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeakTrackMenu.this.track.setDisplayMode(Track.DisplayMode.EXPANDED);
                PeakTrack.setAnimate(false);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m4 = new JRadioButtonMenuItem("Animate");
        m4.setSelected(PeakTrack.animate);
        m4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeakTrackMenu.this.track.setDisplayMode(Track.DisplayMode.COLLAPSED);
                PeakTrack.setAnimate(true);
            }
        });
        this.add(m1);
        this.add(m3);
        this.add(m4);
        group.add(m1);
        group.add(m3);
        group.add(m4);
    }

    public void addColorByItems() {
        this.addSeparator();
        this.add(new JLabel("Color by"));
        ButtonGroup group = new ButtonGroup();
        this.colorByScoreMI = new JRadioButtonMenuItem("Score");
        this.colorByScoreMI.setSelected(PeakTrack.getColorOption() == PeakTrack.ColorOption.SCORE);
        this.colorByScoreMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeakTrack.setShadeOption(PeakTrack.ColorOption.SCORE);
                IGV.getInstance().repaint();
            }
        });
        this.colorByFoldMI = new JRadioButtonMenuItem("Fold change");
        this.colorByFoldMI.setSelected(PeakTrack.getColorOption() == PeakTrack.ColorOption.FOLD_CHANGE);
        this.colorByFoldMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeakTrack.setShadeOption(PeakTrack.ColorOption.FOLD_CHANGE);
                IGV.getInstance().repaint();
            }
        });
        this.add(this.colorByScoreMI);
        this.add(this.colorByFoldMI);
        group.add(this.colorByScoreMI);
        group.add(this.colorByFoldMI);
    }

    void openTimeSeriesPlot(TrackClickEvent trackClickEvent) {
        if (trackClickEvent == null) {
            return;
        }
        ReferenceFrame referenceFrame = trackClickEvent.getFrame();
        if (referenceFrame == null) {
            return;
        }
        String chr = referenceFrame.getChrName();
        double position = trackClickEvent.getChromosomePosition();
        XYSeriesCollection data = new XYSeriesCollection();
        ArrayList<Color> colors = new ArrayList<Color>();
        for (SoftReference<PeakTrack> ref : PeakTrack.instances) {
            Peak peak;
            PeakTrack track = ref.get();
            if (track == null || (peak = track.getFilteredPeakNearest(chr, position)) == null) continue;
            XYSeries series = new XYSeries((Comparable)((Object)track.getName()));
            float[] scores = peak.getTimeScores();
            if (scores.length == 4) {
                float t0 = scores[0] + 10.0f;
                series.add(0.0, (scores[0] + 10.0f) / t0);
                series.add(30.0, (scores[1] + 10.0f) / t0);
                series.add(60.0, (scores[2] + 10.0f) / t0);
                series.add(120.0, (scores[3] + 10.0f) / t0);
            }
            data.addSeries(series);
            Color c = track.getName().contains("Pol") ? Color.black : track.getColor();
            colors.add(c);
        }
        JFreeChart chart = ChartFactory.createXYLineChart("", "Time", "Score", data, PlotOrientation.VERTICAL, true, true, false);
        NumberAxis axis = (NumberAxis)chart.getXYPlot().getDomainAxis(0);
        axis.setTickUnit(new NumberTickUnit(30.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(400, 400));
        chartPanel.setSize(new Dimension(400, 400));
        XYItemRenderer renderer = chart.getXYPlot().getRenderer();
        for (int i = 0; i < colors.size(); ++i) {
            renderer.setSeriesPaint(i, (Paint)colors.get(i));
        }
        chartPanel.setBackground(Color.white);
        chart.getXYPlot().setBackgroundPaint(Color.white);
        chart.getXYPlot().setRangeGridlinePaint(Color.black);
        PeakTimePlotFrame frame = new PeakTimePlotFrame(chartPanel);
        frame.setVisible(true);
    }
}

