/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.SessionXmlAdapters;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ChromosomeColors;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.DoubleArrayList;
import org.broad.igv.util.collections.IntArrayList;

@XmlType(factoryMethod="getNextTrack")
public class GWASTrack
extends AbstractTrack {
    @XmlAttribute
    private int minPointSize;
    @XmlAttribute
    private int maxPointSize;
    @XmlAttribute
    private boolean useChrColors;
    @XmlAttribute
    private boolean singleColor;
    @XmlAttribute
    private boolean alternatingColors;
    @XmlJavaTypeAdapter(value=SessionXmlAdapters.Color.class)
    @XmlAttribute
    private Color primaryColor;
    @XmlJavaTypeAdapter(value=SessionXmlAdapters.Color.class)
    @XmlAttribute
    private Color secondaryColor;
    private GWASData gData;
    private static final Logger log = Logger.getLogger(GWASTrack.class);
    private static final int AXIS_AREA_WIDTH = 60;
    @XmlAttribute
    private double trackMinY;
    @XmlAttribute
    private double maxY;
    @XmlAttribute
    private double scale;
    private GWASParser parser;
    private static final DecimalFormat formatter = new DecimalFormat();
    @XmlAttribute
    private String displayName = null;
    @XmlAttribute
    private boolean drawYAxis = true;
    private boolean showAxis = true;

    String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public GWASTrack(ResourceLocator locator, String id, String name, GWASData gData, GWASParser parser) {
        super(locator, id, name);
        PreferenceManager prefs = PreferenceManager.getInstance();
        int maxValue = (int)Math.ceil(gData.getMaxValue());
        super.setDataRange(new DataRange(0.0f, maxValue / 2, maxValue));
        super.setHeight(prefs.getAsInt("GWAS_TRACK_HEIGHT"));
        this.minPointSize = prefs.getAsInt("GWAS_MIN_POINT_SIZE");
        this.maxPointSize = prefs.getAsInt("GWAS_MAX_POINT_SIZE");
        this.primaryColor = ColorUtilities.stringToColor(prefs.get("GWAS_PRIMARY_COLOR"));
        this.secondaryColor = ColorUtilities.stringToColor(prefs.get("GWAS_SECONDARY_COLOR"));
        this.singleColor = prefs.getAsBoolean("GWAS_SINGLE_COLOR");
        this.alternatingColors = prefs.getAsBoolean("GWAS_ALTERNATING_COLORS");
        this.useChrColors = prefs.getAsBoolean("GWAS_USE_CHR_COLORS");
        this.showAxis = prefs.getAsBoolean("GWAS_SHOW_AXIS");
        this.gData = gData;
        this.parser = parser;
    }

    @Override
    public void render(RenderContext context, Rectangle arect) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.trackMinY = arect.getMinY();
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        double adjustedRectMaxX = adjustedRect.getMaxX();
        double adjustedRectMaxY = adjustedRect.getMaxY();
        double adjustedRectY = adjustedRect.getY();
        this.maxY = adjustedRectMaxY;
        this.scale = context.getScale();
        int bufferX = (int)adjustedRectMaxX;
        int bufferY = (int)adjustedRectMaxY;
        Color[][] drawBuffer = new Color[bufferX + 1][bufferY + 1];
        double origin = context.getOrigin();
        double locScale = context.getScale();
        DataRange axisDefinition = this.getDataRange();
        float maxValue = axisDefinition.getMaximum();
        float minValue = axisDefinition.getMinimum();
        double yScaleFactor = adjustedRect.getHeight() / (double)(maxValue - minValue);
        String chrName = context.getChr();
        ArrayList<String> chrList = new ArrayList<String>();
        if (chrName.equals("All")) {
            for (String key : this.gData.getLocations().keySet()) {
                chrList.add(key);
            }
        } else {
            chrList.add(chrName);
        }
        double dx = Math.ceil(1.0 / locScale) + 1.0;
        double rangeMaxValue = Math.ceil(this.gData.getMaxValue());
        double pointSizeScale = rangeMaxValue / (double)this.maxPointSize;
        Color drawColor = this.primaryColor;
        Object[] chrs = this.gData.getLocations().keySet().toArray();
        int xMinPointSize = (int)(1.0 / locScale);
        block1: for (String chr : chrList) {
            if (!this.gData.getLocations().containsKey(chr) || !this.gData.getValues().containsKey(chr)) continue;
            if (this.useChrColors) {
                drawColor = ChromosomeColors.getColor(chr);
            } else if (this.alternatingColors) {
                int chrCounter;
                for (chrCounter = 0; chrCounter < chrs.length && !chrs[chrCounter].toString().equals(chr); ++chrCounter) {
                }
                drawColor = chrCounter % 2 == 0 ? this.secondaryColor : this.primaryColor;
            }
            IntArrayList locations = this.gData.getLocations().get(chr);
            DoubleArrayList values = this.gData.getValues().get(chr);
            int size = locations.size();
            for (int j = 0; j < size; ++j) {
                int start = chrName.equals("All") ? genome.getGenomeCoordinate(chr, locations.get(j)) : locations.get(j);
                double pX = ((double)start - origin) / locScale;
                if (pX + dx < 0.0) continue;
                if (pX > adjustedRectMaxX) continue block1;
                double dataY = values.get(j);
                if (Double.isNaN(dataY)) continue;
                int xPointSize = (int)Math.ceil(dataY / pointSizeScale);
                int yPointSize = xPointSize;
                if (yPointSize < this.minPointSize) {
                    yPointSize = this.minPointSize;
                }
                if (xMinPointSize < this.minPointSize) {
                    xMinPointSize = this.minPointSize;
                }
                if (xPointSize < xMinPointSize) {
                    xPointSize = xMinPointSize;
                }
                int x = (int)pX - xPointSize / 2;
                int y = (int)Math.min(adjustedRectMaxY, adjustedRectY + ((double)maxValue - dataY) * yScaleFactor) - yPointSize / 2;
                int maxDrawX = x + xPointSize;
                int maxDrawY = y + yPointSize;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                if ((double)maxDrawX > adjustedRectMaxX) {
                    maxDrawX = (int)adjustedRectMaxX;
                }
                if ((double)maxDrawY > adjustedRectMaxY) {
                    maxDrawY = (int)adjustedRectMaxY;
                }
                for (int drawX = x; drawX < maxDrawX; ++drawX) {
                    for (int drawY = y; drawY < maxDrawY; ++drawY) {
                        drawBuffer[drawX][drawY] = drawColor;
                    }
                }
            }
        }
        Graphics2D g = context.getGraphics();
        Color prevColor = null;
        for (int x = 0; x < bufferX; ++x) {
            for (int y = 0; y < bufferY; ++y) {
                Color color = drawBuffer[x][y];
                if (color == null) continue;
                if (!color.equals(prevColor)) {
                    g.setColor(color);
                    prevColor = color;
                }
                g.fillRect(x, y, 1, 1);
            }
        }
        if (this.showAxis) {
            this.renderAxis(context, arect);
        }
    }

    void renderAxis(RenderContext context, Rectangle arect) {
        Rectangle drawingRect = this.calculateDrawingRect(arect);
        Color labelColor = PreferenceManager.getInstance().getAsBoolean("CHART.COLOR_TRACK_NAME") ? this.getColor() : Color.black;
        Graphics2D labelGraphics = context.getGraphic2DForColor(labelColor);
        labelGraphics.setFont(FontManager.getFont(8));
        String tmpDisplayName = this.getDisplayName();
        if (tmpDisplayName != null && tmpDisplayName.length() > 0 && PreferenceManager.getInstance().getAsBoolean("CHART.DRAW_TRACK_NAME") && arect.getHeight() > 25.0) {
            Rectangle labelRect = new Rectangle(arect.x, arect.y + 10, arect.width, 10);
            labelGraphics.setFont(FontManager.getFont(10));
            GraphicUtils.drawCenteredText(tmpDisplayName, labelRect, labelGraphics);
        }
        if (this.drawYAxis) {
            labelGraphics = context.getGraphic2DForColor(Color.black);
            labelGraphics.setFont(FontManager.getFont(11));
            Rectangle axisRect = new Rectangle(arect.x, arect.y + 1, 60, arect.height);
            DataRange axisDefinition = this.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float minValue = axisDefinition.getMinimum();
            int pY = this.computeYPixelValue(drawingRect, axisDefinition, minValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, pY, axisRect.x + 60 - 5, pY);
            GraphicUtils.drawRightJustifiedText(formatter.format(minValue), axisRect.x + 60 - 15, pY, labelGraphics);
            int topPY = this.computeYPixelValue(drawingRect, axisDefinition, maxValue);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 5, topPY);
            GraphicUtils.drawRightJustifiedText(formatter.format(maxValue), axisRect.x + 60 - 15, topPY + 4, labelGraphics);
            labelGraphics.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 10, pY);
            int lastY = pY;
            for (int i = (int)minValue + 1; i < (int)maxValue; ++i) {
                int midPY = this.computeYPixelValue(drawingRect, axisDefinition, i);
                if (midPY >= lastY - 15 || midPY >= pY - 15 || midPY <= topPY + 15) continue;
                labelGraphics.drawLine(axisRect.x + 60 - 10, midPY, axisRect.x + 60 - 5, midPY);
                GraphicUtils.drawRightJustifiedText(formatter.format(i), axisRect.x + 60 - 15, midPY + 4, labelGraphics);
                lastY = midPY;
            }
        }
    }

    int computeYPixelValue(Rectangle drawingRect, DataRange axisDefinition, double dataY) {
        double maxValue = axisDefinition.getMaximum();
        double minValue = axisDefinition.getMinimum();
        double yScaleFactor = drawingRect.getHeight() / (maxValue - minValue);
        double delta = (maxValue - dataY) * yScaleFactor;
        double pY = drawingRect.getY() + delta;
        return (int)Math.max(drawingRect.getMinY(), Math.min(drawingRect.getMaxY(), pY));
    }

    Rectangle calculateDrawingRect(Rectangle arect) {
        double buffer = Math.min(arect.getHeight() * 0.2, 10.0);
        Rectangle adjustedRect = new Rectangle(arect);
        adjustedRect.y = (int)(arect.getY() + buffer);
        adjustedRect.height = (int)((double)arect.height - ((double)adjustedRect.y - arect.getY()));
        return adjustedRect;
    }

    int findIndex(String chr, int y, int location, int maxDistance) {
        double tmpMaxY = this.maxY - this.trackMinY;
        double valueEstimate = (1.0 - (double)(y -= (int)this.trackMinY) / tmpMaxY) * (double)this.getDataRange().getMaximum();
        double threshold = 0.1;
        double topValue = valueEstimate + threshold * (double)this.getDataRange().getMaximum();
        double bottomValue = valueEstimate - threshold * (double)this.getDataRange().getMaximum();
        if (bottomValue < 0.0) {
            bottomValue = 0.0;
        }
        return this.gData.getNearestIndexByLocation(chr, location, bottomValue, topValue, maxDistance);
    }

    String getDescription(String chr, int index) {
        String textValue = "";
        double value = this.gData.getValues().get(chr).get(index);
        int hitLocation = this.gData.getLocations().get(chr).get(index);
        int rowIndex = this.gData.getCumulativeChrLocation(chr) + index;
        textValue = textValue + chr + ": " + hitLocation + "<br>";
        textValue = textValue + "Value: " + value + "<br>";
        textValue = textValue + "-----<br>";
        try {
            String tmpDescription = this.gData.getDescriptionCache().getDescriptionString(chr, hitLocation, value);
            if (tmpDescription == null) {
                int tmpRow = rowIndex - this.gData.getDescriptionCache().getMaxSize() / 2;
                if (tmpRow < 0) {
                    tmpRow = 0;
                }
                this.gData = this.parser.parseDescriptions(this.gData, chr, hitLocation, tmpRow);
                tmpDescription = this.gData.getDescriptionCache().getDescriptionString(chr, hitLocation, value);
            }
            textValue = textValue + tmpDescription;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return textValue;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        int index;
        int location = (int)position;
        int maxDistance = (int)this.scale * 2;
        if (chr.equals("All")) {
            ChromosomeCoordinate chrCoordinate = GenomeManager.getInstance().getCurrentGenome().getChromosomeCoordinate(location);
            chr = chrCoordinate.getChr();
            location = chrCoordinate.getCoordinate();
            maxDistance *= 1000;
        }
        return (index = this.findIndex(chr, y, location, maxDistance)) >= 0 ? this.getDescription(chr, index) : null;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        popupMenu.add(popupTitle);
        ArrayList<Track> tmpTracks = new ArrayList<Track>();
        tmpTracks.add(this);
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmpTracks));
        popupMenu.add(TrackMenuUtils.getRemoveMenuItem(tmpTracks));
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getDataRangeItem(tmpTracks));
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmpTracks));
        popupMenu.addSeparator();
        popupMenu.add(new JLabel("Color scheme", 2));
        popupMenu.add(this.addChrColorItem(popupMenu));
        popupMenu.add(this.addSingleColorItem(popupMenu));
        popupMenu.add(this.addAlternatingColorItem(popupMenu));
        popupMenu.addSeparator();
        popupMenu.add(this.addPrimaryColorItem(popupMenu));
        popupMenu.add(this.addSecondaryColorItem(popupMenu));
        popupMenu.addSeparator();
        popupMenu.add(this.addMinPointSizeItem(popupMenu));
        popupMenu.add(this.addMaxPointSizeItem(popupMenu));
        popupMenu.addSeparator();
        this.addShowAxisItem(popupMenu);
        return popupMenu;
    }

    public JMenuItem addShowAxisItem(JPopupMenu menu) {
        final JCheckBoxMenuItem axisItem = new JCheckBoxMenuItem("Show axis");
        axisItem.setSelected(this.showAxis);
        axisItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.showAxis = axisItem.isSelected();
                PreferenceManager.getInstance().put("GWAS_SHOW_AXIS", String.valueOf(GWASTrack.this.showAxis));
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(axisItem);
        return axisItem;
    }

    public JMenuItem addChrColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Chromosome color", this.useChrColors);
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.singleColor = false;
                GWASTrack.this.useChrColors = true;
                GWASTrack.this.alternatingColors = false;
                GWASTrack.this.updateColorPreferences();
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addAlternatingColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Alternating color", this.alternatingColors);
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.singleColor = false;
                GWASTrack.this.useChrColors = false;
                GWASTrack.this.alternatingColors = true;
                GWASTrack.this.updateColorPreferences();
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addSingleColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Single color", this.singleColor);
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.singleColor = true;
                GWASTrack.this.useChrColors = false;
                GWASTrack.this.alternatingColors = false;
                GWASTrack.this.updateColorPreferences();
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    private void updateColorPreferences() {
        PreferenceManager.getInstance().put("GWAS_SINGLE_COLOR", String.valueOf(this.singleColor));
        PreferenceManager.getInstance().put("GWAS_USE_CHR_COLORS", String.valueOf(this.useChrColors));
        PreferenceManager.getInstance().put("GWAS_ALTERNATING_COLORS", String.valueOf(this.alternatingColors));
    }

    public JMenuItem addPrimaryColorItem(JPopupMenu menu) {
        JMenuItem colorItem = new JMenuItem("Set primary color...");
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = UIUtilities.showColorChooserDialog("Set primary color", GWASTrack.this.primaryColor);
                if (color != null) {
                    GWASTrack.this.primaryColor = color;
                    String colorString = ColorUtilities.colorToString(GWASTrack.this.primaryColor);
                    PreferenceManager.getInstance().put("GWAS_PRIMARY_COLOR", colorString);
                    IGV.getInstance().repaintDataPanels();
                }
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addSecondaryColorItem(JPopupMenu menu) {
        JMenuItem colorItem = new JMenuItem("Set alternating color...");
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = UIUtilities.showColorChooserDialog("Set alternating color", GWASTrack.this.secondaryColor);
                if (color != null) {
                    GWASTrack.this.secondaryColor = color;
                    String colorString = ColorUtilities.colorToString(GWASTrack.this.secondaryColor);
                    PreferenceManager.getInstance().put("GWAS_SECONDARY_COLOR", colorString);
                    IGV.getInstance().repaintDataPanels();
                }
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addMinPointSizeItem(JPopupMenu menu) {
        JMenuItem menuItem = new JMenuItem("Set minimum point size...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.changeMinPointSizeValue();
            }
        });
        menu.add(menuItem);
        return menuItem;
    }

    public JMenuItem addMaxPointSizeItem(JPopupMenu menu) {
        JMenuItem menuItem = new JMenuItem("Set maximum point size...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.changeMaxPointSizeValue();
            }
        });
        menu.add(menuItem);
        return menuItem;
    }

    private void changeMinPointSizeValue() {
        int value = this.minPointSize;
        String tmpValue = JOptionPane.showInputDialog(IGV.getMainFrame(), "Minimum point size in pixels (1-20):", String.valueOf(value));
        if (tmpValue != null || !tmpValue.trim().equals("")) {
            try {
                value = Integer.parseInt(tmpValue);
                if (value < 1 || value > 20) {
                    JOptionPane.showMessageDialog(IGV.getMainFrame(), "Minimum point size must be an integer number between 1 and 20.");
                } else {
                    if (value > this.maxPointSize) {
                        this.maxPointSize = value;
                    }
                    this.minPointSize = value;
                    this.updatePointSizePreferences();
                    IGV.getInstance().repaintDataPanels();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "Point size must be an integer number.");
            }
        }
    }

    private void changeMaxPointSizeValue() {
        int value = this.maxPointSize;
        String tmpValue = JOptionPane.showInputDialog(IGV.getMainFrame(), "Maximum point size in pixels (1-20):", String.valueOf(value));
        if (tmpValue != null || !tmpValue.trim().equals("")) {
            try {
                value = Integer.parseInt(tmpValue);
                if (value < 1 || value > 20) {
                    JOptionPane.showMessageDialog(IGV.getMainFrame(), "Maximum point size must be an integer number between 1 and 20.");
                } else {
                    if (value < this.minPointSize) {
                        this.minPointSize = value;
                    }
                    this.maxPointSize = value;
                    this.updatePointSizePreferences();
                    IGV.getInstance().repaintDataPanels();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "Point size must be an integer number.");
            }
        }
    }

    private void updatePointSizePreferences() {
        PreferenceManager.getInstance().put("GWAS_MIN_POINT_SIZE", String.valueOf(this.minPointSize));
        PreferenceManager.getInstance().put("GWAS_MAX_POINT_SIZE", String.valueOf(this.maxPointSize));
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    private static GWASTrack getNextTrack() {
        return (GWASTrack)IGVSessionReader.getNextTrack();
    }
}

