/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble.reader;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.broad.igv.feature.tribble.TribbleIndexNotFoundException;
import org.broad.igv.feature.tribble.reader.TabixFeatureReader;
import org.broad.igv.feature.tribble.reader.TribbleFeatureReader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TribbleException;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(ResourceLocator locator, FeatureCodec<FEATURE, SOURCE> codec) throws TribbleException, TribbleIndexNotFoundException {
        try {
            if (AbstractFeatureReader.isTabix(locator)) {
                if (!(codec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + codec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(locator, (AsciiFeatureCodec)codec);
            }
            return new TribbleFeatureReader<FEATURE, SOURCE>(locator, codec);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", locator.getPath(), e);
        }
        catch (TribbleException e) {
            e.setSource(locator.getPath());
            throw e;
        }
    }

    private static boolean isTabix(ResourceLocator locator) throws IOException {
        boolean isTabix;
        String tabxIndex = locator.getIndexPath();
        if (tabxIndex == null) {
            if (HttpUtils.isRemoteURL(locator.getPath())) {
                URL url = new URL(locator.getPath());
                String path = url.getPath();
                String indexPath = path + ".tbi";
                tabxIndex = locator.getPath().replace(path, indexPath);
            } else {
                tabxIndex = locator.getPath() + ".tbi";
            }
        }
        boolean bl = isTabix = locator.getPath().endsWith(".gz") && FileUtils.resourceExists(tabxIndex);
        if (isTabix) {
            locator.setIndexPath(tabxIndex);
        }
        return isTabix;
    }

    protected AbstractFeatureReader(String path, FeatureCodec<T, SOURCE> codec) {
        this.path = path;
        this.codec = codec;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    public abstract boolean hasIndex();

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

