/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.MergingIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextComparator;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFUtils;

public class MergeVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Merges multiple VCF or BCF files into one VCF file. Input files must be sorted by their contigs " + "and, within contigs, by start position. The input files must have the same sample and " + "contig lists. An index file is created and a sequence dictionary is required by default.";
    @Option(shortName="I", doc="VCF or BCF input files File format is determined by file extension.", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF or BCF file. File format is determined by file extension.")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionary in the input file", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] argv) {
        new MergeVcfs().instanceMainWithExit(argv);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        ArrayList<String> sampleList = new ArrayList<String>();
        ArrayList iteratorCollection = new ArrayList(this.INPUT.size());
        HashSet<VCFHeader> headers = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        SAMSequenceDictionary sequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sequenceDictionary = SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY);
        }
        for (File file : this.INPUT) {
            IoUtil.assertFileIsReadable(file);
            VCFFileReader fileReader = new VCFFileReader(file);
            VCFHeader fileHeader = fileReader.getFileHeader();
            if (variantContextComparator == null) {
                variantContextComparator = fileHeader.getVCFRecordComparator();
            } else if (!variantContextComparator.isCompatible(fileHeader.getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sequenceDictionary == null) {
                sequenceDictionary = fileHeader.getSequenceDictionary();
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(fileHeader.getSampleNamesInOrder());
            } else if (!((Object)sampleList).equals(fileHeader.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            headers.add(fileHeader);
            iteratorCollection.add(fileReader.iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        EnumSet<Options> options = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter writer = VariantContextWriterFactory.create(this.OUTPUT, sequenceDictionary, options);
        writer.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(headers, false), sampleList));
        MergingIterator<VariantContext> mergingIterator = new MergingIterator<VariantContext>(variantContextComparator, iteratorCollection);
        while (mergingIterator.hasNext()) {
            VariantContext context = mergingIterator.next();
            writer.add(context);
            progress.record(context.getChr(), context.getStart());
        }
        CloserUtil.close(mergingIterator);
        writer.close();
        return 0;
    }
}

