/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;

public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="SD", doc="Sequence dictionary to use when indexing the VCF.", optional=true)
    public File SEQUENCE_DICTIONARY;
    private static final Set<String> NO_SAMPLES = Collections.emptySet();

    public static void main(String[] args) {
        new MakeSitesOnlyVcf().instanceMainWithExit(args);
    }

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sequenceDictionary;
        IoUtil.assertFileIsReadable(this.INPUT);
        if (this.SEQUENCE_DICTIONARY != null) {
            IoUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY);
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT);
        VCFHeader header = new VCFHeader(reader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sAMSequenceDictionary = sequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : header.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        EnumSet<Options> options = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter writer = VariantContextWriterFactory.create(this.OUTPUT, sequenceDictionary, options);
        writer.writeHeader(header);
        ProgressLogger progress = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        Iterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            VariantContext context = (VariantContext)iterator.next();
            writer.add(context.subContextFromSamples(NO_SAMPLES, false));
            progress.record(context.getChr(), context.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }
}

