/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.CloseableIterator;

public class DelimitedTextFileWithHeaderIterator
implements CloseableIterator<Row> {
    private final Map<String, Integer> columnLabelIndices = new HashMap<String, Integer>();
    private final BasicInputParser parser;

    public DelimitedTextFileWithHeaderIterator(BasicInputParser parser) {
        this.parser = parser;
        if (!parser.hasNext()) {
            throw new PicardException("No header line found in file " + parser.getFileName());
        }
        String[] columnLabels = (String[])parser.next();
        for (int i = 0; i < columnLabels.length; ++i) {
            this.columnLabelIndices.put(columnLabels[i], i);
        }
    }

    public boolean hasColumn(String columnLabel) {
        return this.columnLabelIndices.containsKey(columnLabel);
    }

    public Set<String> columnLabels() {
        return this.columnLabelIndices.keySet();
    }

    public int getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnLabelIndices.keySet());
    }

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    @Override
    public Row next() {
        String[] fields = (String[])this.parser.next();
        String source = this.parser.getCurrentLine();
        return new Row(fields, source);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public class Row {
        private final String[] fields;
        private final String currentLine;

        Row(String[] fields, String source) {
            this.fields = fields;
            this.currentLine = source;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String getField(String columnLabel) {
            Integer key = (Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(columnLabel);
            if (key == null) {
                throw new NoSuchElementException(String.format("column %s in %s", columnLabel, DelimitedTextFileWithHeaderIterator.this.parser.getFileName()));
            }
            return this.fields[key];
        }

        public Integer getIntegerField(String columnLabel) {
            if (this.fields[(Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(columnLabel)] == null) {
                return null;
            }
            return Integer.parseInt(this.fields[(Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(columnLabel)]);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }
    }
}

