/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import java.util.List;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotationType;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.classloader.PluginManager;

public class HelpUtils {
    public static void listAnnotations() {
        System.out.println("\nThis is a list of available Variant Annotations for use with tools such as UnifiedGenotyper, HaplotypeCaller and VariantAnnotator. Please see the Technical Documentation for more details about these annotations:");
        System.out.println("http://www.broadinstitute.org/gatk/gatkdocs/");
        System.out.println("\nStandard annotations in the list below are marked with a '*'.");
        List infoAnnotationClasses = new PluginManager(InfoFieldAnnotation.class).getPlugins();
        System.out.println("\nAvailable annotations for the VCF INFO field:");
        for (int i = 0; i < infoAnnotationClasses.size(); ++i) {
            System.out.println("\t" + (StandardAnnotation.class.isAssignableFrom(infoAnnotationClasses.get(i)) ? "*" : "") + infoAnnotationClasses.get(i).getSimpleName());
        }
        System.out.println();
        List genotypeAnnotationClasses = new PluginManager(GenotypeAnnotation.class).getPlugins();
        System.out.println("\nAvailable annotations for the VCF FORMAT field:");
        for (int i = 0; i < genotypeAnnotationClasses.size(); ++i) {
            System.out.println("\t" + (StandardAnnotation.class.isAssignableFrom(genotypeAnnotationClasses.get(i)) ? "*" : "") + genotypeAnnotationClasses.get(i).getSimpleName());
        }
        System.out.println();
        System.out.println("\nAvailable classes/groups of annotations:");
        for (Class c : new PluginManager(AnnotationType.class).getInterfaces()) {
            System.out.println("\t" + c.getSimpleName());
        }
        System.out.println();
    }
}

