/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.model.ContractKind;
import java.util.List;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"getKind() != null", "ClassName.isBinaryName(getClassName())", "getKey() >= -1", "getLineNumbers() == null || ContractMethodSignatures.isLineNumberList(getLineNumbers())"})
public class ContractHandle {
    protected ContractKind kind;
    protected String className;
    protected int key;
    protected MethodNode contractMethod;
    protected List<Long> lineNumbers;
    protected boolean injected;

    @Requires(value={"kind != null", "ClassName.isBinaryName(className)", "contractMethod != null", "lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers)"})
    @Ensures(value={"kind == getKind()", "className.equals(getClassName())", "contractMethod == getContractMethod()", "lineNumbers == getLineNumbers()", "!isInjected()"})
    protected ContractHandle(ContractKind contractKind, String string, MethodNode methodNode, List<Long> list) {
        this.kind = contractKind;
        this.className = string;
        this.key = ContractMethodSignatures.getId(methodNode);
        this.contractMethod = methodNode;
        if (!methodNode.name.startsWith("com$google$java$contract$")) {
            methodNode.name = "com$google$java$contract$S" + methodNode.name;
        }
        this.lineNumbers = list;
        this.injected = false;
    }

    public ContractKind getKind() {
        return this.kind;
    }

    public String getClassName() {
        return this.className;
    }

    public int getKey() {
        return this.key;
    }

    public MethodNode getContractMethod() {
        return this.contractMethod;
    }

    public List<Long> getLineNumbers() {
        return this.lineNumbers;
    }

    public boolean isInjected() {
        return this.injected;
    }

    @Ensures(value={"injected == isInjected()"})
    public void setInjected(boolean bl) {
        this.injected = bl;
    }
}

