/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.nanoScheduler.EOFMarkedValue;

class InputProducer<InputType> {
    private static final Logger logger = Logger.getLogger(InputProducer.class);
    final Iterator<InputType> inputReader;
    boolean readLastValue = false;
    private InputValue lastValue = null;
    int nRead = 0;
    int inputID = -1;

    public InputProducer(Iterator<InputType> inputReader) {
        if (inputReader == null) {
            throw new IllegalArgumentException("inputReader cannot be null");
        }
        this.inputReader = inputReader;
    }

    public synchronized int getNumInputValues() {
        return this.allInputsHaveBeenRead() ? this.nRead : -1;
    }

    public synchronized boolean allInputsHaveBeenRead() {
        return this.readLastValue;
    }

    private synchronized InputType readNextItem() {
        if (!this.inputReader.hasNext()) {
            this.readLastValue = true;
            return null;
        }
        InputType input = this.inputReader.next();
        if (input == null) {
            throw new IllegalStateException("inputReader.next() returned a null value, breaking our contract");
        }
        ++this.nRead;
        return input;
    }

    public synchronized boolean hasNext() {
        return !this.allInputsHaveBeenRead();
    }

    public synchronized InputValue next() {
        if (this.readLastValue) {
            this.lastValue = this.lastValue.nextEOF();
            return this.lastValue;
        }
        InputType value = this.readNextItem();
        if (value == null) {
            if (!this.readLastValue) {
                throw new IllegalStateException("value == null but readLastValue is false!");
            }
            this.lastValue = new InputValue(this.inputID + 1);
            return this.lastValue;
        }
        return new InputValue(++this.inputID, value);
    }

    class InputValue
    extends EOFMarkedValue<InputType> {
        final int id;

        private InputValue(int id, InputType datum) {
            super(datum);
            if (id < 0) {
                throw new IllegalArgumentException("id must be >= 0");
            }
            this.id = id;
        }

        private InputValue(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("id must be >= 0");
            }
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public InputValue nextEOF() {
            if (!this.isEOFMarker()) {
                throw new IllegalArgumentException("Cannot request next EOF marker for non-EOF marker InputValue");
            }
            return new InputValue(this.getId() + 1);
        }
    }
}

