/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.runtime.BlacklistManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

@Invariant(value={"this.contractedElements != null"})
public class ContractFinder
extends ElementScanner6<Boolean, Void> {
    private FactoryUtils utils;
    private Map<TypeElement, Boolean> contractedElements;
    private BlacklistManager blackList;

    @Requires(value={"utils != null"})
    public ContractFinder(FactoryUtils factoryUtils) {
        this.utils = factoryUtils;
        this.contractedElements = new HashMap<TypeElement, Boolean>();
        this.blackList = BlacklistManager.getInstance();
    }

    @Override
    @Ensures(value={"result != null"})
    public Boolean visitType(TypeElement typeElement, Void void_) {
        if (this.contractedElements.containsKey(typeElement)) {
            return this.contractedElements.get(typeElement);
        }
        if (this.blackList.isIgnored(typeElement.getQualifiedName().toString())) {
            this.contractedElements.put(typeElement, Boolean.FALSE);
            return Boolean.FALSE;
        }
        this.contractedElements.put(typeElement, Boolean.FALSE);
        Boolean bl = this.isContractedType(typeElement);
        this.contractedElements.put(typeElement, bl);
        return bl;
    }

    @Override
    @Ensures(value={"result != null"})
    public Boolean visitExecutable(ExecutableElement executableElement, Void void_) {
        return this.hasContracts(executableElement.getAnnotationMirrors());
    }

    @Override
    @Ensures(value={"result != null"})
    public Boolean visitVariable(VariableElement variableElement, Void void_) {
        return Boolean.FALSE;
    }

    @Override
    @Ensures(value={"result != null"})
    public Boolean visitPackage(PackageElement packageElement, Void void_) {
        return Boolean.FALSE;
    }

    @Override
    @Ensures(value={"result != null"})
    public Boolean visitTypeParameter(TypeParameterElement typeParameterElement, Void void_) {
        return Boolean.FALSE;
    }

    @Requires(value={"e != null"})
    @Ensures(value={"result != null"})
    private Boolean isContractedType(TypeElement typeElement) {
        Boolean bl;
        block4: {
            AnnotatedConstruct annotatedConstruct;
            Iterator<Object> iterator;
            List<? extends Element> list;
            bl = Boolean.FALSE;
            bl = this.hasContracts(typeElement.getAnnotationMirrors());
            if (!bl.booleanValue() && (list = this.utils.typeUtils.asElement(typeElement.getSuperclass())) != null) {
                bl = list.accept(this, null);
            }
            if (!bl.booleanValue()) {
                Element element;
                list = typeElement.getInterfaces();
                iterator = list.iterator();
                while (iterator.hasNext() && !(bl = (element = this.utils.typeUtils.asElement((TypeMirror)(annotatedConstruct = (TypeMirror)iterator.next()))).accept(this, null)).booleanValue()) {
                }
            }
            if (bl.booleanValue()) break block4;
            list = typeElement.getEnclosedElements();
            iterator = list.iterator();
            while (iterator.hasNext() && !(bl = (annotatedConstruct = (Element)iterator.next()).accept(this, null)).booleanValue()) {
            }
        }
        return bl;
    }

    @Requires(value={"annotations != null"})
    @Ensures(value={"result != null"})
    private Boolean hasContracts(Collection<? extends AnnotationMirror> collection) {
        for (AnnotationMirror annotationMirror : collection) {
            if (!this.utils.isContractAnnotation(annotationMirror)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

