/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.haplotypeBAMWriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.graphs.Path;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.haplotype.Haplotype;
import org.broadinstitute.sting.utils.haplotypeBAMWriter.AllHaplotypeBAMWriter;
import org.broadinstitute.sting.utils.haplotypeBAMWriter.CalledHaplotypeBAMWriter;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.smithwaterman.SWPairwiseAlignment;

public abstract class HaplotypeBAMWriter {
    private long uniqueNameCounter = 1L;
    protected static final String READ_GROUP_ID = "ArtificialHaplotype";
    protected static final String HAPLOTYPE_TAG = "HC";
    final SAMFileWriter bamWriter;
    final SAMFileHeader bamHeader;

    public static HaplotypeBAMWriter create(Type type, StingSAMFileWriter stingSAMWriter, SAMFileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (stingSAMWriter == null) {
            throw new IllegalArgumentException("writer cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        SAMFileHeader bamHeader = new SAMFileHeader();
        bamHeader.setSequenceDictionary(header.getSequenceDictionary());
        bamHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>(header.getReadGroups());
        SAMReadGroupRecord rg = new SAMReadGroupRecord(READ_GROUP_ID);
        rg.setSample(HAPLOTYPE_TAG);
        rg.setSequencingCenter("BI");
        readGroups.add(rg);
        bamHeader.setReadGroups(readGroups);
        stingSAMWriter.setPresorted(false);
        stingSAMWriter.writeHeader(bamHeader);
        return HaplotypeBAMWriter.create(type, (SAMFileWriter)stingSAMWriter);
    }

    public static HaplotypeBAMWriter create(Type type, SAMFileWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        switch (type) {
            case ALL_POSSIBLE_HAPLOTYPES: {
                return new AllHaplotypeBAMWriter(writer);
            }
            case CALLED_HAPLOTYPES: {
                return new CalledHaplotypeBAMWriter(writer);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    protected HaplotypeBAMWriter(SAMFileWriter bamWriter) {
        this.bamWriter = bamWriter;
        this.bamHeader = bamWriter.getFileHeader();
    }

    public abstract void writeReadsAlignedToHaplotypes(List<Haplotype> var1, GenomeLoc var2, List<Haplotype> var3, Set<Haplotype> var4, Map<String, PerReadAlleleLikelihoodMap> var5);

    protected void writeReadAgainstHaplotype(GATKSAMRecord originalRead, Haplotype haplotype, int referenceStart, boolean isInformative) {
        GATKSAMRecord alignedToRef = this.createReadAlignedToRef(originalRead, haplotype, referenceStart, isInformative);
        if (alignedToRef != null) {
            this.bamWriter.addAlignment((SAMRecord)alignedToRef);
        }
    }

    protected GATKSAMRecord createReadAlignedToRef(GATKSAMRecord originalRead, Haplotype haplotype, int referenceStart, boolean isInformative) {
        if (originalRead == null) {
            throw new IllegalArgumentException("originalRead cannot be null");
        }
        if (haplotype == null) {
            throw new IllegalArgumentException("haplotype cannot be null");
        }
        if (haplotype.getCigar() == null) {
            throw new IllegalArgumentException("Haplotype cigar not set " + (Object)((Object)haplotype));
        }
        if (referenceStart < 1) {
            throw new IllegalArgumentException("reference start much be >= 1 but got " + referenceStart);
        }
        try {
            SWPairwiseAlignment swPairwiseAlignment = new SWPairwiseAlignment(haplotype.getBases(), originalRead.getReadBases(), Path.NEW_SW_PARAMETERS);
            if (swPairwiseAlignment.getAlignmentStart2wrt1() == -1) {
                return null;
            }
            Cigar swCigar = AlignmentUtils.consolidateCigar(swPairwiseAlignment.getCigar());
            GATKSAMRecord read = (GATKSAMRecord)((Object)originalRead.clone());
            this.addHaplotypeTag(read, haplotype);
            if (!isInformative) {
                read.setMappingQuality(0);
            }
            Cigar extendedHaplotypeCigar = haplotype.getConsolidatedPaddedCigar(1000);
            int readStartOnHaplotype = AlignmentUtils.calcFirstBaseMatchingReferenceInCigar(extendedHaplotypeCigar, swPairwiseAlignment.getAlignmentStart2wrt1());
            int readStartOnReference = referenceStart + haplotype.getAlignmentStartHapwrtRef() + readStartOnHaplotype;
            read.setAlignmentStart(readStartOnReference);
            Cigar haplotypeToRef = AlignmentUtils.trimCigarByBases(extendedHaplotypeCigar, swPairwiseAlignment.getAlignmentStart2wrt1(), extendedHaplotypeCigar.getReadLength() - 1);
            Cigar readToRefCigarRaw = AlignmentUtils.applyCigarToCigar(swCigar, haplotypeToRef);
            Cigar readToRefCigarClean = AlignmentUtils.cleanUpCigar(readToRefCigarRaw);
            Cigar readToRefCigar = AlignmentUtils.leftAlignIndel(readToRefCigarClean, haplotype.getBases(), originalRead.getReadBases(), swPairwiseAlignment.getAlignmentStart2wrt1(), 0, true);
            read.setCigar(readToRefCigar);
            if (readToRefCigar.getReadLength() != read.getReadLength()) {
                throw new IllegalStateException("Cigar " + readToRefCigar + " with read length " + readToRefCigar.getReadLength() + " != read length " + read.getReadLength() + " for read " + read.format() + "\nhapToRef " + haplotypeToRef + " length " + haplotypeToRef.getReadLength() + "/" + haplotypeToRef.getReferenceLength() + "\nreadToHap " + swCigar + " length " + swCigar.getReadLength() + "/" + swCigar.getReferenceLength());
            }
            return read;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("GATKSAMRecords should support clone but this one does not " + (Object)((Object)originalRead));
        }
    }

    private void addHaplotypeTag(GATKSAMRecord read, Haplotype haplotype) {
        read.setAttribute(HAPLOTYPE_TAG, haplotype.hashCode());
    }

    protected void writeHaplotypesAsReads(Collection<Haplotype> haplotypes, Set<Haplotype> bestHaplotypes, GenomeLoc paddedReferenceLoc) {
        for (Haplotype haplotype : haplotypes) {
            this.writeHaplotype(haplotype, paddedReferenceLoc, bestHaplotypes.contains((Object)haplotype));
        }
    }

    private void writeHaplotype(Haplotype haplotype, GenomeLoc paddedRefLoc, boolean isAmongBestHaplotypes) {
        GATKSAMRecord record = new GATKSAMRecord(this.bamHeader);
        record.setReadBases(haplotype.getBases());
        record.setAlignmentStart(paddedRefLoc.getStart() + haplotype.getAlignmentStartHapwrtRef());
        record.setBaseQualities(Utils.dupBytes((byte)33, haplotype.getBases().length));
        record.setCigar(AlignmentUtils.consolidateCigar(haplotype.getCigar()));
        record.setMappingQuality(isAmongBestHaplotypes ? 60 : 0);
        record.setReadName(HAPLOTYPE_TAG + this.uniqueNameCounter++);
        this.addHaplotypeTag(record, haplotype);
        record.setReadUnmappedFlag(false);
        record.setReferenceIndex(paddedRefLoc.getContigIndex());
        record.setAttribute(SAMTag.RG.toString(), READ_GROUP_ID);
        record.setFlags(16);
        this.bamWriter.addAlignment((SAMRecord)record);
    }

    public static enum Type {
        ALL_POSSIBLE_HAPLOTYPES,
        CALLED_HAPLOTYPES;

    }
}

