/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class DebugUtils {
    private static String dumpDirectory = "contracts_for_java.out";
    private static Map<String, Boolean> loggingEnabled = new HashMap<String, Boolean>();

    @Ensures(value={"result != null"})
    public static String getDumpDirectory() {
        return dumpDirectory;
    }

    @Requires(value={"dir != null"})
    @Ensures(value={"getDumpDirectory().equals(dir)"})
    public static void setDumpDirectory(String string) {
        dumpDirectory = string;
    }

    @Requires(value={"name != null", "data != null", "kind != null"})
    public static void dump(String string, byte[] byArray, JavaFileObject.Kind kind) {
        File file = new File(dumpDirectory + "/" + string + kind.extension);
        DebugUtils.info("dump", "dumping file " + file);
        file.getParentFile().mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            DebugUtils.warn("dump", "while dumping " + file + ": " + iOException.getMessage());
        }
    }

    @Requires(value={"facility != null"})
    public static boolean isLoggingEnabled(String string) {
        Boolean bl = loggingEnabled.get(string);
        if (bl == null) {
            bl = Boolean.valueOf(System.getProperty("com.google.java.contract.log." + string, "false"));
            loggingEnabled.put(string, bl);
        }
        return bl;
    }

    public static void contractInfo(String string) {
        if (DebugUtils.isLoggingEnabled("contract")) {
            System.err.println("[com.google.java.contract:contract " + string + "]");
        }
    }

    @Requires(value={"facility != null", "message != null"})
    public static void info(String string, String string2) {
        if (DebugUtils.isLoggingEnabled(string)) {
            System.err.println("[com.google.java.contract:" + string + " " + string2 + "]");
        }
    }

    @Requires(value={"facility != null", "message != null"})
    public static void warn(String string, String string2) {
        System.err.println("[com.google.java.contract:" + string + " " + string2 + "]");
    }

    @Requires(value={"facility != null", "message != null"})
    public static void err(String string, String string2, Throwable throwable) {
        System.err.println("[com.google.java.contract:" + string + " FATAL ERROR " + string2 + (throwable != null ? " (stack trace follows)" : "") + "]");
        if (throwable != null) {
            throwable.printStackTrace();
        } else {
            new Exception().printStackTrace();
        }
        System.exit(1);
    }
}

