/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.TypeBuilder;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.util.JavaUtils;
import java.net.URLClassLoader;
import javax.lang.model.element.TypeElement;

class TypeFactory {
    protected URLClassLoader sourceDependencyLoader = null;
    protected FactoryUtils utils;

    @Requires(value={"utils != null"})
    TypeFactory(FactoryUtils factoryUtils, String string) {
        if (string != null) {
            this.sourceDependencyLoader = JavaUtils.getLoaderForPath(string);
        }
        this.utils = factoryUtils;
    }

    @Requires(value={"element != null", "diagnosticManager != null"})
    @Ensures(value={"result != null", "result.getName().getQualifiedName().equals(element.getQualifiedName().toString())"})
    TypeModel createType(TypeElement typeElement, DiagnosticManager diagnosticManager) {
        String string = this.utils.elementUtils.getBinaryName(typeElement).toString().replace('.', '/');
        TypeBuilder typeBuilder = new TypeBuilder(this.utils, this.sourceDependencyLoader, diagnosticManager);
        typeElement.accept(typeBuilder, null);
        return typeBuilder.getType();
    }
}

