/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.analysis.directed.InsertSizeMetricsCollector;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class CollectInsertSizeMetrics
extends SinglePassSamProgram {
    private static final Log log = Log.getInstance(CollectInsertSizeMetrics.class);
    private static final String HISTOGRAM_R_SCRIPT = "net/sf/picard/analysis/insertSizeHistogram.R";
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reads a SAM or BAM file and writes a file containing metrics about " + "the statistical distribution of insert size (excluding duplicates) " + "and generates a histogram plot.\n";
    @Option(shortName="H", doc="File to write insert size histogram chart to.")
    public File HISTOGRAM_FILE;
    @Option(doc="Generate mean, sd and plots by trimming the data down to MEDIAN + DEVIATIONS*MEDIAN_ABSOLUTE_DEVIATION. This is done because insert size data typically includes enough anomalous values from chimeras and other artifacts to make the mean and sd grossly misleading regarding the real distribution.")
    public double DEVIATIONS = 10.0;
    @Option(shortName="W", doc="Explicitly sets the histogram width, overriding automatic truncation of histogram tail. Also, when calculating mean and standard deviation, only bins <= HISTOGRAM_WIDTH will be included.", optional=true)
    public Integer HISTOGRAM_WIDTH = null;
    @Option(shortName="M", doc="When generating the histogram, discard any data categories (out of FR, TANDEM, RF) that have fewer than this percentage of overall reads. (Range: 0 to 1).")
    public float MINIMUM_PCT = 0.05f;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    private InsertSizeMetricsCollector multiCollector;

    public static void main(String[] argv) {
        new CollectInsertSizeMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MINIMUM_PCT < 0.0f || (double)this.MINIMUM_PCT > 0.5) {
            return new String[]{"MINIMUM_PCT was set to " + this.MINIMUM_PCT + ". It must be between 0 and 0.5 so all data categories don't get discarded."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.HISTOGRAM_FILE);
        this.multiCollector = new InsertSizeMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), this.MINIMUM_PCT, this.HISTOGRAM_WIDTH, this.DEVIATIONS);
    }

    @Override
    protected void acceptRead(SAMRecord record, ReferenceSequence ref) {
        this.multiCollector.acceptRecord(record, ref);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile file = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(file);
        if (file.getNumHistograms() == 0) {
            log.warn("All data categories were discarded because they contained < " + this.MINIMUM_PCT + " of the total aligned paired data.");
            log.warn("Total mapped pairs in all categories: " + ((InsertSizeMetricsCollector.PerUnitInsertSizeMetricsCollector)this.multiCollector.getAllReadsCollector()).getTotalInserts());
        } else {
            file.write(this.OUTPUT);
            int rResult = this.HISTOGRAM_WIDTH == null ? RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName()) : RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName(), String.valueOf(this.HISTOGRAM_WIDTH));
            if (rResult != 0) {
                throw new PicardException("R script net/sf/picard/analysis/insertSizeHistogram.R failed with return code " + rResult);
            }
        }
    }
}

