/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.codecs.table.TableFeature;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class TableCodec
extends AsciiFeatureCodec<TableFeature>
implements ReferenceDependentFeatureCodec {
    protected static final String delimiterRegex = "\\s+";
    protected static final String headerDelimiter = "HEADER";
    protected static final String igvHeaderDelimiter = "track";
    protected static final String commentDelimiter = "#";
    protected ArrayList<String> header = new ArrayList();
    protected GenomeLocParser genomeLocParser;

    public TableCodec() {
        super(TableFeature.class);
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    @Override
    public TableFeature decode(String line) {
        if (line.startsWith(headerDelimiter) || line.startsWith(commentDelimiter) || line.startsWith(igvHeaderDelimiter)) {
            return null;
        }
        String[] split = line.split(delimiterRegex);
        if (split.length < 1) {
            throw new IllegalArgumentException("TableCodec line = " + line + " doesn't appear to be a valid table format");
        }
        return new TableFeature(this.genomeLocParser.parseGenomeLoc(split[0]), Arrays.asList(split), this.header);
    }

    @Override
    public Object readHeader(LineReader reader) {
        String line = "";
        try {
            boolean isFirst = true;
            while ((line = reader.readLine()) != null) {
                if (isFirst && !line.startsWith(headerDelimiter) && !line.startsWith(commentDelimiter)) {
                    throw new UserException.MalformedFile("TableCodec file does not have a header");
                }
                isFirst &= line.startsWith(commentDelimiter);
                if (line.startsWith(headerDelimiter)) {
                    String[] spl;
                    if (this.header.size() > 0) {
                        throw new IllegalStateException("Input table file seems to have two header lines.  The second is = " + line);
                    }
                    for (String s : spl = line.split(delimiterRegex)) {
                        this.header.add(s);
                    }
                    return this.header;
                }
                if (line.startsWith(commentDelimiter)) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new UserException.MalformedFile("unable to parse header from TableCodec file", e);
        }
        return this.header;
    }
}

