/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.mongodb.ReflectionDBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoGenotype;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.PolymorphicStatus;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.MongoVariantContextException;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public class MongoVariantContext
extends ReflectionDBObject
implements Cloneable {
    private List<String> supportingCallsets = new ArrayList<String>(1);
    private String chr;
    private int start;
    private int stop;
    private String ref;
    private String alt;
    private TruthStatus mongoType;
    private MongoGenotype gt;
    private Date date = new Date();
    private boolean reviewed = false;

    public MongoVariantContext() {
    }

    protected static MongoVariantContext create(String callSetName, String chr, int start, String ref, String alt, boolean isReviewed) {
        return MongoVariantContext.create(callSetName, chr, start, ref, alt, MongoGenotype.NO_CALL, isReviewed);
    }

    protected static MongoVariantContext create(String callSetName, String chr, int start, String ref, String alt, Genotype gt, boolean isReviewed) {
        return MongoVariantContext.create(callSetName, chr, start, ref, alt, TruthStatus.TRUE_POSITIVE, gt, isReviewed);
    }

    protected static MongoVariantContext create(String callSetName, String chr, int start, String ref, String alt, TruthStatus truthStatus, Genotype gt, boolean isReviewed) {
        int stop = start + ref.length() - 1;
        VariantContextBuilder vcb = new VariantContextBuilder(callSetName, chr, start, stop, Arrays.asList(Allele.create(ref, true), Allele.create(alt)));
        return new MongoVariantContext(callSetName, vcb.make(), truthStatus, new Date(), gt, isReviewed);
    }

    public static MongoVariantContext create(List<String> supportingCallsets, VariantContext vc, TruthStatus truthStatus, Date date, Genotype gt, boolean isReviewed) {
        return new MongoVariantContext(supportingCallsets, vc, truthStatus, date, gt, isReviewed);
    }

    public static MongoVariantContext create(String callSetName, VariantContext vc, TruthStatus truthStatus, Genotype gt) {
        return MongoVariantContext.create(Arrays.asList(callSetName), vc, truthStatus, new Date(), gt, false);
    }

    public static MongoVariantContext createFromReview(VariantContext vc) {
        String callSet = MongoVariantContext.parseReviewField(vc, "CallSetName");
        TruthStatus truthStatus = TruthStatus.valueOf(MongoVariantContext.parseReviewField(vc, "TruthStatus"));
        Date date = new Date(Long.valueOf(MongoVariantContext.parseReviewField(vc, "Date")));
        Genotype gt = vc.hasGenotype("NA12878") ? vc.getGenotype("NA12878") : MongoGenotype.NO_CALL;
        return new MongoVariantContext(callSet, vc, truthStatus, date, gt, true);
    }

    protected MongoVariantContext(String callset, VariantContext vc, TruthStatus truthStatus, Date date, Genotype gt, boolean isReviewed) {
        this(Arrays.asList(callset), vc, truthStatus, date, gt, isReviewed);
    }

    protected MongoVariantContext(List<String> supportingCallsets, VariantContext vc, TruthStatus truthStatus, Date date, Genotype gt, boolean isReviewed) {
        if (vc.getNAlleles() > 2) {
            throw new ReviewedStingException("MongoVariantContext only supports single alt allele, but saw " + vc);
        }
        if (vc.isSymbolic()) {
            throw new ReviewedStingException("MongoVariantContext doesn't support symbolic alleles but got " + vc);
        }
        this.supportingCallsets = supportingCallsets;
        this.chr = vc.getChr();
        this.start = vc.getStart();
        this.stop = vc.getEnd();
        this.ref = vc.getReference().getDisplayString();
        this.alt = vc.getAlternateAllele(0).getDisplayString();
        this.mongoType = truthStatus;
        this.date = date;
        this.reviewed = isReviewed;
        this.gt = new MongoGenotype(vc.getAlleles(), gt);
    }

    protected MongoVariantContext(List<String> supportingCallsets, String chr, int start, int stop, String ref, String alt, TruthStatus truthStatus, MongoGenotype gt, Date date, boolean reviewed) {
        this.supportingCallsets = supportingCallsets;
        this.chr = chr;
        this.start = start;
        this.stop = stop;
        this.ref = ref;
        this.alt = alt;
        this.mongoType = truthStatus;
        this.gt = gt;
        this.date = date;
        this.reviewed = reviewed;
    }

    protected MongoVariantContext clone() throws CloneNotSupportedException {
        return new MongoVariantContext(this.supportingCallsets, this.chr, this.start, this.stop, this.ref, this.alt, this.mongoType, this.gt, this.date, this.reviewed);
    }

    private List<Allele> getAlleles() {
        return Arrays.asList(this.getRefAllele(), this.getAltAllele());
    }

    public boolean isSingleCallset() {
        return this.supportingCallsets.size() == 1;
    }

    public String getCallSetName() {
        return Utils.join(",", this.getSupportingCallSets());
    }

    public List<String> getSupportingCallSets() {
        return this.supportingCallsets;
    }

    public void setSupportingCallSets(List<String> supportingCallSets) {
        this.supportingCallsets = supportingCallSets;
    }

    public String toString() {
        try {
            return String.format("%s:%d-%d %s/%s %s/%s reviewed?=%b %s %s", new Object[]{this.getChr(), this.getStart(), this.getStop(), this.getRef(), this.getAlt(), this.getType(), this.getPolymorphicStatus(), this.isReviewed(), Utils.join(",", this.getSupportingCallSets()), this.getGt()});
        }
        catch (Exception e) {
            return String.format("%s at %s:%d [malformed]", this.supportingCallsets, this.chr, this.start);
        }
    }

    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public String getRef() {
        return this.ref;
    }

    public Allele getRefAllele() {
        return Allele.create(this.getRef(), true);
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getAlt() {
        return this.alt;
    }

    public Allele getAltAllele() {
        return Allele.create(this.getAlt(), false);
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public VariantContext getVariantContext() {
        VariantContextBuilder vcb = new VariantContextBuilder(this.getCallSetName(), this.chr, this.start, this.stop, this.getAlleles());
        this.addReviewInfoFields(vcb);
        vcb.genotypes(this.gt.toGenotype(this.getAlleles()));
        return vcb.make();
    }

    public TruthStatus getType() {
        return this.mongoType;
    }

    public void setTruth(TruthStatus status) {
        this.mongoType = status;
    }

    protected void addReviewInfoFields(VariantContextBuilder vcb) {
        vcb.attribute("CallSetName", this.getCallSetName());
        vcb.attribute("TruthStatus", (Object)this.getType());
        vcb.attribute("PolymorphicStatus", (Object)this.getPolymorphicStatus());
        vcb.attribute("Date", this.getDate().getTime());
    }

    public static Set<VCFHeaderLine> reviewHeaderLines() {
        HashSet<VCFHeaderLine> lines = new HashSet<VCFHeaderLine>();
        lines.add(new VCFInfoHeaderLine("CallSetName", 1, VCFHeaderLineType.String, "Name of the review"));
        lines.add(new VCFInfoHeaderLine("TruthStatus", 1, VCFHeaderLineType.String, "What is the truth state of this call"));
        lines.add(new VCFInfoHeaderLine("PolymorphicStatus", 1, VCFHeaderLineType.String, "Is this call polymorphic in NA12878"));
        lines.add(new VCFInfoHeaderLine("Date", 1, VCFHeaderLineType.String, "Date/time as a long of this review"));
        lines.add(new VCFInfoHeaderLine("PhredConfidence", 1, VCFHeaderLineType.Integer, "Phred-scaled confidence in this review"));
        lines.add(VCFStandardHeaderLines.getFormatLine("DP"));
        lines.add(VCFStandardHeaderLines.getFormatLine("GQ"));
        return lines;
    }

    private static String parseReviewField(VariantContext vc, String key) {
        String value = vc.getAttributeAsString(key, null);
        if (value == null) {
            throw new UserException.BadInput("Missing key " + key + " from " + vc);
        }
        return value;
    }

    public String getMongoType() {
        return this.mongoType.toString();
    }

    public void setMongoType(String mongoType) {
        this.mongoType = TruthStatus.valueOf(mongoType);
    }

    public PolymorphicStatus getPolymorphicStatus() {
        return this.getGt().getPolymorphicStatus();
    }

    public boolean isReviewed() {
        return this.reviewed;
    }

    public boolean getReviewed() {
        return this.reviewed;
    }

    public void setReviewed(boolean reviewed) {
        this.reviewed = reviewed;
    }

    public GenomeLoc getLocation(GenomeLocParser parser) {
        return parser.createGenomeLoc(this.getChr(), this.getStart(), this.getStop());
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MongoGenotype getGt() {
        return this.gt;
    }

    public void setGt(MongoGenotype gt) {
        this.gt = gt;
    }

    public boolean isPolymorphic() {
        return this.getGt().isPolymorphic();
    }

    public boolean isMonomorphic() {
        return this.getGt().isMonomorphic();
    }

    public boolean isDiscordant() {
        return this.getGt().isDiscordant();
    }

    public boolean isUnknown() {
        return this.getGt().isUnknown();
    }

    public boolean matches(VariantContext vc) {
        return vc.isBiallelic() && this.getChr().equals(vc.getChr()) && this.getStart() == vc.getStart() && this.getStop() == vc.getEnd() && this.getRef().equals(vc.getReference().getBaseString()) && this.getAlt().equals(vc.getAlternateAllele(0).getBaseString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoVariantContext that = (MongoVariantContext)o;
        if (this.reviewed != that.reviewed) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.stop != that.stop) {
            return false;
        }
        if (this.alt != null ? !this.alt.equals(that.alt) : that.alt != null) {
            return false;
        }
        if (this.chr != null ? !this.chr.equals(that.chr) : that.chr != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
            return false;
        }
        if (this.gt != null ? !this.gt.equals(that.gt) : that.gt != null) {
            return false;
        }
        if (this.mongoType != that.mongoType) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return !(this.supportingCallsets != null ? !this.supportingCallsets.equals(that.supportingCallsets) : that.supportingCallsets != null);
    }

    public boolean isDuplicate(MongoVariantContext that) {
        if (that == null) {
            throw new IllegalArgumentException("that cannot be null");
        }
        if (this.reviewed != that.reviewed) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.stop != that.stop) {
            return false;
        }
        if (!this.ref.equals(that.ref)) {
            return false;
        }
        if (!this.alt.equals(that.alt)) {
            return false;
        }
        if (!this.chr.equals(that.chr)) {
            return false;
        }
        if (!this.gt.equals(that.gt)) {
            return false;
        }
        if (this.mongoType != that.mongoType) {
            return false;
        }
        return this.supportingCallsets.equals(that.supportingCallsets);
    }

    public int hashCode() {
        int result = this.supportingCallsets != null ? this.supportingCallsets.hashCode() : 0;
        result = 31 * result + (this.chr != null ? this.chr.hashCode() : 0);
        result = 31 * result + this.start;
        result = 31 * result + this.stop;
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 31 * result + (this.alt != null ? this.alt.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.mongoType != null ? this.mongoType.hashCode() : 0);
        result = 31 * result + (this.reviewed ? 1 : 0);
        result = 31 * result + (this.gt != null ? this.gt.hashCode() : 0);
        return result;
    }

    protected void validate(GenomeLocParser parser) {
        String gtBad;
        if (this.supportingCallsets == null || this.supportingCallsets.size() == 0) {
            this.error("SupportingCallSets has a bad value %s", this.supportingCallsets);
        }
        if (this.supportingCallsets.indexOf(null) != -1) {
            this.error("SupportingCallSets contains a null element %s", this.supportingCallsets);
        }
        if (this.start < 1) {
            this.error("Start = %d < 1", this.start);
        }
        if (this.start > this.stop) {
            this.error("Start %d > Stop %d", this.start, this.stop);
        }
        if (this.chr == null) {
            this.error("Chr is null", new Object[0]);
        }
        if (parser != null && !parser.contigIsInDictionary(this.chr)) {
            this.error("Chr %s is not in the b37 dictionary", this.chr);
        }
        if (parser == null && this.chr.toLowerCase().startsWith("chr")) {
            this.error("MongoVariantContext %s uses the UCSC convention -- must use the b37 convention (i.e., 1 not chr1)", this.chr);
        }
        if (this.ref == null || this.ref.equals("")) {
            this.error("ref allele is null or empty string", new Object[0]);
        }
        if (!BaseUtils.isUpperCase(this.ref.getBytes())) {
            this.error("ref allele must be all upper case but got " + this.ref, new Object[0]);
        }
        if (!Allele.acceptableAlleleBases(this.ref)) {
            this.error("ref allele contains unacceptable bases " + this.ref, new Object[0]);
        }
        if (this.alt == null || this.alt.equals("")) {
            this.error("alt allele is null or empty string", new Object[0]);
        }
        if (!BaseUtils.isUpperCase(this.alt.getBytes())) {
            this.error("alt allele must be all upper case but got " + this.alt, new Object[0]);
        }
        if (!Allele.acceptableAlleleBases(this.alt)) {
            this.error("alt allele contains unacceptable bases " + this.alt, new Object[0]);
        }
        if (this.gt == null) {
            this.error("gt is null", new Object[0]);
        }
        if ((gtBad = this.gt.validate()) != null) {
            this.error("gt %s is bad: %s", this.gt, gtBad);
        }
    }

    private void error(String message, Object ... values) {
        throw new MongoVariantContextException(String.format("MongoVariantContext is bad: reason = %s at context %s", String.format(message, values), this.toString()), this);
    }
}

