/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.Feature;

public class GlobalKeyDispatcher
implements KeyEventDispatcher {
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();

    public GlobalKeyDispatcher() {
        this.init();
    }

    public InputMap getInputMap() {
        return this.keyStrokes;
    }

    public ActionMap getActionMap() {
        return this.actions;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Action action;
        if (event.getKeyCode() == 27) {
            IGV.getInstance().clearSelections();
            IGV.getInstance().repaint();
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        String actionKey = (String)this.keyStrokes.get(ks);
        if (event.getKeyCode() == 17 || event.getKeyCode() == 18) {
            boolean flag = !event.isControlDown() && !event.isAltDown() && !event.isMetaDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }
        if (actionKey != null && (action = this.actions.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, event.getModifiers()));
            return true;
        }
        return false;
    }

    public void init() {
        KeyStroke nextKey = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke prevKey = KeyStroke.getKeyStroke(66, 2, false);
        KeyStroke toolsKey = KeyStroke.getKeyStroke(84, 8, false);
        KeyStroke regionKey = KeyStroke.getKeyStroke(82, 2, false);
        KeyStroke regionCenterKey = KeyStroke.getKeyStroke(82, 3, false);
        KeyStroke nextExonKey = KeyStroke.getKeyStroke(70, 3, false);
        KeyStroke prevExonKey = KeyStroke.getKeyStroke(66, 3, false);
        KeyStroke backKey1 = KeyStroke.getKeyStroke(93, 256, false);
        KeyStroke backKey2 = KeyStroke.getKeyStroke(37, 512, false);
        KeyStroke forwardKey1 = KeyStroke.getKeyStroke(91, 256, false);
        KeyStroke forwardKey2 = KeyStroke.getKeyStroke(39, 512, false);
        KeyStroke statusWindowKey = KeyStroke.getKeyStroke(83, 2, false);
        KeyStroke scatterplotKey = KeyStroke.getKeyStroke(80, 2, false);
        EnableWrappedAction toolAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().enableExtrasMenu();
            }
        });
        EnableWrappedAction statusWindowAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().openStatusWindow();
            }
        });
        EnableWrappedAction nextAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextFeature(true);
            }
        });
        EnableWrappedAction prevAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextFeature(false);
            }
        });
        EnableWrappedAction nextExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextExon(true);
            }
        });
        EnableWrappedAction prevExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextExon(false);
            }
        });
        EnableWrappedAction regionAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                ReferenceFrame.Range currentRange = FrameManager.getDefaultFrame().getCurrentRange();
                RegionOfInterest regionOfInterest = new RegionOfInterest(currentRange.getChr(), currentRange.getStart(), currentRange.getEnd(), null);
                IGV.getInstance().addRegionOfInterest(regionOfInterest);
            }
        });
        EnableWrappedAction regionCenterAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                int center = (int)FrameManager.getDefaultFrame().getCenter();
                RegionOfInterest regionOfInterest = new RegionOfInterest(FrameManager.getDefaultFrame().getChrName(), center, center + 1, null);
                IGV.getInstance().addRegionOfInterest(regionOfInterest);
            }
        });
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().getSession().getHistory().back();
            }
        };
        AbstractAction forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().getSession().getHistory().forward();
            }
        };
        AbstractAction scatterplotAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScatterPlotUtils.hasPlottableTracks()) {
                    ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                    String chr = defaultFrame.getChrName();
                    int start = (int)defaultFrame.getOrigin();
                    int end = (int)defaultFrame.getEnd();
                    int zoom = defaultFrame.getZoom();
                    ScatterPlotUtils.openPlot(chr, start, end, zoom);
                }
            }
        };
        this.getInputMap().put(nextKey, "nextFeature");
        this.getActionMap().put("nextFeature", nextAction);
        this.getInputMap().put(prevKey, "prevFeature");
        this.getActionMap().put("prevFeature", prevAction);
        this.getInputMap().put(nextExonKey, "nextExon");
        this.getActionMap().put("nextExon", nextExonAction);
        this.getInputMap().put(prevExonKey, "prevExon");
        this.getActionMap().put("prevExon", prevExonAction);
        this.getInputMap().put(toolsKey, "tools");
        this.getActionMap().put("tools", toolAction);
        this.getInputMap().put(regionKey, "region");
        this.getActionMap().put("region", regionAction);
        this.getInputMap().put(regionCenterKey, "regionCenter");
        this.getActionMap().put("regionCenter", regionCenterAction);
        this.getInputMap().put(statusWindowKey, "statusWindow");
        this.getActionMap().put("statusWindow", statusWindowAction);
        this.getInputMap().put(scatterplotKey, "statusWindow");
        this.getActionMap().put("statusWindow", scatterplotAction);
        this.getInputMap().put(backKey1, "back");
        this.getInputMap().put(backKey2, "back");
        this.getActionMap().put("back", backAction);
        this.getInputMap().put(forwardKey1, "forward");
        this.getInputMap().put(forwardKey2, "forward");
        this.getActionMap().put("forward", forwardAction);
    }

    private void nextExon(boolean forward) {
        if (FrameManager.isGeneListMode()) {
            return;
        }
        ReferenceFrame vc = FrameManager.getDefaultFrame();
        Collection<Track> tracks = IGV.getInstance().getSelectedTracks();
        if (tracks.size() == 1) {
            Track t = tracks.iterator().next();
            if (!(t instanceof FeatureTrack)) {
                return;
            }
            AbstractFeature e = null;
            if (t instanceof FeatureTrack) {
                int center = (int)vc.getCenter();
                FeatureTrack ft = (FeatureTrack)t;
                if (ft.getDisplayMode() == Track.DisplayMode.COLLAPSED || ft.getSelectedFeatureRowIndex() == -1) {
                    MessageUtils.showMessage("Exon navigation is only allowed when track is expanded and a single feature row is selected.");
                    return;
                }
                Feature feature = ft.getFeatureAtPositionInFeatureRow(center, ft.getSelectedFeatureRowIndex(), vc);
                if (feature == null) {
                    return;
                }
                if (feature instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)feature;
                    List<Exon> exons = bf.getExons();
                    if (exons == null || exons.isEmpty()) {
                        MessageUtils.showMessage("At least one centered feature does not have exon structure");
                        return;
                    }
                    if (forward) {
                        for (Exon exon : bf.getExons()) {
                            if (!((double)exon.getStart() > vc.getCenter() + 1.0)) continue;
                            e = exon;
                            break;
                        }
                    } else {
                        for (int i = exons.size() - 1; i >= 0; --i) {
                            Exon exon = exons.get(i);
                            if (!((double)exon.getEnd() < vc.getCenter())) continue;
                            e = exon;
                            break;
                        }
                    }
                }
                if (e != null) {
                    vc.centerOnLocation(forward ? (double)e.getStart() : (double)e.getEnd());
                    int i = 3;
                }
            }
        } else {
            MessageUtils.showMessage("To use track panning you must first select a single feature track.");
        }
    }

    private void nextFeature(boolean forward) {
        block10: {
            if (FrameManager.isGeneListMode()) {
                return;
            }
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            Collection<Track> tracks = IGV.getInstance().getSelectedTracks();
            if (tracks.size() == 1) {
                try {
                    Track t = tracks.iterator().next();
                    if (!(t instanceof FeatureTrack) && !(t instanceof VariantTrack)) {
                        return;
                    }
                    Feature f = null;
                    if (t instanceof FeatureTrack) {
                        f = ((FeatureTrack)t).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                    } else if (t instanceof VariantTrack) {
                        f = ((VariantTrack)t).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                    }
                    if (f == null) break block10;
                    String chr = GenomeManager.getInstance().getCurrentGenome().getChromosomeAlias(f.getChr());
                    double newCenter = f.getStart();
                    if (!chr.equals(frame.getChrName())) {
                        double range = frame.getEnd() - frame.getOrigin();
                        int newOrigin = (int)Math.max(newCenter - range / 2.0, 0.0);
                        int newEnd = (int)((double)newOrigin + range);
                        frame.jumpTo(chr, newOrigin, newEnd);
                        break block10;
                    }
                    frame.centerOnLocation(newCenter);
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error encountered reading features: " + e.getMessage(), e);
                }
            } else {
                MessageUtils.showMessage("To use track panning you must first select a single feature track.");
            }
        }
    }

    private class EnableWrappedAction
    extends AbstractAction {
        private Action action;

        private EnableWrappedAction(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            this.action.actionPerformed(e);
            this.setEnabled(true);
        }
    }
}

