/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.motiffinder;

import com.google.common.collect.Iterators;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.sf.samtools.util.SequenceUtil;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.CachingFeatureSource;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.session.SessionXmlAdapters;
import org.broad.igv.tools.motiffinder.MotifFinderDialog;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.tribble.Feature;

@XmlAccessorType(value=XmlAccessType.NONE)
public class MotifFinderSource
implements FeatureSource<Feature> {
    @XmlAttribute
    private String pattern;
    @XmlJavaTypeAdapter(value=SessionXmlAdapters.Genome.class)
    @XmlAttribute
    private Genome genome;
    @XmlAttribute
    private int featureWindowSize = 100000;
    @XmlAttribute
    private Strand strand;

    private MotifFinderSource() {
    }

    public MotifFinderSource(String pattern, Strand strand, Genome genome) {
        this.pattern = pattern;
        assert (strand == Strand.POSITIVE || strand == Strand.NEGATIVE);
        this.strand = strand;
        this.genome = genome;
    }

    static Iterator<Feature> searchSingleStrand(String pattern, Strand strand, String chr, int posStart, byte[] sequence) {
        Matcher matcher = MotifFinderSource.getMatcher(pattern, strand, sequence);
        return new MatchFeatureIterator(chr, strand, posStart, sequence.length, matcher);
    }

    static Matcher getMatcher(String pattern, Strand strand, byte[] sequence) {
        byte[] seq = sequence;
        if (strand == Strand.NEGATIVE) {
            SequenceUtil.reverseComplement(seq);
        }
        Pattern regex = Pattern.compile(pattern, 2);
        String stringSeq = new String(seq);
        return regex.matcher(stringSeq);
    }

    public static Iterator<Feature> search(String pattern, Strand strand, String chr, int posStart, byte[] sequence) {
        switch (strand) {
            case POSITIVE: {
                return MotifFinderSource.searchSingleStrand(pattern, strand, chr, posStart, sequence);
            }
            case NEGATIVE: {
                Iterator<Feature> negIter = MotifFinderSource.searchSingleStrand(pattern, Strand.NEGATIVE, chr, posStart, sequence);
                ArrayList negStrandFeatures = new ArrayList();
                Iterators.addAll(negStrandFeatures, negIter);
                Collections.reverse(negStrandFeatures);
                return negStrandFeatures.iterator();
            }
        }
        throw new IllegalArgumentException("Strand must be either POSITIVE or NEGATIVE");
    }

    @Override
    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        byte[] seq = this.genome.getSequence(chr, start, end);
        if (seq == null) {
            Collections.emptyList().iterator();
        }
        return MotifFinderSource.search(this.pattern, this.strand, chr, start, seq);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
    }

    private static class MatchFeatureIterator
    implements Iterator<Feature> {
        private String chr;
        private int posOffset;
        private Strand strand;
        private int lastMatchStart = -1;
        private Matcher matcher;
        private IGVFeature nextFeat;

        private MatchFeatureIterator(String chr, Strand strand, int posOffset, int sequenceLength, Matcher matcher) {
            this.chr = chr;
            this.strand = strand;
            this.posOffset = posOffset;
            this.matcher = matcher;
            if (this.strand == Strand.NEGATIVE) {
                this.posOffset += sequenceLength;
            }
            this.findNext();
        }

        private void findNext() {
            if (this.matcher.find(this.lastMatchStart + 1)) {
                int end;
                int start;
                this.lastMatchStart = this.matcher.start();
                if (this.strand == Strand.POSITIVE) {
                    start = this.posOffset + this.lastMatchStart;
                    end = this.posOffset + this.matcher.end();
                } else {
                    start = this.posOffset - this.matcher.end();
                    end = this.posOffset - this.lastMatchStart;
                }
                this.nextFeat = new BasicFeature(this.chr, start, end, this.strand);
            } else {
                this.nextFeat = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeat != null;
        }

        @Override
        public IGVFeature next() {
            IGVFeature nF = this.nextFeat;
            this.findNext();
            return nF;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Cannot remove from this iterator");
        }
    }

    public static class MotifFinderPlugin
    implements IGVPlugin {
        @Override
        public void init() {
            JMenuItem menuItem = new JMenuItem("Find Motif...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MotifFinderDialog dialog = new MotifFinderDialog(IGV.getMainFrame());
                    dialog.setVisible(true);
                    String pattern = dialog.getInputPattern();
                    String posTrackName = dialog.getPosTrackName();
                    String negTrackName = dialog.getNegTrackName();
                    String[] trackNames = new String[]{posTrackName, negTrackName};
                    Color[] colors = new Color[]{null, Color.RED};
                    Strand[] strands = new Strand[]{Strand.POSITIVE, Strand.NEGATIVE};
                    ArrayList<Track> trackList = new ArrayList<Track>(trackNames.length);
                    if (pattern != null) {
                        for (int ii = 0; ii < trackNames.length; ++ii) {
                            MotifFinderSource src = new MotifFinderSource(pattern, strands[ii], GenomeManager.getInstance().getCurrentGenome());
                            CachingFeatureSource cachingSrc = new CachingFeatureSource(src);
                            FeatureTrack track = new FeatureTrack(trackNames[ii], trackNames[ii], (FeatureSource)cachingSrc);
                            if (colors[ii] != null) {
                                track.setColor(colors[ii]);
                            }
                            track.setDisplayMode(Track.DisplayMode.EXPANDED);
                            trackList.add(track);
                        }
                        IGV.getInstance().addTracks(trackList, PanelName.FEATURE_PANEL);
                    }
                }
            });
            IGV.getInstance().addOtherToolMenu(menuItem);
        }
    }
}

