/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeaturesSpliceJunctions;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.event.AlignmentTrackEventListener;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.util.ResourceLocator;

public class SpliceJunctionFinderTrack
extends FeatureTrack
implements AlignmentTrackEventListener {
    private static Logger log = Logger.getLogger(SpliceJunctionFinderTrack.class);
    AlignmentDataManager dataManager;
    PreferenceManager prefs;
    RenderContext context;
    JComponent parent;

    public SpliceJunctionFinderTrack(ResourceLocator locator, String name, AlignmentDataManager dataManager) {
        super(locator, locator.getPath() + "_junctions", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.setRendererClass(SpliceJunctionRenderer.class);
        this.dataManager = dataManager;
        this.prefs = PreferenceManager.getInstance();
        IGV.getInstance().addAlignmentTrackEventListener(this);
    }

    @Override
    protected boolean isShowFeatures(RenderContext context) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        return context.getScale() < (double)minVisibleScale;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        TrackMenuUtils.addStandardItems(popupMenu, tmp, te);
        return popupMenu;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        super.setDataRange(axisDefinition);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    protected void loadFeatures(String chr, int start, int end, RenderContext context) {
        this.parent = context.getPanel();
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame().getName());
        if (loadedInterval == null) {
            return;
        }
        List<SpliceJunctionFeature> features = loadedInterval.getSpliceJunctions();
        if (features == null) {
            features = Collections.emptyList();
        }
        int intervalStart = loadedInterval.getStart();
        int intervalEnd = loadedInterval.getEnd();
        PackedFeaturesSpliceJunctions<SpliceJunctionFeature> pf = new PackedFeaturesSpliceJunctions<SpliceJunctionFeature>(chr, intervalStart, intervalEnd, features.iterator(), this.getName());
        this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
        if (context.getPanel() != null) {
            context.getPanel().repaint();
        }
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        boolean result = super.handleDataClick(te);
        if (this.parent != null) {
            this.parent.repaint();
        }
        return result;
    }

    @Override
    public void onAlignmentTrackEvent(AlignmentTrackEvent e) {
        AlignmentTrackEvent.Type type = e.getType();
        switch (type) {
            case SPLICE_JUNCTION: {
                this.packedFeaturesMap.clear();
            }
        }
    }
}

