/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.tribble.Feature;

public class SashimiJunctionRenderer
extends IGVFeatureRenderer {
    private static Logger log = Logger.getLogger(SashimiJunctionRenderer.class);
    Color ARC_COLOR_POS;
    private Color color;
    Color COLOR_CENTERLINE;
    protected int DEFAULT_MAX_DEPTH;
    protected int maxDepth;
    private ShapeType shapeType;
    private Set<IExon> selectedExons;
    private CoverageTrack coverageTrack;
    private AlignmentDataManager dataManager;
    private Color background;
    private Map<Feature, Boolean> drawFeatureAbove;

    public SashimiJunctionRenderer() {
        this.color = this.ARC_COLOR_POS = new Color(150, 50, 50, 140);
        this.COLOR_CENTERLINE = new Color(0, 0, 0, 100);
        this.maxDepth = this.DEFAULT_MAX_DEPTH = 50;
        this.shapeType = ShapeType.TEXT;
        this.coverageTrack = null;
        this.dataManager = null;
        this.drawFeatureAbove = null;
    }

    public void setSelectedExons(Set<IExon> selectedExons) {
        this.selectedExons = selectedExons;
    }

    public void setDataManager(AlignmentDataManager dataManager) {
        this.dataManager = dataManager;
        this.setCoverageTrack(dataManager.getCoverageTrack());
    }

    public AlignmentDataManager getDataManager() {
        return this.dataManager;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType = shapeType;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.coverageTrack != null) {
            this.coverageTrack.setColor(color);
        }
    }

    private void setCoverageTrack(CoverageTrack covTrack) {
        this.coverageTrack = new CoverageTrack(covTrack);
        this.coverageTrack.setColor(this.color);
        this.coverageTrack.setSnpThreshold(2.0f);
        this.coverageTrack.setAutoScale(true);
        this.coverageTrack.rescale();
    }

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        this.setColor(track.getColor());
        Rectangle coverageRectangle = new Rectangle(trackRectangle);
        if (this.coverageTrack != null) {
            int newHeight = coverageRectangle.height / 2;
            int newY = coverageRectangle.y + coverageRectangle.height / 2 - newHeight;
            coverageRectangle.setBounds(coverageRectangle.x, newY, coverageRectangle.width, newHeight);
            this.coverageTrack.render(context, coverageRectangle);
        }
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && !featureList.isEmpty()) {
            Font font = FontManager.getFont(track.getFontSize());
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(Color.BLACK).create();
            fontGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            fontGraphics.setFont(font);
            double trackRectangleX = trackRectangle.getX();
            double trackRectangleMaxX = trackRectangle.getMaxX();
            fontGraphics.drawString(track.getName(), (int)(trackRectangleMaxX * 0.85), (int)(trackRectangle.getY() + (double)font.getSize()));
            Set<IExon> locselectedExons = this.selectedExons;
            if (this.drawFeatureAbove == null) {
                this.drawFeatureAbove = new HashMap<Feature, Boolean>(featureList.size());
            }
            boolean lastDrawAbove = true;
            for (IGVFeature feature : featureList) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                int junctionStart = junctionFeature.getJunctionStart();
                int junctionEnd = junctionFeature.getJunctionEnd();
                Boolean drawAbove = this.drawFeatureAbove.get(junctionFeature);
                if (drawAbove == null) {
                    drawAbove = !lastDrawAbove;
                    this.drawFeatureAbove.put(junctionFeature, drawAbove);
                }
                if (locselectedExons != null && locselectedExons.size() > 0) {
                    boolean inSelected = false;
                    for (IExon selectedExon : locselectedExons) {
                        if ((junctionStart < selectedExon.getStart() || junctionStart > selectedExon.getEnd()) && (junctionEnd < selectedExon.getStart() || junctionEnd > selectedExon.getEnd())) continue;
                        inSelected = true;
                        break;
                    }
                    if (!inSelected) continue;
                }
                double virtualPixelJunctionStart = Math.round(((double)junctionStart - origin) / locScale);
                double virtualPixelJunctionEnd = Math.round(((double)junctionEnd - origin) / locScale);
                if (!(virtualPixelJunctionEnd >= trackRectangleX) || !(virtualPixelJunctionStart <= trackRectangleMaxX)) continue;
                int depth = junctionFeature.getJunctionDepth();
                Color color = feature.getColor();
                int pixelYstart = 0;
                int pixelYend = 0;
                if (this.coverageTrack != null) {
                    pixelYstart = this.getYOffset(coverageRectangle, this.coverageTrack.getDataRange(), this.getCoverage(junctionStart));
                    pixelYend = this.getYOffset(coverageRectangle, this.coverageTrack.getDataRange(), this.getCoverage(junctionEnd));
                }
                this.drawFeature(pixelYstart, pixelYend, (int)virtualPixelJunctionStart, (int)virtualPixelJunctionEnd, depth, trackRectangle, context, color, drawAbove);
                lastDrawAbove = drawAbove;
            }
            Graphics2D g2D = context.getGraphic2DForColor(this.COLOR_CENTERLINE);
            g2D.drawLine((int)trackRectangleX, (int)trackRectangle.getCenterY(), (int)trackRectangleMaxX, (int)trackRectangle.getCenterY());
        }
    }

    private int getCoverage(int genomePos) {
        if (this.dataManager == null) {
            return 0;
        }
        Collection<AlignmentInterval> intervals = this.dataManager.getAllLoadedIntervals();
        if (intervals == null) {
            return 0;
        }
        int buffer = 4;
        int coverage = 0;
        for (AlignmentInterval interval : intervals) {
            if (!interval.contains(interval.getChr(), genomePos - buffer, genomePos + buffer)) continue;
            for (int loc = genomePos - buffer; loc < genomePos + buffer; ++loc) {
                coverage = Math.max(coverage, interval.getTotalCount(loc));
            }
            return coverage;
        }
        return 0;
    }

    private int getYOffset(Rectangle rect, DataRange range, int totalCount) {
        double maxRange = range.isLog() ? Math.log10(range.getMaximum()) : (double)range.getMaximum();
        double tmp = range.isLog() ? Math.log10(totalCount) / maxRange : (double)totalCount / maxRange;
        int height = (int)(tmp * (double)rect.height);
        height = Math.min(height, rect.height - 1);
        return -height;
    }

    protected void drawFeature(int pixelYStartOffset, int pixelYEndOffset, int pixelJunctionStart, int pixelJunctionEnd, int depth, Rectangle trackRectangle, RenderContext context, Color featureColor, boolean drawAbove) {
        double maxStrokeSize;
        Color color;
        if (featureColor != null) {
            int r = featureColor.getRed();
            int g = featureColor.getGreen();
            int b = featureColor.getBlue();
            int alpha = 140;
            color = new Color(r, g, b, alpha);
        } else {
            color = this.color;
        }
        int length = pixelJunctionEnd - pixelJunctionStart;
        int minArcHeight = (trackRectangle.height - 1) / 8;
        int arcHeight = minArcHeight + (int)(Math.log(length) / Globals.log2);
        int minY = (int)trackRectangle.getCenterY() + Math.min(pixelYStartOffset - arcHeight, pixelYEndOffset - arcHeight);
        if (drawAbove && (double)minY < trackRectangle.getMinY()) {
            pixelYStartOffset = 0;
            pixelYEndOffset = 0;
        }
        int effDepth = Math.min(this.maxDepth, depth);
        int yPosModifier = drawAbove ? -1 : 1;
        int arcBeginY = (int)trackRectangle.getCenterY() + yPosModifier + (drawAbove ? pixelYStartOffset - 2 : 0);
        int arcEndY = (int)trackRectangle.getCenterY() + yPosModifier + (drawAbove ? pixelYEndOffset - 2 : 0);
        int arcControlPeakY = arcBeginY + yPosModifier * arcHeight;
        GeneralPath arcPath = new GeneralPath();
        arcPath.moveTo(pixelJunctionStart, arcBeginY);
        arcPath.curveTo(pixelJunctionStart, arcControlPeakY, pixelJunctionEnd, arcControlPeakY, pixelJunctionEnd, arcEndY);
        Graphics2D g2D = context.getGraphic2DForColor(color);
        g2D.setBackground(this.background);
        double minStrokeSize = 0.1f;
        double strokeSize = maxStrokeSize = 3.0;
        if (this.maxDepth >= 2) {
            double scale = (maxStrokeSize - minStrokeSize) / Math.log(this.maxDepth);
            strokeSize = scale * Math.log(effDepth) + minStrokeSize;
        }
        BasicStroke stroke = new BasicStroke((float)strokeSize);
        g2D.setStroke(stroke);
        g2D.draw(arcPath);
        float midX = ((float)pixelJunctionStart + (float)pixelJunctionEnd) / 2.0f;
        double actArcPeakY = (double)arcBeginY + (double)yPosModifier * Math.pow(0.5, 3.0) * 6.0 * (double)arcHeight;
        Shape shape = null;
        switch (this.shapeType) {
            case TEXT: {
                String text = "" + depth;
                Rectangle2D textBounds = g2D.getFontMetrics().getStringBounds(text, g2D);
                float floatX = (float)((double)midX - textBounds.getWidth() / 2.0);
                float floatY = (float)actArcPeakY + (float)textBounds.getHeight() / 2.0f;
                int rectHeight = (int)textBounds.getHeight();
                g2D.clearRect((int)floatX, (int)floatY - rectHeight, (int)textBounds.getWidth(), rectHeight);
                g2D.drawString(text, floatX, floatY);
            }
        }
        if (shape != null) {
            g2D.draw(shape);
            g2D.fill(shape);
        }
    }

    private Shape createDepthEllipse(double maxPossibleShapeHeight, double depthProportionOfMax, double arcMidX, double actArcPeakY) {
        double w = 5.0;
        double x = arcMidX - w / 2.0;
        double h = maxPossibleShapeHeight * depthProportionOfMax;
        double y = actArcPeakY - h / 2.0;
        return new Ellipse2D.Double(x, y, w, h);
    }

    private Shape createDepthCircle(double maxPossibleShapeHeight, double depthProportionOfMax, double arcMidX, double actArcPeakY) {
        double h;
        double w = h = maxPossibleShapeHeight * Math.sqrt(depthProportionOfMax);
        double x = arcMidX - w / 2.0;
        double y = actArcPeakY - h / 2.0;
        return new Ellipse2D.Double(x, y, w, h);
    }

    public static enum ShapeType {
        CIRCLE,
        ELLIPSE,
        TEXT;

    }
}

