/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import com.mongodb.WriteResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.broad.igv.plugin.mongovariant.VariantReviewPlugin;
import org.broad.igv.plugin.mongovariant.VariantReviewSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878KnowledgeBase;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VariantReviewDialog
extends JDialog {
    private VariantContext variantContext;
    private String userName;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JLabel label4;
    private JTextField callsetField;
    private JPanel hSpacer1;
    private JPanel panel2;
    private JLabel label5;
    private JComboBox truthField;
    private JPanel panel3;
    private JLabel label6;
    private JComboBox genotypeTypeField;
    private JPanel hSpacer2;
    private JPanel panel7;
    private JLabel label10;
    private JLabel mutField;
    private JPanel hSpacer5;
    private JPanel panel4;
    private JLabel label7;
    private JLabel chrField;
    private JPanel hSpacer3;
    private JPanel panel5;
    private JLabel label8;
    private JLabel startField;
    private JPanel hSpacer4;
    private JPanel panel6;
    private JLabel label9;
    private JLabel stopField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public VariantReviewDialog(Frame owner, VariantContext vc) {
        super(owner);
        this.initComponents();
        this.truthField.setModel(new DefaultComboBoxModel<TruthStatus>(TruthStatus.values()));
        this.genotypeTypeField.setModel(new DefaultComboBoxModel<GenotypeType>(GenotypeType.values()));
        this.variantContext = vc;
        this.userName = System.getProperty("user.name", "unknown");
        this.initComponentData(vc);
    }

    private void initComponentData(VariantContext variant) {
        this.callsetField.setText(this.userName);
        this.chrField.setText(variant.getChr());
        this.startField.setText("" + variant.getStart());
        this.stopField.setText("" + variant.getEnd());
        this.truthField.setSelectedItem((Object)TruthStatus.UNKNOWN);
        this.initGenotypeTypeField(variant);
        this.validate();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        String callsetName = this.callsetField.getText();
        TruthStatus truthStatus = (TruthStatus)((Object)this.truthField.getSelectedItem());
        int allele0 = -1;
        int allele1 = -1;
        GenotypeType gtt = (GenotypeType)((Object)this.genotypeTypeField.getSelectedItem());
        switch (gtt) {
            case HOM_REF: {
                allele1 = 0;
                allele0 = 0;
                break;
            }
            case HOM_VAR: {
                allele1 = 1;
                allele0 = 1;
                break;
            }
            case HET: {
                allele0 = 0;
                allele1 = 1;
            }
        }
        MongoVariantContext mvc = VariantReviewSource.createMVC(allele0, allele1, callsetName, this.variantContext, truthStatus);
        String errorMessage = VariantReviewDialog.addCall(VariantReviewPlugin.getDbSpecPath(), mvc);
        if (errorMessage != null) {
            MessageUtils.showErrorMessage(errorMessage, new IOException(errorMessage));
        } else {
            this.setVisible(false);
            for (FeatureTrack t : IGV.getInstance().getFeatureTracks()) {
                if (!(t instanceof VariantTrack)) continue;
                ((VariantTrack)t).clearPackedFeatures();
            }
            IGV.getInstance().repaintDataPanels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String addCall(String dbSpecPath, MongoVariantContext mvc) {
        NA12878DBArgumentCollection args = new NA12878DBArgumentCollection(dbSpecPath);
        String errorMessage = null;
        NA12878KnowledgeBase kb = null;
        try {
            kb = new NA12878KnowledgeBase(null, args);
            WriteResult wr = kb.addCall(mvc);
            errorMessage = wr.getError();
        }
        catch (Exception ex) {
            errorMessage = ex.getMessage();
            if (errorMessage == null) {
                errorMessage = "" + ex;
            }
        }
        finally {
            if (kb != null) {
                kb.close();
            }
        }
        return errorMessage;
    }

    private void truthFieldItemStateChanged(ItemEvent e) {
        if (this.truthField.getSelectedItem() == TruthStatus.FALSE_POSITIVE) {
            this.genotypeTypeField.setSelectedItem((Object)GenotypeType.NO_CALL);
            this.genotypeTypeField.setEnabled(false);
        } else {
            this.genotypeTypeField.setEnabled(true);
            this.initGenotypeTypeField(this.variantContext);
        }
    }

    private void initGenotypeTypeField(VariantContext variant) {
        String mutationString = null;
        GenotypeType gtt = GenotypeType.NO_CALL;
        String prefSampleName = VariantReviewPlugin.getPreferentialSampleName();
        for (String sampleName : variant.getSampleNamesOrderedByName()) {
            boolean isPref = sampleName.equalsIgnoreCase(prefSampleName);
            if (isPref || mutationString == null) {
                mutationString = ParsingUtils.join("/", ParsingUtils.sortList(variant.getAlleles()));
                Genotype genotype = variant.getGenotype(sampleName);
                gtt = genotype.getType();
                if (!isPref) continue;
                break;
            }
            if (gtt == variant.getGenotype(sampleName).getType()) continue;
            mutationString = "./.";
            gtt = GenotypeType.UNAVAILABLE;
        }
        this.genotypeTypeField.setSelectedItem((Object)gtt);
        this.mutField.setText(mutationString);
        this.mutField.setToolTipText(mutationString);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.label4 = new JLabel();
        this.callsetField = new JTextField();
        this.hSpacer1 = new JPanel(null);
        this.panel2 = new JPanel();
        this.label5 = new JLabel();
        this.truthField = new JComboBox();
        this.panel3 = new JPanel();
        this.label6 = new JLabel();
        this.genotypeTypeField = new JComboBox();
        this.hSpacer2 = new JPanel(null);
        this.panel7 = new JPanel();
        this.label10 = new JLabel();
        this.mutField = new JLabel();
        this.hSpacer5 = new JPanel(null);
        this.panel4 = new JPanel();
        this.label7 = new JLabel();
        this.chrField = new JLabel();
        this.hSpacer3 = new JPanel(null);
        this.panel5 = new JPanel();
        this.label8 = new JLabel();
        this.startField = new JLabel();
        this.hSpacer4 = new JPanel(null);
        this.panel6 = new JPanel();
        this.label9 = new JLabel();
        this.stopField = new JLabel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(600, 115));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.panel1.setLayout(new BoxLayout(this.panel1, 3));
        this.label4.setText("Callset");
        this.label4.setHorizontalAlignment(0);
        this.label4.setMaximumSize(new Dimension(80, 16));
        this.label4.setAlignmentX(0.5f);
        this.panel1.add(this.label4);
        this.callsetField.setMaximumSize(new Dimension(200, 1000));
        this.callsetField.setMinimumSize(new Dimension(100, 28));
        this.callsetField.setPreferredSize(new Dimension(100, 28));
        this.panel1.add(this.callsetField);
        this.contentPanel.add(this.panel1);
        this.contentPanel.add(this.hSpacer1);
        this.panel2.setLayout(new BoxLayout(this.panel2, 1));
        this.label5.setText("Truth");
        this.label5.setHorizontalAlignment(0);
        this.label5.setLabelFor(this.truthField);
        this.label5.setHorizontalTextPosition(0);
        this.label5.setAlignmentX(0.5f);
        this.panel2.add(this.label5);
        this.truthField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VariantReviewDialog.this.truthFieldItemStateChanged(e);
            }
        });
        this.panel2.add(this.truthField);
        this.contentPanel.add(this.panel2);
        this.panel3.setLayout(new BoxLayout(this.panel3, 1));
        this.label6.setText("Genotype");
        this.label6.setHorizontalAlignment(0);
        this.label6.setAlignmentX(0.5f);
        this.panel3.add(this.label6);
        this.panel3.add(this.genotypeTypeField);
        this.contentPanel.add(this.panel3);
        this.hSpacer2.setMinimumSize(new Dimension(20, 12));
        this.hSpacer2.setPreferredSize(new Dimension(20, 10));
        this.contentPanel.add(this.hSpacer2);
        this.panel7.setMaximumSize(new Dimension(46, 1000));
        this.panel7.setLayout(new BoxLayout(this.panel7, 1));
        this.label10.setText("Mut");
        this.label10.setHorizontalAlignment(2);
        this.label10.setMaximumSize(new Dimension(80, 16));
        this.panel7.add(this.label10);
        this.mutField.setText("A/G");
        this.mutField.setMaximumSize(new Dimension(46, 1000));
        this.panel7.add(this.mutField);
        this.contentPanel.add(this.panel7);
        this.hSpacer5.setMinimumSize(new Dimension(20, 12));
        this.hSpacer5.setPreferredSize(new Dimension(20, 10));
        this.contentPanel.add(this.hSpacer5);
        this.panel4.setMaximumSize(new Dimension(46, 1000));
        this.panel4.setLayout(new BoxLayout(this.panel4, 1));
        this.label7.setText("Chr");
        this.label7.setHorizontalAlignment(2);
        this.label7.setVerticalAlignment(1);
        this.panel4.add(this.label7);
        this.chrField.setText("testChr");
        this.chrField.setAlignmentY(0.0f);
        this.chrField.setMaximumSize(new Dimension(46, 1000));
        this.panel4.add(this.chrField);
        this.contentPanel.add(this.panel4);
        this.hSpacer3.setMinimumSize(new Dimension(20, 12));
        this.hSpacer3.setPreferredSize(new Dimension(20, 10));
        this.contentPanel.add(this.hSpacer3);
        this.panel5.setMaximumSize(new Dimension(500, 1000));
        this.panel5.setMinimumSize(new Dimension(80, 32));
        this.panel5.setPreferredSize(new Dimension(80, 32));
        this.panel5.setLayout(new BoxLayout(this.panel5, 1));
        this.label8.setText("Start");
        this.label8.setHorizontalAlignment(2);
        this.label8.setMaximumSize(new Dimension(100, 16));
        this.panel5.add(this.label8);
        this.startField.setText("54321");
        this.startField.setMaximumSize(new Dimension(500, 1000));
        this.startField.setMinimumSize(new Dimension(80, 16));
        this.startField.setPreferredSize(new Dimension(80, 16));
        this.startField.setHorizontalTextPosition(2);
        this.startField.setHorizontalAlignment(2);
        this.panel5.add(this.startField);
        this.contentPanel.add(this.panel5);
        this.hSpacer4.setMinimumSize(new Dimension(20, 12));
        this.hSpacer4.setPreferredSize(new Dimension(20, 10));
        this.contentPanel.add(this.hSpacer4);
        this.panel6.setMaximumSize(new Dimension(500, 1000));
        this.panel6.setMinimumSize(new Dimension(100, 32));
        this.panel6.setPreferredSize(new Dimension(100, 32));
        this.panel6.setLayout(new BoxLayout(this.panel6, 1));
        this.label9.setText("Stop");
        this.label9.setHorizontalAlignment(2);
        this.label9.setMaximumSize(new Dimension(100, 16));
        this.panel6.add(this.label9);
        this.stopField.setText("12345");
        this.stopField.setMaximumSize(new Dimension(500, 1000));
        this.stopField.setHorizontalTextPosition(10);
        this.stopField.setHorizontalAlignment(2);
        this.stopField.setMinimumSize(new Dimension(100, 16));
        this.stopField.setPreferredSize(new Dimension(100, 16));
        this.panel6.add(this.stopField);
        this.contentPanel.add(this.panel6);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("Save");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariantReviewDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariantReviewDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "Last");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(700, 135);
        this.setLocationRelativeTo(this.getOwner());
    }
}

