/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.FpkmTrackingCodec;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.EncodePeakCodec;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.UCSCGeneTableCodec;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.gwas.EQTLCodec;
import org.broad.igv.peaks.PeakCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broadinstitute.variant.vcf.VCF3Codec;
import org.broadinstitute.variant.vcf.VCFCodec;

public class CodecFactory {
    private static Logger log = Logger.getLogger(CodecFactory.class);
    public static final List<String> validExtensions = new ArrayList<String>(15);

    public static AsciiFeatureCodec getCodec(String path, Genome genome) {
        int l;
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            l = fn.length() - 3;
            fn = fn.substring(0, l);
        }
        if (fn.endsWith(".txt")) {
            l = fn.length() - 4;
            fn = fn.substring(0, l);
        }
        if (fn.endsWith(".vcf3")) {
            return new VCFWrapperCodec(new VCF3Codec(), genome);
        }
        if (fn.endsWith(".vcf4")) {
            return new VCFWrapperCodec(new VCFCodec(), genome);
        }
        if (fn.endsWith(".vcf")) {
            return new VCFWrapperCodec(CodecFactory.getVCFCodec(path), genome);
        }
        if (fn.endsWith(".bed")) {
            IGVBEDCodec codec = new IGVBEDCodec(genome);
            if (fn.endsWith("junctions.bed")) {
                codec.setSpliceJunctions(true);
            }
            return codec;
        }
        if (fn.contains("refflat")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.REFFLAT, genome);
        }
        if (fn.contains("genepred") || fn.contains("ensgene") || fn.contains("refgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.GENEPRED, genome);
        }
        if (fn.contains("ucscgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.UCSCGENE, genome);
        }
        if (fn.endsWith(".rmask") || fn.endsWith(".repmask")) {
            return new REPMaskCodec(genome);
        }
        if (fn.endsWith(".gff3") || fn.endsWith(".gvf")) {
            return new GFFCodec(GFFCodec.Version.GFF3, genome);
        }
        if (fn.endsWith(".gff") || fn.endsWith(".gtf")) {
            return new GFFCodec(genome);
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec(genome);
        }
        if (MUTCodec.isMutationAnnotationFile(path)) {
            return new MUTCodec(path, genome);
        }
        if (fn.endsWith(".narrowpeak") || fn.endsWith(".broadpeak")) {
            return new EncodePeakCodec(genome);
        }
        if (fn.endsWith(".peak")) {
            return new PeakCodec(genome);
        }
        if (fn.endsWith(".eqtl")) {
            return new EQTLCodec(genome);
        }
        if (fn.endsWith("fpkm_tracking")) {
            return new FpkmTrackingCodec(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsciiFeatureCodec getVCFCodec(String path) {
        BufferedReader reader = null;
        try {
            String formatLine;
            reader = path.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BlockCompressedInputStream(org.broad.tribble.util.ParsingUtils.openInputStream(path)))) : ParsingUtils.openBufferedReader(path);
            for (int lineCount = 0; (formatLine = reader.readLine()) != null && lineCount < 20; ++lineCount) {
                String[] tmp;
                if (!formatLine.toLowerCase().startsWith("##fileformat") || (tmp = formatLine.split("=")).length <= 1) continue;
                String version = tmp[1].toLowerCase();
                if (version.startsWith("vcfv3")) {
                    VCF3Codec vCF3Codec = new VCF3Codec();
                    return vCF3Codec;
                }
                VCFCodec vCFCodec = new VCFCodec();
                return vCFCodec;
            }
        }
        catch (IOException e) {
            log.error("Error checking VCF Version");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new VCFCodec();
    }

    static {
        validExtensions.addAll(Arrays.asList("vcf4", "vcf", "bed", "refflat", "genepred", "ensgene", "refgene", "ucscgene", "repmask", "gff3", "gvf", "gff", "gtf", "psl", "mut", "maf"));
    }
}

