/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksCodec;
import org.broad.igv.data.cufflinks.FPKMValue;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;

public class FpkmTrackingCodec
extends CufflinksCodec<FPKMValue> {
    private static Logger log = Logger.getLogger(FpkmTrackingCodec.class);
    int geneColumn = 4;
    int locusColumn = 6;
    int fpkmColumn = 9;
    int confLoColumn = 10;
    int confHiColumn = 11;

    public FpkmTrackingCodec(String path) {
        super(FPKMValue.class, path);
    }

    @Override
    public Object readHeader(String[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            String tk = tokens[i];
            if (tk.equals("locus")) {
                this.locusColumn = i;
                continue;
            }
            if (tk.equals("gene_short_name")) {
                this.geneColumn = i;
                continue;
            }
            if (tk.equals("FPKM")) {
                this.fpkmColumn = i;
                continue;
            }
            if (tk.equals("FPKM_conf_lo")) {
                this.confLoColumn = i;
                continue;
            }
            if (!tk.startsWith("FPKM_conf_hi")) continue;
            this.confHiColumn = i;
        }
        return tokens;
    }

    @Override
    public FPKMValue decode(String line) {
        return this.decode(ParsingUtils.TAB_PATTERN.split(line));
    }

    @Override
    public FPKMValue decode(String[] tokens) {
        if (tokens[0].equalsIgnoreCase("tracking_id") || tokens[this.geneColumn].equalsIgnoreCase("gene_short_name")) {
            return null;
        }
        if (tokens.length >= 12) {
            String locusString = tokens[this.locusColumn];
            if (locusString == null) {
                return null;
            }
            Locus locus = new Locus(locusString);
            if (locus.getChr() == null) {
                return null;
            }
            float fpkm = Float.parseFloat(tokens[this.fpkmColumn]);
            float confLo = Float.parseFloat(tokens[this.confLoColumn]);
            float confHi = Float.parseFloat(tokens[this.confHiColumn]);
            String gene = tokens[this.geneColumn];
            return new FPKMValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), fpkm, confLo, confHi);
        }
        log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
        return null;
    }
}

