/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksCodec;
import org.broad.igv.data.cufflinks.ExpDiffValue;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;

public class ExpDiffCodec
extends CufflinksCodec<ExpDiffValue> {
    private static Logger log = Logger.getLogger(ExpDiffCodec.class);
    int geneColumn = 1;
    int locusColumn = 2;
    int xColumn = 6;
    int yColumn = 7;
    int logRatioColumn = 8;
    int sigColumn = 12;

    public ExpDiffCodec(String path) {
        super(ExpDiffValue.class, path);
    }

    @Override
    public Object readHeader(String[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            String tk = tokens[i];
            if (tk.equals("locus")) {
                this.locusColumn = i;
                continue;
            }
            if (tk.equals("gene")) {
                this.geneColumn = i;
                continue;
            }
            if (tk.equals("value_1")) {
                this.xColumn = i;
                continue;
            }
            if (tk.equals("value_2")) {
                this.yColumn = i;
                continue;
            }
            if (tk.startsWith("log2(")) {
                this.logRatioColumn = i;
                continue;
            }
            if (!tk.equals("significant")) continue;
            this.sigColumn = i;
        }
        return tokens;
    }

    @Override
    public ExpDiffValue decode(String[] tokens) {
        if (tokens[0].equalsIgnoreCase("test_id") || tokens[this.geneColumn].equalsIgnoreCase("gene_id")) {
            return null;
        }
        if (tokens.length >= this.sigColumn) {
            String locusString = tokens[this.locusColumn];
            if (locusString == null) {
                return null;
            }
            Locus locus = new Locus(locusString);
            if (locus.getChr() == null) {
                return null;
            }
            String logRatioStr = tokens[this.logRatioColumn];
            float logRatio = Float.parseFloat(logRatioStr);
            if (Float.isInfinite(logRatio) || Float.isNaN(logRatio)) {
                log.info("LogRatio " + logRatioStr + " cannot be parsed as a float");
                logRatio = Float.NaN;
            }
            float fpkmX = Float.parseFloat(tokens[this.xColumn]);
            float fpkmY = Float.parseFloat(tokens[this.yColumn]);
            String gene = tokens[this.geneColumn];
            String significant = tokens[this.sigColumn];
            return new ExpDiffValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), logRatio, fpkmX, fpkmY, significant);
        }
        log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
        return null;
    }

    @Override
    public ExpDiffValue decode(String line) {
        return this.decode(ParsingUtils.TAB_PATTERN.split(line));
    }
}

