/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.data.cufflinks.ExpDiffCodec;
import org.broad.igv.data.cufflinks.FpkmTrackingCodec;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;

public class CufflinksParser {
    public static List<? extends CufflinksValue> parse(String path) throws IOException {
        String s = path.toLowerCase();
        if (s.endsWith("fpkm_tracking")) {
            FpkmTrackingCodec codec = new FpkmTrackingCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        if (s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff")) {
            ExpDiffCodec codec = new ExpDiffCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        throw new RuntimeException("Unsupported file type: " + path);
    }

    private static <T extends CufflinksValue> List<T> parse(AsciiFeatureCodec<T> codec, String path) throws IOException {
        ArrayList values = new ArrayList();
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(path, codec, false);
        CloseableTribbleIterator iter = reader.iterator();
        while (iter.hasNext()) {
            values.add(iter.next());
        }
        return values;
    }
}

