/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.readers.LineReader;

public abstract class CufflinksCodec<T extends CufflinksValue>
extends AsciiFeatureCodec<T> {
    private static Logger log = Logger.getLogger(CufflinksCodec.class);
    String path;

    protected CufflinksCodec(Class<T> clazz, String path) {
        super(clazz);
        this.path = path;
    }

    protected abstract Object readHeader(String[] var1);

    @Override
    public Object readHeader(LineReader reader) {
        String headerLine = null;
        try {
            headerLine = reader.readLine();
            String[] tokens = ParsingUtils.TAB_PATTERN.split(headerLine);
            return this.readHeader(tokens);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            throw new DataLoadException("Error reading header: " + e.getMessage(), this.path);
        }
    }
}

