/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.tribble.Feature;

public class CombinedDataSource
implements DataSource {
    DataSource source1;
    DataSource source2;
    Operation operation = Operation.ADD;

    CombinedDataSource(DataSource source1, DataSource source2, Operation operation) {
        this.source1 = source1;
        this.source2 = source2;
        this.operation = operation;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        float newVal;
        List<LocusScore> outerScores = this.source1.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        List<LocusScore> innerScores = this.source2.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        int initialSize = outerScores.size() + innerScores.size();
        ArrayList<LocusScore> combinedScoresList = new ArrayList<LocusScore>(initialSize);
        if (initialSize == 0) {
            return combinedScoresList;
        }
        if (innerScores.size() == 0) {
            return outerScores;
        }
        if (outerScores.size() == 0) {
            return innerScores;
        }
        if (outerScores.get(0).getStart() > innerScores.get(0).getStart()) {
            List<LocusScore> tmp = innerScores;
            innerScores = outerScores;
            outerScores = tmp;
        }
        int firstInnerStart = innerScores.get(0).getStart();
        Feature lastScoreAdded = null;
        int highestInnerIdx = -1;
        for (LocusScore outerScore : outerScores) {
            int outerStart = outerScore.getStart();
            int outerEnd = outerScore.getEnd();
            highestInnerIdx = -1;
            if (firstInnerStart > outerStart) {
                int newEnd = Math.min(outerEnd, firstInnerStart);
                newVal = this.combineScores(outerScore, null);
                lastScoreAdded = new BasicScore(outerStart, newEnd, newVal);
                combinedScoresList.add((LocusScore)lastScoreAdded);
                if (firstInnerStart >= outerEnd) continue;
            }
            for (LocusScore innerScore : innerScores) {
                if (innerScore.getStart() >= outerEnd) break;
                ++highestInnerIdx;
                if (innerScore.getEnd() <= outerStart) continue;
                int nextStart = Math.max(outerStart, innerScore.getStart());
                int nextEnd = Math.min(outerEnd, innerScore.getEnd());
                float nextVal = this.combineScores(outerScore, innerScore);
                lastScoreAdded = new BasicScore(nextStart, nextEnd, nextVal);
                combinedScoresList.add((LocusScore)lastScoreAdded);
            }
        }
        LocusScore innerTail = innerScores.get(highestInnerIdx);
        if (lastScoreAdded != null && lastScoreAdded.getEnd() < innerTail.getEnd()) {
            int combinedStart = Math.min(lastScoreAdded.getEnd(), innerTail.getEnd());
            BasicScore newTail = new BasicScore(combinedStart, innerTail.getEnd(), innerTail.getScore());
            combinedScoresList.add(newTail);
            for (LocusScore innerScore : innerScores.subList(highestInnerIdx + 1, innerScores.size())) {
                newVal = this.combineScores(null, innerScore);
                combinedScoresList.add(new BasicScore(innerScore.getStart(), innerScore.getEnd(), newVal));
            }
        }
        return combinedScoresList;
    }

    private float combineScores(LocusScore score1, LocusScore score2) {
        if (score1 == null && score2 == null) {
            throw new IllegalArgumentException("Both inputs cannot be null");
        }
        if (score1 == null) {
            score1 = new BasicScore(score2.getStart(), score2.getEnd(), 0.0f);
        } else if (score2 == null) {
            score2 = new BasicScore(score1.getStart(), score1.getEnd(), 0.0f);
        }
        switch (this.operation) {
            case ADD: {
                return score1.getScore() + score2.getScore();
            }
            case SUBTRACT: {
                return score1.getScore() - score2.getScore();
            }
        }
        throw new IllegalStateException("Operation not recognized: " + (Object)((Object)this.operation));
    }

    @Override
    public double getDataMax() {
        return 0.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public TrackType getTrackType() {
        return null;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return null;
    }

    static class MergedIterator
    implements Iterator<LocusScore> {
        Iterator i1;
        Iterator i2;
        LocusScore next1;
        LocusScore next2;

        MergedIterator(Iterator<LocusScore> i1, Iterator<LocusScore> i2) {
            this.i1 = i1;
            this.i2 = i2;
            if (i1.hasNext()) {
                this.next1 = i1.next();
            }
            if (i2.hasNext()) {
                this.next2 = i2.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next1 != null || this.next2 != null;
        }

        @Override
        public LocusScore next() {
            if (this.next1 == null) {
                return this.next2;
            }
            if (this.next2 == null) {
                return this.next1;
            }
            if (this.next2.getStart() < this.next1.getStart()) {
                return this.next2;
            }
            return this.next1;
        }

        @Override
        public void remove() {
        }
    }

    static enum Operation {
        ADD("+"),
        SUBTRACT("-");

        private String stringRep;

        private Operation(String stringrep) {
            this.stringRep = stringrep;
        }
    }
}

