/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin.ui;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.WordUtils;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.ui.BoolArgument;
import org.broad.igv.cli_plugin.ui.MultiTrackArgument;
import org.broad.igv.cli_plugin.ui.TextArgument;
import org.broad.igv.cli_plugin.ui.TrackArgument;

public class ArgumentPanel
extends JPanel {
    private JLabel argName;

    public ArgumentPanel() {
        this.initComponents();
    }

    public Object getValue() {
        return null;
    }

    void setArgName(String newName) {
        this.argName.setText(newName);
    }

    public static ArgumentPanel create(Argument argument) {
        ArgumentPanel panel = null;
        switch (argument.getType()) {
            case BOOL: {
                panel = new BoolArgument(argument);
                break;
            }
            case LONGTEXT: 
            case TEXT: {
                panel = new TextArgument(argument);
                break;
            }
            case DATA_TRACK: 
            case ALIGNMENT_TRACK: 
            case FEATURE_TRACK: {
                panel = new TrackArgument(argument);
                break;
            }
            case MULTI_FEATURE_TRACK: {
                panel = new MultiTrackArgument(argument);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not create ArgumentPanel for argument of type " + (Object)((Object)argument.getType()));
            }
        }
        return panel;
    }

    private String[] capWords(String[] values) {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = WordUtils.capitalize(values[ii]);
        }
        return values;
    }

    protected final void initCommon(Argument argument) {
        if (argument != null) {
            this.argName.setText(argument.getName() + ":");
        }
    }

    private void initComponents() {
        this.argName = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.argName.setText("Argument: ");
        this.argName.setRequestFocusEnabled(false);
        this.argName.setMinimumSize(new Dimension(80, 16));
        this.add(this.argName);
    }
}

