/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.blat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;

public class BlatTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"chr", "start", "end", "strand", "score", "match", "mis-match", "rep. match", "N's", "Q gap count", "Q gap bases", "T gap count", "T gap bases"};
    List<PSLRecord> records;

    public BlatTableModel(List<PSLRecord> records) {
        this.records = records;
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PSLRecord record = this.records.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return record.getChr();
            }
            case 1: {
                return record.getStart();
            }
            case 2: {
                return record.getEnd();
            }
            case 3: {
                return record.getStrand() == Strand.POSITIVE ? "+" : "-";
            }
            case 4: {
                return (int)record.getScore();
            }
            case 5: {
                return record.getMatch();
            }
            case 6: {
                return record.getMisMatch();
            }
            case 7: {
                return record.getRepMatch();
            }
            case 8: {
                return record.getNs();
            }
            case 9: {
                return record.getQGapCount();
            }
            case 10: {
                return record.getQGapBases();
            }
            case 11: {
                return record.getTGapCount();
            }
            case 12: {
                return record.getTGapBases();
            }
        }
        return "?";
    }

    public String getChr(int rowIndex) {
        PSLRecord record = this.records.get(rowIndex);
        return record.getChr();
    }

    public int getStart(int rowIndex) {
        PSLRecord record = this.records.get(rowIndex);
        return record.getStart();
    }

    public int getEnd(int rowIndex) {
        PSLRecord record = this.records.get(rowIndex);
        return record.getEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File f) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            for (PSLRecord record : this.records) {
                pw.println(record.getText());
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }
}

